/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.main;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import elec332.core.api.APIHandlerInject;
import elec332.core.api.IAPIHandler;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IASMDataProcessor;
import elec332.core.api.discovery.IAdvancedASMData;
import elec332.core.api.registration.NamedFieldGetter;
import elec332.core.api.world.IWorldGenManager;
import elec332.core.java.ReflectionHelper;
import elec332.core.main.ElecCore;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.LoaderState;

@ASMDataProcessor(value={LoaderState.CONSTRUCTING})
public enum APIHandler implements IASMDataProcessor,
IAPIHandler
{
    INSTANCE;

    private final SetMultimap<Class<?>, Consumer<?>> callBacks = HashMultimap.create();
    @APIHandlerInject
    static IWorldGenManager worldGenManager;

    @Override
    public void processASMData(IASMDataHelper asmData, LoaderState state) {
        this.collect(asmData, APIHandlerInject.class);
        this.inject(INSTANCE, IAPIHandler.class);
        this.inject(ElecCore.instance.asmDataProcessor.asmDataHelper, IASMDataHelper.class);
        for (IAdvancedASMData data : asmData.getAdvancedAnnotationList(StaticLoad.class)) {
            data.loadClass();
        }
        APIHandler.injectFields(asmData);
    }

    private void collect(IASMDataHelper asmData, Class<? extends Annotation> annotationClass) {
        for (final IAdvancedASMData data : asmData.getAdvancedAnnotationList(annotationClass)) {
            Consumer<Object> ret;
            Class<?> type;
            if (data.isMethod()) {
                Class<?>[] params = data.getMethodParameters();
                if (params.length > 1 || params.length < 0) {
                    ElecCore.logger.error("Skipping invalid API method: " + data.getClassName() + " " + data.getMethodName());
                }
                type = params[0];
                ret = new Consumer<Object>(){

                    @Override
                    public void accept(Object o) {
                        if (!ReflectionHelper.isStatic(data.getMethod())) {
                            ElecCore.logger.error("Method " + data.getClassName() + " " + data.getMethodName() + " is not static! it will be skipped...");
                            return;
                        }
                        try {
                            data.getMethod().invoke(null, o);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            } else {
                type = data.getFieldType();
                ret = new Consumer<Object>(){

                    @Override
                    public void accept(Object o) {
                        if (!ReflectionHelper.isStatic(data.getField())) {
                            ElecCore.logger.error("Field " + data.getClassName() + " " + data.getFieldName() + " is not static! it will be skipped...");
                            return;
                        }
                        try {
                            EnumHelper.setFailsafeFieldValue((Field)data.getField(), null, (Object)o);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            this.callBacks.put(Preconditions.checkNotNull(type), Preconditions.checkNotNull((Object)ret));
        }
    }

    @Override
    public void inject(Object o, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(o.getClass())) {
                throw new IllegalArgumentException();
            }
            for (Consumer consumer : this.callBacks.removeAll(clazz)) {
                consumer.accept(o);
            }
        }
    }

    private static void injectFields(IASMDataHelper asmData) {
        AnnotatedElement c;
        HashMap definitionMap = Maps.newHashMap();
        HashMap namedFieldGetters = Maps.newHashMap();
        for (IAdvancedASMData iAdvancedASMData : asmData.getAdvancedAnnotationList(NamedFieldGetter.Definition.class)) {
            c = iAdvancedASMData.loadClass();
            definitionMap.put(c, ((Class)c).getAnnotation(NamedFieldGetter.Definition.class));
        }
        for (IAdvancedASMData iAdvancedASMData : asmData.getAdvancedAnnotationList(NamedFieldGetter.class)) {
            c = iAdvancedASMData.getField();
            namedFieldGetters.put(((Field)c).getAnnotation(NamedFieldGetter.class), c);
        }
        for (Map.Entry entry : namedFieldGetters.entrySet()) {
            Class<Object> dec;
            Field f = (Field)entry.getValue();
            NamedFieldGetter nfg = (NamedFieldGetter)entry.getKey();
            NamedFieldGetter.Definition definition = (NamedFieldGetter.Definition)definitionMap.get(((Field)entry.getValue()).getDeclaringClass());
            String field = nfg.field();
            if (Strings.isNullOrEmpty((String)field)) {
                String string = field = definition == null ? null : definition.field();
                if (Strings.isNullOrEmpty((String)field)) {
                    throw new RuntimeException("Class: " + ((Field)entry.getValue()).getDeclaringClass() + " field: " + entry.getValue());
                }
            }
            if ((dec = nfg.declaringClass()) == Object.class) {
                Class clazz = dec = definition == null ? Object.class : definition.declaringClass();
                if (dec == Object.class) {
                    throw new RuntimeException("Class: " + ((Field)entry.getValue()).getDeclaringClass() + " field: " + entry.getValue());
                }
            }
            try {
                String[] poss = field.split(",");
                Field nameField = null;
                for (String s : poss) {
                    try {
                        nameField = f.getType().getDeclaredField(s);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (nameField == null) {
                    throw new RuntimeException("Unable to find: " + field);
                }
                for (Field fDec : dec.getDeclaredFields()) {
                    Object o;
                    String name;
                    if (fDec.getType() != f.getType() || !(name = (String)nameField.get(o = fDec.get(null))).equals(nfg.name())) continue;
                    f.set(null, o);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StaticLoad {
    }
}

