/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.loading.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.api.client.model.loading.IBlockModelHandler;
import elec332.core.api.client.model.loading.IModelHandler;
import elec332.core.api.client.model.loading.ModelHandler;
import elec332.core.client.model.RenderingRegistry;
import elec332.core.main.ElecCore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;

@ModelHandler
public class BlockModelHandler
implements IModelHandler {
    private List<IBlockModelHandler> blockModelHandlers = Lists.newArrayList();
    private Map<IBlockState, ModelResourceLocation> blockResourceLocations = Maps.newHashMap();

    @Override
    public void getModelHandlers(List<?> list) {
        for (Object o : list) {
            if (!(o instanceof IBlockModelHandler)) continue;
            this.blockModelHandlers.add((IBlockModelHandler)o);
        }
    }

    @Override
    public void registerModels() {
        ElecCore.logger.info("Prehandling Block Models");
        ModelManager modelManager = Minecraft.func_71410_x().field_175617_aL;
        block0: for (Block block : RenderingRegistry.instance().getAllValidBlocks()) {
            for (final IBlockModelHandler handler : this.blockModelHandlers) {
                if (!handler.handleBlock(block)) continue;
                modelManager.func_174954_c().func_178120_a().func_178447_a(block, (IStateMapper)new StateMapperBase(){

                    @Nonnull
                    protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
                        ModelResourceLocation mrl = new ModelResourceLocation(state.func_177230_c().getRegistryName().toString() + "#" + handler.getIdentifier(state));
                        BlockModelHandler.this.blockResourceLocations.put(state, mrl);
                        return mrl;
                    }
                });
                continue block0;
            }
        }
    }

    @Override
    public Map<ModelResourceLocation, IBakedModel> registerBakedModels(Function<ModelResourceLocation, IBakedModel> modelGetter) {
        HashMap ret = Maps.newHashMap();
        block0: for (Map.Entry<IBlockState, ModelResourceLocation> entry : this.blockResourceLocations.entrySet()) {
            ModelResourceLocation mrl = entry.getValue();
            for (IBlockModelHandler handler : this.blockModelHandlers) {
                if (!handler.handleBlock(entry.getKey().func_177230_c())) continue;
                ret.put(mrl, handler.getModelFor(entry.getKey(), mrl.func_177518_c(), mrl));
                continue block0;
            }
        }
        return ret;
    }
}

