/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.abstraction;

import com.google.common.primitives.Primitives;
import elec332.core.abstraction.abstracted.IAbstractionType;
import elec332.core.util.ASMHelper;
import java.lang.reflect.Constructor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class AbstractionHandler {
    public static <T, I extends IForgeRegistryEntry<I>> I registerAbstractionObject(T item, ResourceLocation name, IAbstractionType<T, I> type) {
        return AbstractionHandler.registerAbstractionObject(item, name, type, null, new Object[0]);
    }

    public static <T, I extends IForgeRegistryEntry<I>> I registerAbstractionObject(T item, ResourceLocation name, IAbstractionType<T, I> type, Class<? extends I> baseTypeP, Object ... params) {
        IForgeRegistryEntry ret;
        if (!type.getAbstractionType().isInstance(item)) {
            throw new IllegalArgumentException();
        }
        Class<Object> baseType = baseTypeP == null ? type.getBaseType() : baseTypeP;
        Object[] constructorParams = params == null || params.length == 0 ? type.getParams(item) : params;
        for (Class<T> clazz : item.getClass().getInterfaces()) {
            if (clazz == type.getAbstractionType() || clazz.isAssignableFrom(type.getAbstractionType()) || !clazz.isAssignableFrom(type.getAbstractionType())) continue;
            throw new IllegalArgumentException();
        }
        Class<I> clazz = ASMHelper.makeImplementInterfaces(baseType, item.getClass(), type.getClassModifier(), type.getAbstractionType(), type.getInterfaceExclusion(), type.getAbstractionType());
        try {
            Class[] ctorz = new Class[constructorParams.length + 1];
            Object[] objectArray = new Object[constructorParams.length + 1];
            ctorz[0] = Object.class;
            objectArray[0] = item;
            for (int i = 0; i < constructorParams.length; ++i) {
                ctorz[i + 1] = Primitives.unwrap(constructorParams[i].getClass());
                objectArray[i + 1] = constructorParams[i];
            }
            Constructor<I> cTor = clazz.getDeclaredConstructor(ctorz);
            ret = (IForgeRegistryEntry)cTor.newInstance(objectArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ret.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)ret);
        return (I)ret;
    }
}

