/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry.recipes;

import forestry.api.recipes.IFermenterRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipe
implements IFermenterRecipe {
    private final ItemStack resource;
    private final int fermentationValue;
    private final float modifier;
    private final Fluid output;
    private final FluidStack fluidResource;

    public FermenterRecipe(ItemStack resource, int fermentationValue, float modifier, Fluid output, FluidStack fluidResource) {
        if (resource == null) {
            throw new NullPointerException("Fermenter Resource cannot be null!");
        }
        if (output == null) {
            throw new NullPointerException("Fermenter Output cannot be null!");
        }
        if (fluidResource == null) {
            throw new NullPointerException("Fermenter Liquid cannot be null!");
        }
        if (fluidResource.getFluid().getName().equals("fluid.honey")) {
            fluidResource = new FluidStack(FluidRegistry.getFluid((String)"fluid.for.honey"), fluidResource.amount);
        }
        this.resource = resource;
        this.fermentationValue = fermentationValue;
        this.modifier = modifier;
        this.output = output;
        this.fluidResource = fluidResource;
    }

    public ItemStack getResource() {
        return this.resource;
    }

    public FluidStack getFluidResource() {
        return this.fluidResource;
    }

    public int getFermentationValue() {
        return this.fermentationValue;
    }

    public float getModifier() {
        return this.modifier;
    }

    public Fluid getOutput() {
        return this.output;
    }
}

