/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.ISqueezerManager;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.jei.squeezer.SqueezerRecipeWrapper;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.mc1102.item.MCItemStack;
import modtweaker.mods.forestry.ForestryListAddition;
import modtweaker.mods.forestry.ForestryListRemoval;
import modtweaker.mods.forestry.recipes.SqueezerRecipe;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Squeezer")
public class Squeezer {
    public static final String name = "Forestry Squeezer";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, IItemStack[] ingredients, int timePerItem, @Optional WeightedItemStack itemOutput) {
        if (itemOutput == null) {
            itemOutput = new WeightedItemStack((IItemStack)new MCItemStack(new ItemStack(Blocks.field_150350_a)), 0.0f);
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new SqueezerRecipe(timePerItem, InputHelper.toStacks((IItemStack[])ingredients), InputHelper.toFluid((ILiquidStack)fluidOutput), InputHelper.toStack((IItemStack)itemOutput.getStack()), itemOutput.getChance())));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient liquid, @Optional IIngredient[] ingredients) {
        LinkedList<ISqueezerRecipe> recipes = new LinkedList<ISqueezerRecipe>();
        for (ISqueezerRecipe r : RecipeManagers.squeezerManager.recipes()) {
            if (r == null || r.getFluidOutput() == null || !StackHelper.matches((IIngredient)liquid, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)r.getFluidOutput()))) continue;
            if (ingredients != null) {
                boolean matched = false;
                for (int i = 0; i < ingredients.length; ++i) {
                    if (!StackHelper.matches((IIngredient)ingredients[i], (IItemStack)InputHelper.toIItemStack((ItemStack)r.getResources()[i]))) {
                        matched = false;
                        break;
                    }
                    matched = true;
                }
                if (!matched) continue;
                recipes.add(r);
                continue;
            }
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription((IIngredient)liquid)));
        }
    }

    private static class Remove
    extends ForestryListRemoval<ISqueezerRecipe, ISqueezerManager> {
        public Remove(List<ISqueezerRecipe> recipes) {
            super(Squeezer.name, RecipeManagers.squeezerManager, recipes);
        }

        @Override
        public String getRecipeInfo(ISqueezerRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getFluidOutput());
        }

        @Override
        public IRecipeWrapper wrapRecipe(ISqueezerRecipe recipe) {
            return new SqueezerRecipeWrapper(recipe);
        }
    }

    private static class Add
    extends ForestryListAddition<ISqueezerRecipe> {
        public Add(ISqueezerRecipe recipe) {
            super(Squeezer.name, (ICraftingProvider)RecipeManagers.squeezerManager);
            this.recipes.add(recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new SqueezerRecipeWrapper(recipe));
        }

        @Override
        public String getRecipeInfo(ISqueezerRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getFluidOutput());
        }

        @Override
        public IRecipeWrapper wrapRecipe(ISqueezerRecipe recipe) {
            return new SqueezerRecipeWrapper(recipe);
        }
    }
}

