/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.actuallyadditions.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.actuallyadditions.Crusher")
public class Crusher {
    protected static final String name = "Actually Additions Crusher";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack outputOne, @Optional IItemStack outputTwo, @Optional int outputTwoChance) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new CrusherRecipe(InputHelper.toStack((IItemStack)input), InputHelper.toStack((IItemStack)outputOne), InputHelper.toStack((IItemStack)outputTwo), outputTwoChance)));
    }

    @ZenMethod
    public static void remove(IIngredient input) {
        LinkedList<CrusherRecipe> recipes = new LinkedList<CrusherRecipe>();
        if (input == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        for (CrusherRecipe recipe : ActuallyAdditionsAPI.CRUSHER_RECIPES) {
            if (!StackHelper.matches((IIngredient)input, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.inputStack))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, input.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<CrusherRecipe> {
        public Remove(List<CrusherRecipe> recipes) {
            super(Crusher.name, ActuallyAdditionsAPI.CRUSHER_RECIPES, recipes);
        }

        protected String getRecipeInfo(CrusherRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.inputStack);
        }
    }

    private static class Add
    extends BaseListAddition<CrusherRecipe> {
        public Add(CrusherRecipe recipe) {
            super(Crusher.name, ActuallyAdditionsAPI.CRUSHER_RECIPES);
            this.recipes.add(recipe);
        }

        public String getRecipeInfo(CrusherRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.inputStack);
        }
    }
}

