/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.tileentity;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankHelper;

public class TileEntityEnderTank
extends TileEntityBase
implements IFluidHandler,
IRGB16_Tile {
    private String code = "000";
    private UUID ownerID = null;
    private String owner = "all";
    private ItemStack personalItem;
    private final ArrayList<ItemStack> pumpUpgrades = new ArrayList();
    public boolean rayTracing = false;
    public int tracePart = 0;
    public long lastclick = 0L;

    public void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("code", this.getCode());
        nbtTag.func_74778_a("owner", this.owner);
        if (this.ownerID != null) {
            nbtTag.func_74778_a("ownerID", this.ownerID.toString());
        }
        if (!this.pumpUpgrades.isEmpty()) {
            NBTTagList listItems = new NBTTagList();
            for (ItemStack stack : this.pumpUpgrades) {
                NBTTagCompound compound = new NBTTagCompound();
                stack.func_77955_b(compound);
                listItems.func_74742_a((NBTBase)compound);
            }
            nbtTag.func_74782_a("PumpUpgrades", (NBTBase)listItems);
        }
        if (this.personalItem != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.personalItem.func_77955_b(compound);
            nbtTag.func_74782_a("PersonalUpgrade", (NBTBase)compound);
        }
    }

    public void processNBT(NBTTagCompound nbtTag) {
        this.setCode(nbtTag.func_74779_i("code"));
        this.owner = nbtTag.func_74779_i("owner");
        if (nbtTag.func_74764_b("ownerID")) {
            this.ownerID = UUID.fromString(nbtTag.func_74779_i("ownerID"));
        }
        if (nbtTag.func_74764_b("PumpUpgrades")) {
            this.pumpUpgrades.clear();
            NBTTagList listItems = nbtTag.func_150295_c("PumpUpgrades", 10);
            for (int entry = 0; entry < listItems.func_74745_c(); ++entry) {
                NBTTagCompound compound = listItems.func_150305_b(entry);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)compound);
                if (stack == null) continue;
                if (stack.field_77994_a != 1) {
                    stack.field_77994_a = 1;
                }
                this.pumpUpgrades.add(stack);
            }
        } else if (nbtTag.func_74764_b("pump")) {
            for (byte x = 0; x < nbtTag.func_74771_c("pump"); x = (byte)(x + 1)) {
                this.pumpUpgrades.add(new ItemStack((Block)Blocks.field_150331_J));
            }
        }
        if (nbtTag.func_74764_b("PersonalUpgrade")) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l("PersonalUpgrade"));
            if (stack != null && stack.field_77994_a != 1) {
                stack.field_77994_a = 1;
            }
            this.personalItem = stack;
        }
    }

    public void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        FluidTankInfo tankInfo = this.getTankInfo();
        if (tankInfo.fluid != null) {
            nbtTag.func_74778_a("liquid", tankInfo.fluid.getFluid().getLocalizedName(tankInfo.fluid));
            nbtTag.func_74768_a("amount", tankInfo.fluid.amount);
            nbtTag.func_74768_a("capacity", this.getTank().getCapacity());
        } else {
            nbtTag.func_74778_a("liquid", "NONE");
        }
    }

    public void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (this.ownerID != null && UsernameCache.containsUUID((UUID)this.ownerID)) {
            this.owner = UsernameCache.getLastKnownUsername((UUID)this.ownerID);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.canInteractFromFace(facing) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.canInteractFromFace(facing)) {
            return (T)this.getTank();
        }
        return (T)super.getCapability(capability, facing);
    }

    private boolean canInteractFromFace(EnumFacing facing) {
        EnumFacing tFacing = BlockEnderTank.getFacing(this.func_145831_w().func_180495_p(this.func_174877_v()));
        return facing == null || tFacing.func_176740_k() == facing.func_176740_k();
    }

    public FluidTank getTank() {
        return TankHelper.getTank(this.getOwnerID(), this.getCode(), this.func_145831_w().field_72995_K);
    }

    public int fill(EnumFacing facing, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canInteractFromFace(facing) || !this.getTank().canFillFluidType(resource)) {
            return 0;
        }
        return this.getTank().fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing facing, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canInteractFromFace(facing) || !this.getTank().canDrainFluidType(resource)) {
            return null;
        }
        return this.getTank().drain(resource, doDrain);
    }

    public FluidStack drain(EnumFacing facing, int amount, boolean doDrain) {
        FluidStack resource = this.getTank().getFluid();
        if (resource == null || amount < 1) {
            return null;
        }
        resource = resource.copy();
        resource.amount = amount;
        return this.drain(facing, resource, doDrain);
    }

    public boolean canFill(EnumFacing facing, Fluid fluid) {
        return this.canInteractFromFace(facing) && this.getTank().canFill();
    }

    public boolean canDrain(EnumFacing facing, Fluid fluid) {
        return this.canInteractFromFace(facing) && this.getTank().canDrain();
    }

    public FluidTankInfo[] getTankInfo(EnumFacing facing) {
        return new FluidTankInfo[]{this.getTankInfo()};
    }

    public FluidTankInfo getTankInfo() {
        return this.getTank().getInfo();
    }

    public int getPumpCapacity() {
        return this.pumpUpgrades.isEmpty() ? 250 : this.pumpUpgrades.size() * 1000;
    }

    public byte getPumpUpgradeCount() {
        return (byte)this.pumpUpgrades.size();
    }

    public void addPumpUpgrade(ItemStack stack) {
        this.pumpUpgrades.add(stack);
    }

    public boolean canEdit(EntityPlayer player) {
        return this.isPublic() || player.field_71075_bZ.field_75098_d || this.ownerID != null && this.ownerID.equals(player.func_110124_au());
    }

    public String getOwnerID() {
        if (this.owner.equalsIgnoreCase("all")) {
            return "all";
        }
        if (this.ownerID != null) {
            return this.ownerID.toString().toLowerCase();
        }
        return this.owner;
    }

    public String getOwnerName() {
        if (this.owner.equalsIgnoreCase("all")) {
            return "all";
        }
        return this.owner;
    }

    public void setOwner(EntityPlayer player, ItemStack stack) {
        this.personalItem = stack;
        this.owner = player.getDisplayNameString();
        this.ownerID = player.func_110124_au();
    }

    public void setOwner(String ownerName, UUID ownerID, ItemStack stack) {
        if (ownerID != null) {
            this.personalItem = stack;
            this.owner = ownerName;
            this.ownerID = ownerID;
        }
    }

    public ItemStack getPersonalItem() {
        if (this.personalItem != null) {
            if (this.personalItem.field_77994_a != 1) {
                this.personalItem.field_77994_a = 1;
            }
            return this.personalItem;
        }
        return null;
    }

    public ArrayList<ItemStack> getPumpUpgrades() {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        if (!this.pumpUpgrades.isEmpty()) {
            for (ItemStack stack : this.pumpUpgrades) {
                if (stack == null) continue;
                if (stack.field_77994_a != 1) {
                    stack.field_77994_a = 1;
                }
                upgrades.add(stack);
            }
        }
        return upgrades;
    }

    public boolean isPublic() {
        return this.owner.equalsIgnoreCase("all");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code.toUpperCase();
    }

    public void setCode(String code) {
        while (code.length() < 3) {
            code = "0" + code;
        }
        this.code = code.toUpperCase();
    }

    public boolean hasError() {
        return !this.isPublic() && this.ownerID == null;
    }

    public RGB16 getRGB16(EntityPlayer player) {
        int ring = this.getRingHit(player);
        if (ring < 0) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(EnumDyeColor.func_176764_b((int)value).func_176610_l());
    }

    public boolean setRGB16(short rgbIndex, EntityPlayer player) {
        return this.doColorRing(EnumDyeColor.func_176764_b((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(EnumDyeColor color, EntityPlayer player) {
        if (!this.canEdit(player)) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0) {
            return false;
        }
        char charColor = Integer.toHexString(color.func_176765_a()).charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Function.syncTile((TileEntity)this);
            return true;
        }
        return false;
    }

    private int getRingHit(EntityPlayer player) {
        Function.BlockInfo info = Function.getBlockInfront((World)this.func_145831_w(), (EntityPlayer)player, (double)5.0);
        if (info == null || info.sub < 1 || info.sub > 3) {
            return -1;
        }
        return info.sub - 1;
    }
}

