/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.bpt.proxy;

import com.mrdimka.bpt.BiomePaintTools;
import com.mrdimka.bpt.client.PencilColorHandler;
import com.mrdimka.bpt.proxy.CommonProxy;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class ClientProxy
extends CommonProxy {
    @Override
    public void init() {
        ClientProxy.registerRenders(BiomePaintTools.items);
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new PencilColorHandler(), new Item[]{BiomePaintTools.pencil});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderHUD(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            float x;
            Biome b;
            int biome;
            String bn;
            FontRenderer f = Minecraft.func_71410_x().field_71466_p;
            ItemStack mainhand = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
            ItemStack offhand = Minecraft.func_71410_x().field_71439_g.func_184592_cb();
            EnumHandSide handMain = Minecraft.func_71410_x().field_71474_y.field_186715_A;
            if (mainhand != null && mainhand.func_77973_b() == BiomePaintTools.pencil && mainhand.func_77942_o() && mainhand.func_77978_p().func_74764_b("CurrentBiome") && mainhand.func_77952_i() < BiomePaintTools.pencil.func_77612_l()) {
                bn = I18n.func_74838_a((String)"hud.biomepainttools:biome_name") + ": ";
                biome = mainhand.func_77978_p().func_74762_e("CurrentBiome");
                b = (Biome)Biome.field_185377_q.func_148754_a(biome);
                bn = bn + I18n.func_74838_a((String)(b != null ? b.func_185359_l() : "biome.unknown"));
                x = handMain == EnumHandSide.LEFT ? 2.0f : (float)e.getResolution().func_78327_c() - (float)f.func_78256_a(bn) - 2.0f;
                f.func_175065_a(bn, x, (float)e.getResolution().func_78324_d() / 2.0f - 14.0f, 0xFFFFFF, false);
            }
            if (offhand != null && offhand.func_77973_b() == BiomePaintTools.pencil && offhand.func_77942_o() && offhand.func_77978_p().func_74764_b("CurrentBiome") && offhand.func_77952_i() < BiomePaintTools.pencil.func_77612_l()) {
                bn = I18n.func_74838_a((String)"hud.biomepainttools:biome_name") + ": ";
                biome = offhand.func_77978_p().func_74762_e("CurrentBiome");
                b = (Biome)Biome.field_185377_q.func_148754_a(biome);
                bn = bn + I18n.func_74838_a((String)(b != null ? b.func_185359_l() : "biome.unknown"));
                x = handMain == EnumHandSide.LEFT ? (float)e.getResolution().func_78327_c() - (float)f.func_78256_a(bn) - 2.0f : 2.0f;
                f.func_175065_a(bn, x, (float)e.getResolution().func_78324_d() / 2.0f - 14.0f, 0xFFFFFF, false);
            }
        }
    }

    @Override
    public void setBiomeAt(World world, BlockPos pos, byte biome) {
        if (world.field_72995_K && world.func_175707_a(pos, pos)) {
            int x = Math.abs(pos.func_177958_n() < 0 ? (16 + pos.func_177958_n()) % 16 : pos.func_177958_n() % 16) % 16;
            int z = Math.abs(pos.func_177952_p() < 0 ? (16 + pos.func_177952_p()) % 16 : pos.func_177952_p() % 16) % 16;
            Chunk c = world.func_175726_f(pos);
            byte[] biomes = c.func_76605_m();
            biomes[x + z * 16] = biome;
            c.func_76616_a(biomes);
            for (int y = 0; y < 256; ++y) {
                world.func_175704_b(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()), new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()));
            }
        } else {
            super.setBiomeAt(world, pos, biome);
        }
    }

    public static void registerRenders(Iterable<Item> items) {
        Iterator<Item> it = items.iterator();
        while (it.hasNext()) {
            ClientProxy.registerRender(it.next(), 0);
        }
    }

    public static void registerRenders(Item ... items) {
        for (Item i : items) {
            ClientProxy.registerRender(i, 0);
        }
    }

    public static void registerRender(Item item, int meta) {
        FMLLog.log((String)"Biome Paint Tools", (Level)Level.INFO, (String)("Model definition for location " + item.func_77658_a().substring(5) + ":" + meta), (Object[])new Object[0]);
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, meta, new ModelResourceLocation(item.func_77658_a().substring(5) + (meta <= 0 ? "" : "_" + meta), "inventory"));
    }
}

