/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.slot;

import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class SlotHologramSlot
extends Slot {
    protected final ItemStack[] stacks;
    protected final int index;
    protected final int stackSizeLimit;
    protected final ChangeCallback changeCallback;

    public SlotHologramSlot(ItemStack[] stacks, int index, int x, int y, int stackSizeLimit, ChangeCallback changeCallback) {
        super(null, 0, x, y);
        if (index >= stacks.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.stacks = stacks;
        this.index = index;
        this.stackSizeLimit = stackSizeLimit;
        this.changeCallback = changeCallback;
    }

    public boolean func_82869_a(EntityPlayer player) {
        return false;
    }

    public int func_75219_a() {
        return this.stackSizeLimit;
    }

    public boolean func_75214_a(ItemStack stack) {
        return false;
    }

    public ItemStack func_75211_c() {
        return this.stacks[this.index];
    }

    public void func_75215_d(ItemStack stack) {
        this.stacks[this.index] = stack;
    }

    public void func_75218_e() {
        if (Util.inDev()) {
            System.out.println(ArrayUtils.toString((Object)this.stacks));
        }
        if (this.changeCallback != null) {
            this.changeCallback.onChanged(this.index);
        }
    }

    public ItemStack func_75209_a(int amount) {
        return null;
    }

    public boolean func_75217_a(IInventory inventory, int index) {
        return false;
    }

    public ItemStack slotClick(int dragType, ClickType clickType, EntityPlayer player) {
        if (Util.inDev() && player.field_70170_p.field_72995_K) {
            System.out.printf("dragType=%d clickType=%s stack=%s%n", dragType, clickType, player.field_71071_by.func_70445_o());
        }
        if (clickType == ClickType.PICKUP && (dragType == 0 || dragType == 1)) {
            ItemStack playerStack = player.field_71071_by.func_70445_o();
            ItemStack slotStack = this.stacks[this.index];
            if (playerStack != null) {
                if (slotStack == null) {
                    this.stacks[this.index] = dragType == 0 ? StackUtil.copyWithSize(playerStack, Math.min(playerStack.field_77994_a, this.stackSizeLimit)) : StackUtil.copyWithSize(playerStack, 1);
                } else if (StackUtil.checkItemEquality(playerStack, slotStack)) {
                    int increment;
                    int n = increment = dragType == 0 ? playerStack.field_77994_a : 1;
                    if (Util.inDev()) {
                        System.out.println("add " + increment + " to " + slotStack + " -> " + Math.min(slotStack.field_77994_a + increment, Math.min(this.stackSizeLimit, slotStack.func_77976_d())));
                    }
                    slotStack.field_77994_a = Math.min(slotStack.field_77994_a + increment, Math.min(this.stackSizeLimit, slotStack.func_77976_d()));
                } else {
                    this.stacks[this.index] = StackUtil.copyWithSize(playerStack, Math.min(playerStack.field_77994_a, this.stackSizeLimit));
                }
            } else if (slotStack != null) {
                if (dragType == 0) {
                    this.stacks[this.index] = null;
                } else {
                    int newSize = slotStack.field_77994_a / 2;
                    if (newSize <= 0) {
                        this.stacks[this.index] = null;
                    } else {
                        slotStack.field_77994_a = newSize;
                    }
                }
            }
            this.func_75218_e();
        }
        return null;
    }

    public static interface ChangeCallback {
        public void onChanged(int var1);
    }
}

