/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xreliquary.Reliquary;
import xreliquary.entities.shot.EntityBlazeShot;
import xreliquary.entities.shot.EntityBusterShot;
import xreliquary.entities.shot.EntityConcussiveShot;
import xreliquary.entities.shot.EntityEnderShot;
import xreliquary.entities.shot.EntityExorcismShot;
import xreliquary.entities.shot.EntityNeutralShot;
import xreliquary.entities.shot.EntitySandShot;
import xreliquary.entities.shot.EntitySeekerShot;
import xreliquary.entities.shot.EntityStormShot;
import xreliquary.init.ModCapabilities;
import xreliquary.init.ModItems;
import xreliquary.init.ModSounds;
import xreliquary.items.ItemBase;
import xreliquary.items.util.handgun.HandgunData;
import xreliquary.items.util.handgun.IHandgunData;
import xreliquary.network.PacketHandgunDataSync;
import xreliquary.network.PacketHandler;

public class ItemHandgun
extends ItemBase {
    public ItemHandgun() {
        super("handgun");
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.canRepair = false;
        this.func_77637_a(Reliquary.CREATIVE_TAB);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            private IHandgunData handgunData = new HandgunData();

            public NBTTagCompound serializeNBT() {
                return (NBTTagCompound)this.handgunData.serializeNBT();
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                this.handgunData.deserializeNBT((NBTBase)nbt);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == ModCapabilities.HANDGUN_DATA_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                if (capability == ModCapabilities.HANDGUN_DATA_CAPABILITY) {
                    return (T)this.handgunData;
                }
                return null;
            }
        };
    }

    public short getBulletCount(ItemStack handgun) {
        IHandgunData data = this.getHandgunData(handgun);
        if (data != null) {
            return data.getBulletCount();
        }
        return 0;
    }

    private IHandgunData getHandgunData(ItemStack handgun) {
        return (IHandgunData)handgun.getCapability(ModCapabilities.HANDGUN_DATA_CAPABILITY, null);
    }

    public void setBulletCount(ItemStack handgun, short bulletCount) {
        IHandgunData data = this.getHandgunData(handgun);
        if (data != null) {
            data.setBulletCount(bulletCount);
        }
    }

    public short getBulletType(ItemStack handgun) {
        IHandgunData data = this.getHandgunData(handgun);
        if (data != null) {
            return data.getBulletType();
        }
        return 0;
    }

    public void setBulletType(ItemStack handgun, short bulletType) {
        IHandgunData data = this.getHandgunData(handgun);
        if (data != null) {
            data.setBulletType(bulletType);
        }
    }

    public boolean isInCooldown(ItemStack handgun) {
        IHandgunData data = this.getHandgunData(handgun);
        return data != null && data.isInCoolDown();
    }

    public void setInCooldown(ItemStack handgun, boolean inCooldown) {
        IHandgunData data = this.getHandgunData(handgun);
        if (data != null) {
            data.setInCoolDown(inCooldown);
        }
    }

    public long getCooldown(ItemStack handgun) {
        IHandgunData data = this.getHandgunData(handgun);
        if (data != null) {
            return data.getCoolDownTime();
        }
        return 0L;
    }

    public void setCooldown(ItemStack handgun, long coolDownTime) {
        IHandgunData data = this.getHandgunData(handgun);
        if (data != null) {
            data.setCoolDownTime(coolDownTime);
        }
    }

    public List<PotionEffect> getPotionEffects(ItemStack handgun) {
        IHandgunData data = this.getHandgunData(handgun);
        if (data != null) {
            return data.getPotionEffects();
        }
        return null;
    }

    public void setPotionEffects(ItemStack handgun, List<PotionEffect> potionEffects) {
        IHandgunData data = this.getHandgunData(handgun);
        if (data != null) {
            data.setPotionEffects(potionEffects);
        }
    }

    public EnumAction func_77661_b(ItemStack handgun) {
        if (this.getBulletCount(handgun) > 0) {
            return EnumAction.NONE;
        }
        return EnumAction.BLOCK;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.func_77973_b() != ModItems.handgun || newStack.func_77973_b() != ModItems.handgun;
    }

    public void func_77663_a(ItemStack handgun, World worldObj, Entity entity, int slotNumber, boolean isSelected) {
        if (worldObj.field_72995_K) {
            return;
        }
        if (this.isInCooldown(handgun) && (this.isCooldownOver(worldObj, handgun) || !this.isValidCooldownTime(worldObj, handgun))) {
            this.setInCooldown(handgun, false);
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (handgun == player.func_184614_ca()) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketHandgunDataSync(EnumHand.MAIN_HAND, this.getBulletCount(handgun), this.getBulletType(handgun), this.isInCooldown(handgun), this.getCooldown(handgun), this.getPotionEffects(handgun)), (EntityPlayerMP)player);
        } else if (handgun == player.func_184592_cb()) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketHandgunDataSync(EnumHand.OFF_HAND, this.getBulletCount(handgun), this.getBulletType(handgun), this.isInCooldown(handgun), this.getCooldown(handgun), this.getPotionEffects(handgun)), (EntityPlayerMP)player);
        }
    }

    private boolean isCooldownOver(World worldObj, ItemStack handgun) {
        return this.getCooldown(handgun) < worldObj.func_72820_D() && worldObj.func_72820_D() - this.getCooldown(handgun) < 12000L;
    }

    private boolean isValidCooldownTime(World worldObj, ItemStack handgun) {
        return Math.min(Math.abs(worldObj.func_72820_D() - this.getCooldown(handgun)), Math.abs(worldObj.func_72820_D() - 23999L - this.getCooldown(handgun))) <= (long)this.func_77626_a(handgun);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack handgun, World worldObj, EntityPlayer player, EnumHand hand) {
        if (this.hasFilledMagazine(player) && this.getBulletCount(handgun) == 0 || this.getBulletCount(handgun) > 0 && (!this.hasHandgunInSecondHand(player, hand) || this.cooledMoreThanSecondHandgun(handgun, player, hand))) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)handgun);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)handgun);
    }

    private boolean cooledMoreThanSecondHandgun(ItemStack handgun, EntityPlayer player, EnumHand hand) {
        if (!this.isInCooldown(handgun)) {
            return true;
        }
        if (hand == EnumHand.MAIN_HAND) {
            return !this.isInCooldown(player.func_184592_cb()) && this.getCooldown(handgun) < this.getCooldown(player.func_184592_cb());
        }
        return !this.isInCooldown(player.func_184614_ca()) && this.getCooldown(handgun) < this.getCooldown(player.func_184614_ca());
    }

    private boolean secondHandgunCooledEnough(World world, EntityPlayer player, EnumHand hand) {
        ItemStack secondHandgun = hand == EnumHand.MAIN_HAND ? player.func_184592_cb() : player.func_184614_ca();
        return !this.isInCooldown(secondHandgun) || this.getCooldown(secondHandgun) - world.func_72820_D() < (long)(this.getPlayerReloadDelay(player) / 2);
    }

    private boolean hasHandgunInSecondHand(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() == ModItems.handgun;
        }
        return player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == ModItems.handgun;
    }

    public void onUsingTick(ItemStack handgun, EntityLivingBase entity, int unadjustedCount) {
        if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int maxUseOffset = this.getItemUseDuration() - this.getPlayerReloadDelay(player);
        int actualCount = unadjustedCount - maxUseOffset;
        if (!this.hasFilledMagazine(player) || --actualCount == 0) {
            player.func_184597_cx();
            return;
        }
        if (!(this.isInCooldown(handgun) || this.getBulletCount(handgun) <= 0 || this.hasHandgunInSecondHand(player, player.func_184600_cs()) && !this.secondHandgunCooledEnough(player.field_70170_p, player, player.func_184600_cs()))) {
            player.func_184597_cx();
        }
    }

    public int func_77626_a(ItemStack handgun) {
        return this.getItemUseDuration();
    }

    public void func_77615_a(ItemStack handgun, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (this.getBulletCount(handgun) > 0) {
            if (!this.isInCooldown(handgun)) {
                this.setCooldown(handgun, worldIn.func_72820_D() + 20L + 5L - (long)Math.min(player.field_71068_ca, 20));
                this.setInCooldown(handgun, true);
                this.fireBullet(handgun, worldIn, player, handgun == player.func_184614_ca() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
            }
            return;
        }
        this.setCooldown(handgun, player.field_70170_p.func_72820_D() + 12L);
        this.setInCooldown(handgun, true);
        int slot = this.getMagazineSlot(player);
        if (slot != -1) {
            ItemStack magazine = player.field_71071_by.field_70462_a[slot];
            this.setBulletType(handgun, (short)magazine.func_77960_j());
            this.setPotionEffects(handgun, PotionUtils.func_185190_b((ItemStack)magazine));
            --magazine.field_77994_a;
            if (magazine.field_77994_a == 0) {
                player.field_71071_by.field_70462_a[slot] = null;
            }
        }
        if (this.getBulletType(handgun) != 0) {
            player.func_184609_a(player.func_184600_cs());
            this.spawnEmptyMagazine(player);
            this.setBulletCount(handgun, (short)8);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.xload, SoundCategory.PLAYERS, 0.25f, 1.0f);
        }
        if (this.getBulletCount(handgun) == 0) {
            this.setBulletType(handgun, (short)0);
            this.setPotionEffects(handgun, null);
        }
    }

    private int getItemUseDuration() {
        return 30;
    }

    private void fireBullet(ItemStack handgun, World worldObj, EntityPlayer player, EnumHand hand) {
        if (!worldObj.field_72995_K) {
            switch (this.getBulletType(handgun)) {
                case 0: {
                    return;
                }
                case 1: {
                    worldObj.func_72838_d((Entity)new EntityNeutralShot(worldObj, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 2: {
                    worldObj.func_72838_d((Entity)new EntityExorcismShot(worldObj, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 3: {
                    worldObj.func_72838_d((Entity)new EntityBlazeShot(worldObj, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 4: {
                    worldObj.func_72838_d((Entity)new EntityEnderShot(worldObj, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 5: {
                    worldObj.func_72838_d((Entity)new EntityConcussiveShot(worldObj, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 6: {
                    worldObj.func_72838_d((Entity)new EntityBusterShot(worldObj, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 7: {
                    worldObj.func_72838_d((Entity)new EntitySeekerShot(worldObj, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 8: {
                    worldObj.func_72838_d((Entity)new EntitySandShot(worldObj, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                    break;
                }
                case 9: {
                    worldObj.func_72838_d((Entity)new EntityStormShot(worldObj, player, hand).addPotionEffects(this.getPotionEffects(handgun)));
                }
            }
            worldObj.func_184133_a(null, player.func_180425_c(), ModSounds.xshot, SoundCategory.PLAYERS, 0.5f, 1.2f);
            this.setBulletCount(handgun, (short)(this.getBulletCount(handgun) - 1));
            if (this.getBulletCount(handgun) == 0) {
                this.setBulletType(handgun, (short)0);
                this.setPotionEffects(handgun, null);
            }
            this.spawnCasing(player);
        }
    }

    private void spawnEmptyMagazine(EntityPlayer player) {
        if (!player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.magazine, 1, 0))) {
            player.func_70099_a(new ItemStack((Item)ModItems.magazine, 1, 0), 0.1f);
        }
    }

    private void spawnCasing(EntityPlayer player) {
        if (!player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.bullet, 1, 0))) {
            player.func_70099_a(new ItemStack((Item)ModItems.bullet, 1, 0), 0.1f);
        }
    }

    private boolean hasFilledMagazine(EntityPlayer player) {
        for (ItemStack ist : player.field_71071_by.field_70462_a) {
            if (ist == null || ist.func_77973_b() != ModItems.magazine || ist.func_77952_i() == 0) continue;
            return true;
        }
        return false;
    }

    private short getMagazineTypeAndRemoveOne(EntityPlayer player, List<PotionEffect> effects) {
        short bulletFound = 0;
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != ModItems.magazine || player.field_71071_by.field_70462_a[slot].func_77952_i() == 0) continue;
            ItemStack magazine = player.field_71071_by.field_70462_a[slot];
            bulletFound = (short)magazine.func_77952_i();
            if (ModItems.magazine.isPotionAttached(magazine)) {
                effects = PotionUtils.func_185189_a((ItemStack)magazine);
            }
            player.field_71071_by.func_70298_a(slot, 1);
            return bulletFound;
        }
        return bulletFound;
    }

    private int getMagazineSlot(EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != ModItems.magazine || player.field_71071_by.field_70462_a[slot].func_77952_i() == 0) continue;
            return slot;
        }
        return -1;
    }

    public boolean func_77662_d() {
        return true;
    }

    private int getPlayerReloadDelay(EntityPlayer player) {
        return 30 - Math.min(player.field_71068_ca, 20);
    }
}

