/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import xreliquary.crafting.AlkahestryChargingRecipe;
import xreliquary.crafting.AlkahestryCraftingRecipe;
import xreliquary.crafting.AlkahestryDrainRecipe;
import xreliquary.crafting.MagazineRecipe;
import xreliquary.crafting.MobCharmDataFixRecipe;
import xreliquary.crafting.MobCharmRepairRecipe;
import xreliquary.crafting.PotionBulletsRecipe;
import xreliquary.crafting.XRTippedArrowsRecipe;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.reference.Settings;

public class XRRecipes {
    public static final ItemStack EMPTY_VOID_TEAR = new ItemStack((Item)ModItems.emptyVoidTear, 1, 0);
    public static final ItemStack WITHER_SKULL = new ItemStack(Items.field_151144_bL, 1, 1);
    public static final ItemStack ROSE_BUSH = new ItemStack((Block)Blocks.field_150398_cm, 1, 4);
    public static final ItemStack BLACK_WOOL = new ItemStack(Blocks.field_150325_L, 1, 15);
    public static final ItemStack LAPIS = new ItemStack(Items.field_151100_aR, 1, 4);
    public static final ItemStack NEBULOUS_HEART = XRRecipes.ingredient(1, 11);
    public static final ItemStack CREEPER_GLAND = XRRecipes.ingredient(1, 3);
    public static final ItemStack SLIME_PEARL = XRRecipes.ingredient(1, 4);
    public static final ItemStack BAT_WING = XRRecipes.ingredient(1, 5);
    public static final ItemStack RIB_BONE = XRRecipes.ingredient(1, 0);
    public static final ItemStack WITHER_RIB = XRRecipes.ingredient(1, 1);
    public static final ItemStack STORM_EYE = XRRecipes.ingredient(1, 8);
    public static final ItemStack FERTILE_ESSENCE = XRRecipes.ingredient(1, 9);
    public static final ItemStack FROZEN_CORE = XRRecipes.ingredient(1, 10);
    public static final ItemStack MOLTEN_CORE = XRRecipes.ingredient(1, 7);
    public static final ItemStack ZOMBIE_HEART = XRRecipes.ingredient(1, 6);
    public static final ItemStack INFERNAL_CLAW = XRRecipes.ingredient(1, 13);
    public static final ItemStack SHELL_FRAGMENT = XRRecipes.ingredient(1, 14);
    public static final ItemStack SQUID_BEAK = XRRecipes.ingredient(1, 12);
    public static final ItemStack CHELICERAE = XRRecipes.ingredient(1, 2);
    public static final ItemStack GUARDIAN_SPIKE = XRRecipes.ingredient(1, 16);

    public static void addRecipe(boolean isShapeless, boolean overrideDisabler, ItemStack result, Object ... params) {
        if (result.func_77973_b() == null || result.func_77973_b().getRegistryName() == null || Arrays.asList(params).contains(null)) {
            return;
        }
        ResourceLocation rl = result.func_77973_b().getRegistryName();
        if (Settings.disabledItemsBlocks.contains(rl.func_110623_a())) {
            return;
        }
        for (Object o : params) {
            if (!(o instanceof Block) && !(o instanceof Item) && !(o instanceof ItemStack)) continue;
            if (o instanceof Block) {
                rl = ((Block)o).getRegistryName();
            } else if (o instanceof Item && ((Item)o).getRegistryName() != null) {
                rl = ((Item)o).getRegistryName();
            } else if (o instanceof ItemStack) {
                rl = ((ItemStack)o).func_77973_b().getRegistryName();
            }
            if (!Settings.disabledItemsBlocks.contains(rl.func_110623_a())) continue;
            return;
        }
        if (!isShapeless) {
            GameRegistry.addRecipe((ItemStack)result, (Object[])params);
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])params);
        }
    }

    public static void init() {
        int i;
        XRRecipes.addTomeRecipeHandlers();
        XRRecipes.addMobCharmRecipeHandlers();
        XRRecipes.addLingeringPotionRecipes();
        XRRecipes.addRecipe(true, true, new ItemStack(Blocks.field_150403_cj, 1, 0), Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, Blocks.field_150432_aD, FROZEN_CORE);
        XRRecipes.addRecipe(false, false, new ItemStack((Block)ModBlocks.apothecaryMortar, 1, 0), "gng", "ngn", "nnn", Character.valueOf('n'), Blocks.field_150371_ca, Character.valueOf('g'), CREEPER_GLAND);
        XRRecipes.addRecipe(false, false, new ItemStack((Block)ModBlocks.apothecaryCauldron, 1, 0), "gng", "ici", "nmn", Character.valueOf('g'), CREEPER_GLAND, Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('i'), INFERNAL_CLAW, Character.valueOf('c'), Items.field_151066_bu, Character.valueOf('m'), MOLTEN_CORE);
        if (Settings.EasyModeRecipes.alkahestryTome) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.alkahestryTome, 1, ModItems.alkahestryTome.func_77612_l()), new Object[]{Items.field_151122_aG, ModItems.witchHat, MOLTEN_CORE, WITHER_SKULL});
        } else {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.alkahestryTome, 1, ModItems.alkahestryTome.func_77612_l()), new Object[]{MOLTEN_CORE, ModItems.witchHat, STORM_EYE, CREEPER_GLAND, Items.field_151122_aG, SLIME_PEARL, CHELICERAE, WITHER_SKULL, NEBULOUS_HEART});
        }
        if (Settings.EasyModeRecipes.altar) {
            XRRecipes.addRecipe(true, false, new ItemStack((Block)ModBlocks.alkahestryAltar, 1), Blocks.field_150343_Z, Blocks.field_150379_bu, NEBULOUS_HEART, CREEPER_GLAND);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Block)ModBlocks.alkahestryAltar, 1), "dnd", "olo", "dgd", Character.valueOf('d'), Items.field_151114_aO, Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('l'), Blocks.field_150379_bu, Character.valueOf('g'), CREEPER_GLAND);
        }
        XRRecipes.addRecipe(true, false, new ItemStack((Block)ModBlocks.fertileLilypad, 1), FERTILE_ESSENCE, FERTILE_ESSENCE, FERTILE_ESSENCE, Blocks.field_150392_bi);
        XRRecipes.addRecipe(true, false, new ItemStack((Block)ModBlocks.wraithNode, 1), NEBULOUS_HEART, Items.field_151166_bC);
        if (Settings.EasyModeRecipes.interdictionTorch) {
            XRRecipes.addRecipe(false, false, new ItemStack((Block)ModBlocks.interdictionTorch, 4, 0), "bm", "nr", Character.valueOf('b'), BAT_WING, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('r'), Items.field_151072_bj);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Block)ModBlocks.interdictionTorch, 4, 0), " n ", "mdm", "bwb", Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('w'), BAT_WING);
        }
        XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.glowingBread, 3), new Object[]{Items.field_151025_P, Items.field_151025_P, Items.field_151025_P, ModItems.glowingWater});
        if (Settings.EasyModeRecipes.fertileEssence) {
            XRRecipes.addRecipe(true, false, FERTILE_ESSENCE, RIB_BONE, CREEPER_GLAND, new ItemStack(Items.field_151100_aR, 1, 2), SLIME_PEARL);
        } else {
            XRRecipes.addRecipe(false, false, FERTILE_ESSENCE, "gbg", "scs", "gbg", Character.valueOf('g'), CREEPER_GLAND, Character.valueOf('b'), RIB_BONE, Character.valueOf('s'), SLIME_PEARL, Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 2));
        }
        XRRecipes.addRecipe(true, true, new ItemStack(Items.field_151074_bl, 1), XRRecipes.bullet(1, 0), XRRecipes.bullet(1, 0), XRRecipes.bullet(1, 0), XRRecipes.bullet(1, 0));
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 1), Items.field_151145_ak, Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 2), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), XRRecipes.bullet(1, 1), ZOMBIE_HEART);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 3), Items.field_151065_br, Items.field_151072_bj, Items.field_151074_bl, Items.field_151074_bl);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 4), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), XRRecipes.bullet(1, 7), NEBULOUS_HEART);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 5), Items.field_151123_aH, Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 6), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), XRRecipes.bullet(1, 5), CREEPER_GLAND);
        if (Settings.EasyModeRecipes.seekerShot) {
            XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 7), LAPIS, Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        } else {
            XRRecipes.addRecipe(true, false, XRRecipes.bullet(4, 7), LAPIS, SLIME_PEARL, Items.field_151074_bl, Items.field_151016_H);
        }
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 8), Blocks.field_150322_A, Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        XRRecipes.addRecipe(true, false, XRRecipes.bullet(8, 9), CREEPER_GLAND, CREEPER_GLAND, Items.field_151074_bl, Items.field_151074_bl, Items.field_151016_H);
        XRRecipes.addRecipe(false, false, XRRecipes.magazine(5, 0), "i i", "igi", "sis", Character.valueOf('s'), Blocks.field_150348_b, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('g'), Blocks.field_150359_w);
        GameRegistry.addRecipe((IRecipe)new MagazineRecipe());
        RecipeSorter.register((String)"xreliquary:magazines", MagazineRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        XRRecipes.addRecipe(false, false, XRRecipes.gunPart(1, 0), "iii", "imi", "ici", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('c'), XRRecipes.magazine(1, 0), Character.valueOf('m'), Items.field_151064_bs);
        XRRecipes.addRecipe(false, false, XRRecipes.gunPart(1, 1), "iii", "eme", "iii", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('e'), NEBULOUS_HEART, Character.valueOf('m'), Items.field_151064_bs);
        XRRecipes.addRecipe(false, false, XRRecipes.gunPart(1, 2), "iib", "rmi", "iii", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), Blocks.field_150430_aB, Character.valueOf('r'), Items.field_151072_bj, Character.valueOf('m'), MOLTEN_CORE);
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.handgun, 1, 0), "bim", "isi", "igi", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), XRRecipes.gunPart(1, 1), Character.valueOf('m'), XRRecipes.gunPart(1, 2), Character.valueOf('g'), XRRecipes.gunPart(1, 0), Character.valueOf('s'), SLIME_PEARL);
        if (Settings.EasyModeRecipes.fortuneCoin) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.fortuneCoin, 1), NEBULOUS_HEART, Items.field_151074_bl, SLIME_PEARL, BAT_WING);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.fortuneCoin, 1), "ege", "gng", "ege", Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('n'), NEBULOUS_HEART);
        }
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.mercyCross, 1), "wgr", "glg", "sgz", Character.valueOf('w'), WITHER_RIB, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('r'), RIB_BONE, Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('s'), new ItemStack(Items.field_151144_bL, 1, 1), Character.valueOf('z'), ZOMBIE_HEART);
        XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.holyHandGrenade, 4), new Object[]{ModItems.glowingWater, Items.field_151074_bl, Blocks.field_150335_W, CREEPER_GLAND});
        if (Settings.EasyModeRecipes.sojournerStaff) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.sojournerStaff, 1), MOLTEN_CORE, Items.field_151043_k, Items.field_151072_bj, EMPTY_VOID_TEAR);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.sojournerStaff, 1), new Object[]{"gcm", "itc", "big", Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('c'), Items.field_151064_bs, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('i'), Items.field_151043_k, Character.valueOf('t'), ModItems.infernalTear, Character.valueOf('b'), Items.field_151072_bj});
        }
        if (Settings.EasyModeRecipes.lanternOfParanoia) {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.lanternOfParanoia, 1), "isi", "gmg", " i ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('s'), SLIME_PEARL, Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('m'), MOLTEN_CORE);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.lanternOfParanoia, 1), new Object[]{"imi", "gtg", "ili", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('t'), ModBlocks.interdictionTorch, Character.valueOf('l'), CREEPER_GLAND});
        }
        XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.midasTouchstone, 1, 0), Blocks.field_150467_bQ, Blocks.field_150340_R, Blocks.field_150340_R, MOLTEN_CORE, MOLTEN_CORE, MOLTEN_CORE, CREEPER_GLAND, CREEPER_GLAND, EMPTY_VOID_TEAR);
        if (Settings.EasyModeRecipes.emperorChalice) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.emperorChalice, 1, 0), Items.field_151166_bC, Items.field_151043_k, Items.field_151133_ar, EMPTY_VOID_TEAR);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.emperorChalice, 1, 0), "ses", "ivi", "lbl", Character.valueOf('s'), SLIME_PEARL, Character.valueOf('e'), Items.field_151166_bC, Character.valueOf('i'), Items.field_151043_k, Character.valueOf('v'), EMPTY_VOID_TEAR, Character.valueOf('l'), LAPIS, Character.valueOf('b'), Items.field_151133_ar);
        }
        if (Settings.EasyModeRecipes.infernalChalice) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.infernalChalice, 1), new Object[]{ModItems.infernalClaws, ModItems.emperorChalice, ModItems.infernalTear, MOLTEN_CORE});
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.infernalChalice, 1), new Object[]{"imi", "wcw", "mtm", Character.valueOf('i'), ModItems.infernalClaws, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('w'), WITHER_RIB, Character.valueOf('c'), ModItems.emperorChalice, Character.valueOf('t'), ModItems.infernalTear});
        }
        if (Settings.EasyModeRecipes.salamanderEye) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.salamanderEye, 1), Items.field_151061_bv, MOLTEN_CORE, FROZEN_CORE, NEBULOUS_HEART);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.salamanderEye, 1), "fnm", "geg", "mnf", Character.valueOf('f'), FROZEN_CORE, Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('e'), Items.field_151061_bv);
        }
        if (Settings.EasyModeRecipes.iceMagusRod) {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.iceMagusRod, 1, 0), " df", " vd", "i  ", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('f'), FROZEN_CORE, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('v'), EMPTY_VOID_TEAR);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.iceMagusRod, 1, 0), "fdf", "ptd", "ipf", Character.valueOf('f'), FROZEN_CORE, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('p'), Blocks.field_150403_cj, Character.valueOf('t'), EMPTY_VOID_TEAR, Character.valueOf('i'), Items.field_151042_j);
        }
        if (Settings.EasyModeRecipes.glacialStaff) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.glacialStaff, 1, 0), new Object[]{ModItems.iceMagusRod, EMPTY_VOID_TEAR, FROZEN_CORE, ModItems.shearsOfWinter});
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.glacialStaff, 1, 0), new Object[]{"fds", "fvd", "iff", Character.valueOf('f'), FROZEN_CORE, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('s'), ModItems.shearsOfWinter, Character.valueOf('v'), EMPTY_VOID_TEAR, Character.valueOf('i'), ModItems.iceMagusRod});
        }
        if (Settings.EasyModeRecipes.enderStaff) {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.enderStaff, 1, 0), new Object[]{" be", "nvb", "sn ", Character.valueOf('v'), ModItems.emptyVoidTear, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('s'), Items.field_151055_y, Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('b'), BAT_WING});
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.enderStaff, 1, 0), "nbe", "nvb", "rnn", Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('b'), BAT_WING, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('v'), EMPTY_VOID_TEAR, Character.valueOf('r'), Items.field_151072_bj);
        }
        if (Settings.EasyModeRecipes.rendingGale) {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.rendingGale, 1, 0), " be", "gvb", "sg ", Character.valueOf('b'), BAT_WING, Character.valueOf('e'), STORM_EYE, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('v'), EMPTY_VOID_TEAR, Character.valueOf('s'), Items.field_151055_y);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.rendingGale, 1, 0), new Object[]{"ebe", "fvb", "rfe", Character.valueOf('e'), STORM_EYE, Character.valueOf('b'), BAT_WING, Character.valueOf('f'), ModItems.angelicFeather, Character.valueOf('v'), EMPTY_VOID_TEAR, Character.valueOf('r'), Items.field_151072_bj});
        }
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.harvestRod, 1, 0), " rf", "vtr", "sv ", Character.valueOf('r'), ROSE_BUSH, Character.valueOf('f'), FERTILE_ESSENCE, Character.valueOf('v'), Blocks.field_150395_bd, Character.valueOf('t'), EMPTY_VOID_TEAR, Character.valueOf('s'), Items.field_151055_y);
        if (Settings.EasyModeRecipes.pyromancerStaff) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.pyromancerStaff, 1, 0), new Object[]{ModItems.infernalClaws, Items.field_151072_bj, ModItems.infernalTear, ModItems.salamanderEye});
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.pyromancerStaff, 1, 0), new Object[]{"mcs", "mic", "rmm", Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('c'), ModItems.infernalClaws, Character.valueOf('s'), ModItems.salamanderEye, Character.valueOf('i'), ModItems.infernalTear, Character.valueOf('r'), Items.field_151072_bj});
        }
        if (Settings.EasyModeRecipes.serpentStaff) {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.serpentStaff, 1), " ce", " kc", "s  ", Character.valueOf('c'), CHELICERAE, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('k'), SHELL_FRAGMENT, Character.valueOf('b'), Items.field_151055_y);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.serpentStaff, 1), "coe", "pko", "bpc", Character.valueOf('c'), CHELICERAE, Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('p'), SLIME_PEARL, Character.valueOf('k'), SHELL_FRAGMENT, Character.valueOf('b'), Items.field_151072_bj);
        }
        if (Settings.EasyModeRecipes.rodOfLyssa) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.rodOfLyssa, 1, 0), INFERNAL_CLAW, BAT_WING, NEBULOUS_HEART, Items.field_151112_aM);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.rodOfLyssa, 1, 0), " br", "nms", "r i", Character.valueOf('b'), BAT_WING, Character.valueOf('r'), Items.field_151072_bj, Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('s'), Items.field_151007_F, Character.valueOf('i'), INFERNAL_CLAW);
        }
        XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.shearsOfWinter, 1, 0), FROZEN_CORE, Items.field_151097_aZ, Items.field_151045_i, Items.field_151045_i);
        if (Settings.EasyModeRecipes.magicBane) {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.magicbane, 1, 0), "ng", "in", Character.valueOf('g'), Items.field_151043_k, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('n'), NEBULOUS_HEART);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.magicbane, 1, 0), "een", "nge", "ine", Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('i'), Items.field_151042_j);
        }
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.witherlessRose, 1), "fnf", "nrn", "fnf", Character.valueOf('f'), FERTILE_ESSENCE, Character.valueOf('n'), Items.field_151156_bN, Character.valueOf('r'), ROSE_BUSH);
        XRRecipes.addRecipe(true, false, XRRecipes.ingredient(1, 15), new ItemStack(Blocks.field_150325_L, 1, 14), new ItemStack(Blocks.field_150325_L, 1, 15), NEBULOUS_HEART, NEBULOUS_HEART);
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.twilightCloak, 1), "ici", "bcb", "bcb", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), BLACK_WOOL, Character.valueOf('c'), XRRecipes.ingredient(1, 15));
        if (Settings.EasyModeRecipes.voidTear) {
            XRRecipes.addRecipe(true, false, EMPTY_VOID_TEAR, Items.field_151073_bk, NEBULOUS_HEART, SLIME_PEARL, LAPIS);
        } else {
            XRRecipes.addRecipe(false, false, EMPTY_VOID_TEAR, "lel", "pgp", "lnl", Character.valueOf('l'), LAPIS, Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('p'), SLIME_PEARL, Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('n'), NEBULOUS_HEART);
        }
        if (Settings.EasyModeRecipes.infernalTear) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.infernalTear, 1, 0), new Object[]{EMPTY_VOID_TEAR, ModItems.witchHat, MOLTEN_CORE, INFERNAL_CLAW});
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.infernalTear, 1, 0), new Object[]{"php", "mtm", "pcp", Character.valueOf('p'), Items.field_151065_br, Character.valueOf('h'), ModItems.witchHat, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('t'), EMPTY_VOID_TEAR, Character.valueOf('c'), INFERNAL_CLAW});
        }
        if (Settings.EasyModeRecipes.angelicFeather) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.angelicFeather, 1), Items.field_151008_G, NEBULOUS_HEART, BAT_WING, FERTILE_ESSENCE);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.angelicFeather, 1), "dgd", "bfb", "ene", Character.valueOf('d'), Items.field_151114_aO, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('b'), BAT_WING, Character.valueOf('e'), FERTILE_ESSENCE, Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('f'), Items.field_151008_G);
        }
        XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.phoenixDown, 1), new Object[]{ModItems.angelheartVial, ModItems.angelheartVial, ModItems.angelheartVial, ModItems.angelicFeather});
        XRRecipes.addRecipe(true, false, INFERNAL_CLAW, Items.field_151116_aA, MOLTEN_CORE, RIB_BONE, SLIME_PEARL);
        if (Settings.EasyModeRecipes.infernalClaws) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.infernalClaws, 1), INFERNAL_CLAW, INFERNAL_CLAW, INFERNAL_CLAW, SLIME_PEARL);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.infernalClaws, 1), "ccc", "cpc", "mlm", Character.valueOf('c'), INFERNAL_CLAW, Character.valueOf('p'), SLIME_PEARL, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('l'), Items.field_151116_aA);
        }
        XRRecipes.addRecipe(true, false, SHELL_FRAGMENT, SQUID_BEAK, SQUID_BEAK, SQUID_BEAK, SLIME_PEARL);
        if (Settings.EasyModeRecipes.krakenShell) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.krakenShell, 1, 0), SHELL_FRAGMENT, SHELL_FRAGMENT, SHELL_FRAGMENT, NEBULOUS_HEART);
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.krakenShell, 1, 0), "nfn", "epe", "fnf", Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('f'), SHELL_FRAGMENT, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('p'), SLIME_PEARL);
        }
        if (Settings.EasyModeRecipes.heroMedallion) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.heroMedallion, 1), new Object[]{NEBULOUS_HEART, new ItemStack((Item)ModItems.fortuneCoin, 1, -1), ModItems.witchHat, ModItems.infernalTear});
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.heroMedallion, 1), new Object[]{"nie", "iti", "fin", Character.valueOf('n'), NEBULOUS_HEART, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('t'), ModItems.infernalTear, Character.valueOf('f'), new ItemStack((Item)ModItems.fortuneCoin, 1, -1)});
        }
        if (Settings.EasyModeRecipes.destructionCatalyst) {
            XRRecipes.addRecipe(true, false, new ItemStack((Item)ModItems.destructionCatalyst, 1, 0), new Object[]{Items.field_151033_d, MOLTEN_CORE, CREEPER_GLAND, ModItems.infernalTear});
        } else {
            XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.destructionCatalyst, 1, 0), new Object[]{"tmc", "gim", "fgt", Character.valueOf('t'), Blocks.field_150335_W, Character.valueOf('m'), MOLTEN_CORE, Character.valueOf('c'), CREEPER_GLAND, Character.valueOf('g'), Items.field_151043_k, Character.valueOf('i'), ModItems.infernalTear, Character.valueOf('f'), Items.field_151033_d});
        }
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(0), "ppp", "sts", "ppp", Character.valueOf('p'), ZOMBIE_HEART, Character.valueOf('s'), Items.field_151078_bh, Character.valueOf('t'), Items.field_151103_aS);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(1), "ppp", "sts", "ppp", Character.valueOf('p'), RIB_BONE, Character.valueOf('s'), Items.field_151103_aS, Character.valueOf('t'), Items.field_151145_ak);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(2), "ppp", "sts", "ppp", Character.valueOf('p'), WITHER_RIB, Character.valueOf('s'), Items.field_151103_aS, Character.valueOf('t'), WITHER_SKULL);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(3), "ppp", "sts", "ppp", Character.valueOf('p'), CREEPER_GLAND, Character.valueOf('s'), Items.field_151016_H, Character.valueOf('t'), Items.field_151103_aS);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(4), new Object[]{"ppp", "sts", "ppp", Character.valueOf('p'), ModItems.witchHat, Character.valueOf('s'), Items.field_151069_bo, Character.valueOf('t'), Items.field_151070_bp});
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(5), "ppp", "sts", "ppp", Character.valueOf('p'), ZOMBIE_HEART, Character.valueOf('s'), Items.field_151078_bh, Character.valueOf('t'), Items.field_151010_B);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(6), "ppp", "sts", "ppp", Character.valueOf('p'), CHELICERAE, Character.valueOf('s'), Items.field_151007_F, Character.valueOf('t'), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185254_z));
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(7), "ppp", "sts", "ppp", Character.valueOf('p'), CHELICERAE, Character.valueOf('s'), Items.field_151007_F, Character.valueOf('t'), Items.field_151070_bp);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(8), "ppp", "sts", "ppp", Character.valueOf('p'), NEBULOUS_HEART, Character.valueOf('s'), Items.field_151079_bi, Character.valueOf('t'), NEBULOUS_HEART);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(12), "ppp", "sts", "ppp", Character.valueOf('p'), MOLTEN_CORE, Character.valueOf('s'), Items.field_151072_bj, Character.valueOf('t'), Items.field_151065_br);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(9), "ppp", "sts", "ppp", Character.valueOf('p'), Items.field_151073_bk, Character.valueOf('s'), Items.field_151016_H, Character.valueOf('t'), CREEPER_GLAND);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(11), "ppp", "sss", "ppp", Character.valueOf('p'), MOLTEN_CORE, Character.valueOf('s'), Items.field_151064_bs);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(10), "ppp", "sss", "ppp", Character.valueOf('p'), SLIME_PEARL, Character.valueOf('s'), Items.field_151123_aH);
        XRRecipes.addRecipe(false, false, XRRecipes.charmFragment(13), "ppp", "sts", "ppp", Character.valueOf('p'), GUARDIAN_SPIKE, Character.valueOf('s'), Items.field_179562_cC, Character.valueOf('t'), Items.field_151115_aP);
        XRRecipes.addMobCharmRecipe((byte)0);
        XRRecipes.addMobCharmRecipe((byte)1);
        XRRecipes.addMobCharmRecipe((byte)2);
        XRRecipes.addMobCharmRecipe((byte)3);
        XRRecipes.addMobCharmRecipe((byte)4);
        XRRecipes.addMobCharmRecipe((byte)5);
        XRRecipes.addMobCharmRecipe((byte)6);
        XRRecipes.addMobCharmRecipe((byte)7);
        XRRecipes.addMobCharmRecipe((byte)8);
        XRRecipes.addMobCharmRecipe((byte)12);
        XRRecipes.addMobCharmRecipe((byte)9);
        XRRecipes.addMobCharmRecipe((byte)11);
        XRRecipes.addMobCharmRecipe((byte)10);
        XRRecipes.addMobCharmRecipe((byte)13);
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.mobCharmBelt), "lll", "f f", "fff", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('f'), new ItemStack((Item)ModItems.mobCharmFragment, 1, Short.MAX_VALUE));
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.potion, 1, 0), "g g", "g g", " g ", Character.valueOf('g'), Blocks.field_150410_aZ);
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.glowingWater, 5), "gbg", "gdg", "ngp", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('b'), Items.field_151131_as, Character.valueOf('d'), Items.field_151114_aO, Character.valueOf('p'), Items.field_151016_H, Character.valueOf('n'), Items.field_151075_bm);
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.angelheartVial, 5), "gbg", "gcg", "fgf", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('b'), Items.field_151117_aB, Character.valueOf('c'), INFERNAL_CLAW, Character.valueOf('f'), FERTILE_ESSENCE);
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.attractionPotion, 5), "gbg", "gfg", "rgc", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('b'), Items.field_151131_as, Character.valueOf('f'), FERTILE_ESSENCE, Character.valueOf('r'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 3));
        XRRecipes.addRecipe(false, false, new ItemStack((Item)ModItems.fertilePotion, 5), "gbg", "gfg", "cgy", Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('b'), Items.field_151131_as, Character.valueOf('f'), FERTILE_ESSENCE, Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 2), Character.valueOf('y'), new ItemStack(Items.field_151100_aR, 1, 11));
        for (i = 0; i < 16; ++i) {
            XRRecipes.addRecipe(false, false, new ItemStack((Block)ModBlocks.pedestal, 1, i), "d d", " p ", "d d", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('p'), new ItemStack((Block)ModBlocks.pedestalPassive, 1, i));
        }
        for (i = 0; i < 16; ++i) {
            XRRecipes.addRecipe(false, false, new ItemStack((Block)ModBlocks.pedestalPassive, 1, i), " c ", "gqg", "sss", Character.valueOf('c'), new ItemStack(Blocks.field_150404_cg, 1, i), Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('q'), Blocks.field_150371_ca, Character.valueOf('s'), new ItemStack((Block)Blocks.field_150333_U, 1, 7));
        }
        XRRecipes.addMobDropUncraftingRecipes();
        if (Settings.dropCraftingRecipesEnabled) {
            XRRecipes.addMobDropCraftingRecipes();
        }
    }

    private static void addLingeringPotionRecipes() {
        GameRegistry.addRecipe((IRecipe)new XRTippedArrowsRecipe());
        GameRegistry.addRecipe((IRecipe)new PotionBulletsRecipe());
        RecipeSorter.register((String)"xreliquary:tipped_arrows", XRTippedArrowsRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"xreliquary:potion_bullets", PotionBulletsRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    private static void addTomeRecipeHandlers() {
        if (ModItems.alkahestryTome.getRegistryName() == null || Settings.disabledItemsBlocks.contains(ModItems.alkahestryTome.getRegistryName().func_110623_a())) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new AlkahestryDrainRecipe());
        GameRegistry.addRecipe((IRecipe)new AlkahestryChargingRecipe());
        GameRegistry.addRecipe((IRecipe)new AlkahestryCraftingRecipe());
        RecipeSorter.register((String)"xreliquary:alkahest_crafting", AlkahestryCraftingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shaped");
        RecipeSorter.register((String)"xreliquary:alkahest_charge", AlkahestryChargingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:xreliquary:alkahest_crafting");
        RecipeSorter.register((String)"xreliquary:alkahest_drain", AlkahestryDrainRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:xreliquary:alkahest_charge");
    }

    private static void addMobCharmRecipeHandlers() {
        GameRegistry.addRecipe((IRecipe)new MobCharmDataFixRecipe());
        GameRegistry.addRecipe((IRecipe)new MobCharmRepairRecipe());
        RecipeSorter.register((String)"xreliquary:mob_charm_data_fix", MobCharmDataFixRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"before:minecraft:shaped");
        RecipeSorter.register((String)"xreliquary:mob_charm_repair", MobCharmRepairRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    private static void addMobCharmRecipe(byte type) {
        ItemStack mobCharm = XRRecipes.mobCharm(type);
        ItemStack fragment = XRRecipes.charmFragment(type);
        XRRecipes.addRecipe(false, false, mobCharm, "flf", "fsf", "f f", Character.valueOf('f'), fragment, Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('s'), Items.field_151007_F);
    }

    private static void addMobDropCraftingRecipes() {
        XRRecipes.addRecipe(false, false, RIB_BONE, "iii", "ibi", "iii", Character.valueOf('b'), Items.field_151103_aS, Character.valueOf('i'), Items.field_151042_j);
        XRRecipes.addRecipe(false, false, XRRecipes.ingredient(4, 1), "d d", " s ", "d d", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('s'), new ItemStack(Items.field_151144_bL, 1, 1));
        XRRecipes.addRecipe(false, false, CHELICERAE, "ggg", "gsg", "ggg", Character.valueOf('s'), Items.field_151007_F, Character.valueOf('g'), Items.field_151043_k);
        XRRecipes.addRecipe(false, false, CREEPER_GLAND, "ggg", "gpg", "ggg", Character.valueOf('p'), Items.field_151016_H, Character.valueOf('g'), Items.field_151043_k);
        XRRecipes.addRecipe(false, false, SLIME_PEARL, "iii", "isi", "iii", Character.valueOf('s'), Items.field_151123_aH, Character.valueOf('i'), Items.field_151042_j);
        XRRecipes.addRecipe(false, false, BAT_WING, "ggg", "gfg", "ggg", Character.valueOf('f'), Items.field_151008_G, Character.valueOf('g'), Items.field_151043_k);
        XRRecipes.addRecipe(false, false, ZOMBIE_HEART, "iii", "ifi", "iii", Character.valueOf('f'), Items.field_151078_bh, Character.valueOf('i'), Items.field_151042_j);
        XRRecipes.addRecipe(false, false, MOLTEN_CORE, "ggg", "gmg", "ggg", Character.valueOf('m'), Items.field_151064_bs, Character.valueOf('g'), Items.field_151043_k);
        XRRecipes.addRecipe(false, false, STORM_EYE, "ggg", "gcg", "ggg", Character.valueOf('c'), CREEPER_GLAND, Character.valueOf('g'), Items.field_151043_k);
        XRRecipes.addRecipe(false, false, FROZEN_CORE, "gpg", "gsg", "gsg", Character.valueOf('p'), Blocks.field_150423_aK, Character.valueOf('s'), Blocks.field_150433_aE, Character.valueOf('g'), Items.field_151043_k);
        XRRecipes.addRecipe(false, false, NEBULOUS_HEART, "ggg", "geg", "ggg", Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('g'), Items.field_151043_k);
        XRRecipes.addRecipe(false, false, SQUID_BEAK, "ggg", "gig", "ggg", Character.valueOf('i'), Items.field_151100_aR, Character.valueOf('g'), Items.field_151043_k);
        XRRecipes.addRecipe(false, false, GUARDIAN_SPIKE, "ggg", "gpg", "ggg", Character.valueOf('p'), Items.field_179562_cC, Character.valueOf('g'), Items.field_151043_k);
    }

    private static void addMobDropUncraftingRecipes() {
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151103_aS, 5), RIB_BONE);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151144_bL, 1, 1), WITHER_RIB, WITHER_RIB, WITHER_RIB, new ItemStack(Items.field_151144_bL));
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151079_bi, 3), NEBULOUS_HEART);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151100_aR, 6), SQUID_BEAK);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151007_F, 6), CHELICERAE);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151016_H, 6), CREEPER_GLAND);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151123_aH, 6), SLIME_PEARL);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151078_bh, 6), ZOMBIE_HEART);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151064_bs, 3), MOLTEN_CORE);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151016_H, 10), STORM_EYE);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_151126_ay, 5), FROZEN_CORE);
        XRRecipes.addRecipe(true, false, new ItemStack(Items.field_179562_cC, 5), GUARDIAN_SPIKE);
    }

    public static ItemStack gunPart(int amount, int meta) {
        return new ItemStack((Item)ModItems.gunPart, amount, meta);
    }

    public static ItemStack magazine(int amount, int meta) {
        return new ItemStack((Item)ModItems.magazine, amount, meta);
    }

    public static ItemStack bullet(int amount, int meta) {
        return new ItemStack((Item)ModItems.bullet, amount, meta);
    }

    public static ItemStack ingredient(int amount, int m) {
        return new ItemStack((Item)ModItems.mobIngredient, amount, m);
    }

    public static ItemStack charmFragment(int meta) {
        return new ItemStack((Item)ModItems.mobCharmFragment, 1, meta);
    }

    public static ItemStack mobCharm(byte meta) {
        ItemStack mobCharm = new ItemStack((Item)ModItems.mobCharm);
        ModItems.mobCharm.setType(mobCharm, meta);
        return mobCharm;
    }
}

