/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.config;

import crazypants.enderzoo.Log;
import crazypants.enderzoo.spawn.IBiomeFilter;
import crazypants.enderzoo.spawn.impl.BiomeDescriptor;
import crazypants.enderzoo.spawn.impl.BiomeFilterAll;
import crazypants.enderzoo.spawn.impl.BiomeFilterAny;
import crazypants.enderzoo.spawn.impl.DimensionFilter;
import crazypants.enderzoo.spawn.impl.SpawnEntry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SpawnConfigParser
extends DefaultHandler {
    public static final String ELEMENT_ROOT = "SpawnConfig";
    public static final String ELEMENT_ENTRY = "entry";
    public static final String ELEMENT_FILTER = "biomeFilter";
    public static final String ELEMENT_BIOME = "biome";
    public static final String ELEMENT_DIM_EXCLUDE = "dimensionExclude";
    public static final String ATT_ID = "id";
    public static final String ATT_ID_START = "idStart";
    public static final String ATT_ID_END = "idEnd";
    public static final String ATT_MOB_NAME = "mobName";
    public static final String ATT_CREATURE_TYPE = "creatureType";
    public static final String ATT_RATE = "rate";
    public static final String ATT_MIN_GRP = "minGroupSize";
    public static final String ATT_MAX_GRP = "maxGroupSize";
    public static final String ATT_REMOVE = "remove";
    public static final String ATT_NAME = "name";
    public static final String ATT_TYPE = "type";
    public static final String ATT_EXCLUDE = "exclude";
    private static final String FILTER_TYPE_ANY = "any";
    private static final String FILTER_TYPE_ALL = "all";
    public static final String BASE_LAND_TYPES = "BASE_LAND_TYPES";
    private static final BiomeDictionary.Type[] BASE_LAND_TYPES_ARR = new BiomeDictionary.Type[]{BiomeDictionary.Type.MESA, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.BEACH};
    private final List<SpawnEntry> result = new ArrayList<SpawnEntry>();
    private SpawnEntry currentEntry;
    private IBiomeFilter currentFilter;
    private boolean invalidEntryElement = false;
    private boolean foundRoot = false;
    private boolean documentedClosed = false;
    private boolean printedDocumentClosedWarn = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SpawnEntry> parseSpawnConfig(String text) throws Exception {
        StringReader sr = new StringReader(text);
        InputSource is = new InputSource(sr);
        try {
            List<SpawnEntry> list = SpawnConfigParser.parse(is);
            return list;
        }
        finally {
            IOUtils.closeQuietly((Reader)sr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SpawnEntry> parseSpawnConfig(File file) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        InputSource is = new InputSource(bis);
        try {
            List<SpawnEntry> list = SpawnConfigParser.parse(is);
            return list;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public static List<SpawnEntry> parse(InputSource is) throws Exception {
        SpawnConfigParser parser = new SpawnConfigParser();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(parser);
        xmlReader.parse(is);
        return parser.getResult();
    }

    public List<SpawnEntry> getResult() {
        return this.result;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.documentedClosed) {
            if (!this.printedDocumentClosedWarn) {
                Log.warn("Elements found after closing SpawnConfig they will be ignroed.");
                this.printedDocumentClosedWarn = true;
            }
            return;
        }
        if (ELEMENT_ROOT.equals(localName)) {
            if (this.foundRoot) {
                Log.warn("Mulitple SpawnConfig elements found.");
            }
            this.foundRoot = true;
        } else if (ELEMENT_ENTRY.equals(localName)) {
            if (!this.foundRoot) {
                Log.warn("Element entry found before SpawnConfig");
            }
            if (this.currentEntry != null) {
                Log.warn("New entry found before previous element closed. Discarding " + this.currentEntry);
            }
            this.parseEntry(attributes);
        } else if (ELEMENT_FILTER.equals(localName)) {
            if (!this.foundRoot) {
                Log.warn("Element biomeFilter found before SpawnConfig");
            }
            if (this.currentEntry == null) {
                if (!this.invalidEntryElement) {
                    Log.warn("biomeFilter found outside an entry element. It will be ignored.");
                }
                return;
            }
            this.parseFilter(attributes);
        } else if (ELEMENT_BIOME.equals(localName)) {
            if (!this.foundRoot) {
                Log.warn("Element biome found before SpawnConfig");
            }
            if (!(this.currentEntry != null && this.currentFilter != null || this.invalidEntryElement)) {
                Log.warn("biome found outside an entry and/or biomeFilter element. It will be ignored");
            }
            if (!this.invalidEntryElement && this.currentFilter != null) {
                this.parseBiomeType(attributes);
            }
        } else if (ELEMENT_DIM_EXCLUDE.equals(localName)) {
            if (!this.foundRoot) {
                Log.warn("Element dimensionExclude found before SpawnConfig");
            }
            if (this.currentEntry == null && !this.invalidEntryElement) {
                Log.warn("dimensionExclude found outside an entry and/or biomeFilter element. It will be ignored");
            } else if (this.currentEntry != null) {
                this.parseDimExclude(attributes);
            }
        }
    }

    private void parseDimExclude(Attributes attributes) {
        String name = SpawnConfigParser.getStringValue(ATT_NAME, attributes, null);
        if (name != null) {
            this.currentEntry.addDimensioFilter(new DimensionFilter(name));
            return;
        }
        int id = SpawnConfigParser.getIntValue(ATT_ID, attributes, Integer.MAX_VALUE);
        if (id != Integer.MAX_VALUE) {
            this.currentEntry.addDimensioFilter(new DimensionFilter(id));
            return;
        }
        this.currentEntry.addDimensioFilter(new DimensionFilter(SpawnConfigParser.getIntValue(ATT_ID_START, attributes, Integer.MAX_VALUE), SpawnConfigParser.getIntValue(ATT_ID_END, attributes, Integer.MAX_VALUE)));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ELEMENT_ENTRY.equals(localName) && this.currentEntry != null) {
            if (this.currentEntry != null) {
                this.result.add(this.currentEntry);
            }
            this.currentEntry = null;
        } else if (ELEMENT_FILTER.equals(localName)) {
            if (this.currentFilter != null && this.currentEntry != null) {
                this.currentEntry.addBiomeFilter(this.currentFilter);
            }
            this.currentFilter = null;
        } else if (ELEMENT_ROOT.equals(localName)) {
            this.documentedClosed = true;
        }
    }

    private void parseEntry(Attributes attributes) {
        int maxGrp;
        int minGrp;
        this.invalidEntryElement = false;
        String id = SpawnConfigParser.getStringValue(ATT_ID, attributes, null);
        if (id == null) {
            Log.error("entry specified without an id atribute");
            this.invalidEntryElement = true;
            return;
        }
        String mobName = SpawnConfigParser.getStringValue(ATT_MOB_NAME, attributes, null);
        if (this.isEmptyString(mobName)) {
            Log.error("entry specified without an mobName atribute");
            this.invalidEntryElement = true;
            return;
        }
        mobName = mobName.trim();
        int rate = SpawnConfigParser.getIntValue(ATT_RATE, attributes, -1);
        if (rate <= 0) {
            Log.error("entry specified without a valid rate atribute");
            this.invalidEntryElement = true;
            return;
        }
        rate = MathHelper.func_76125_a((int)rate, (int)1, (int)100);
        this.currentEntry = new SpawnEntry(id, mobName, rate);
        String creatureType = SpawnConfigParser.getStringValue(ATT_CREATURE_TYPE, attributes, null);
        if (creatureType != null) {
            try {
                this.currentEntry.setCreatureType(EnumCreatureType.valueOf((String)creatureType.trim()));
            }
            catch (Exception e) {
                Log.warn("Invalid value specified for creatureType in entry " + id + " using default value " + this.currentEntry.getCreatureType() + " error: " + e);
            }
        }
        if ((minGrp = SpawnConfigParser.getIntValue(ATT_MIN_GRP, attributes, -1)) != -1) {
            if (minGrp < 0) {
                Log.warn("Value less than 0 found for minGroupSize in entry " + id + " using default value " + this.currentEntry.getMinGroupSize());
            } else {
                this.currentEntry.setMinGroupSize(minGrp);
            }
        }
        if ((maxGrp = SpawnConfigParser.getIntValue(ATT_MAX_GRP, attributes, -1)) != -1) {
            if (maxGrp < this.currentEntry.getMinGroupSize()) {
                Log.warn("Value for maxGroupSize in entry " + id + " less than " + ATT_MIN_GRP + " using default " + this.currentEntry.getMaxGroupSize());
            } else {
                this.currentEntry.setMaxGroupSize(maxGrp);
            }
        }
        this.currentEntry.setIsRemove(SpawnConfigParser.getBooleanValue(ATT_REMOVE, attributes, this.currentEntry.isRemove()));
    }

    private void parseFilter(Attributes attributes) {
        String typeStr = SpawnConfigParser.getStringValue(ATT_TYPE, attributes, null);
        if (this.isEmptyString(typeStr)) {
            Log.warn("Attribue type not specified for element biomeFilter defaulting to 'any' filter");
            typeStr = FILTER_TYPE_ANY;
        }
        if (FILTER_TYPE_ANY.equals(typeStr)) {
            this.currentFilter = new BiomeFilterAny();
        } else if (FILTER_TYPE_ALL.equals(typeStr)) {
            this.currentFilter = new BiomeFilterAll();
        }
        if (this.currentFilter == null) {
            Log.warn("Unknown type '" + typeStr + "' specified for filter. Filter will be ignored.");
        }
    }

    private void parseBiomeType(Attributes attributes) {
        String biomeName = SpawnConfigParser.getStringValue(ATT_NAME, attributes, null);
        boolean nameEmpty = this.isEmptyString(biomeName);
        String biomeType = SpawnConfigParser.getStringValue(ATT_TYPE, attributes, null);
        boolean typeEmpty = this.isEmptyString(biomeType);
        if (nameEmpty && typeEmpty) {
            Log.warn("Attribute name or type not specified in element biome in entry " + this.currentEntry.getId());
            return;
        }
        if (!nameEmpty && !typeEmpty) {
            Log.warn("Attribute name and type both specified in element biome in entry " + this.currentEntry.getId() + ". It will be ignored");
            return;
        }
        boolean isExclude = SpawnConfigParser.getBooleanValue(ATT_EXCLUDE, attributes, false);
        if (!typeEmpty) {
            if (BASE_LAND_TYPES.equals(biomeType = biomeType.trim())) {
                for (BiomeDictionary.Type type : BASE_LAND_TYPES_ARR) {
                    this.currentFilter.addBiomeDescriptor(new BiomeDescriptor(type, isExclude));
                }
            } else {
                try {
                    BiomeDictionary.Type type = BiomeDictionary.Type.valueOf((String)biomeType);
                    this.currentFilter.addBiomeDescriptor(new BiomeDescriptor(type, isExclude));
                }
                catch (Exception e) {
                    Log.warn("Attribute type in element biome with value " + biomeType + " is invalid and has been ignored.");
                }
            }
            return;
        }
        this.currentFilter.addBiomeDescriptor(new BiomeDescriptor(biomeName.trim(), isExclude));
    }

    protected boolean isEmptyString(String str) {
        return str == null || str.trim().length() == 0;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        Log.warn("Warning parsing Spawn config file: " + e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        Log.error("Error parsing Spawn config file: " + e.getMessage());
        e.printStackTrace();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        Log.error("Error parsing Spawn config file: " + e.getMessage());
        e.printStackTrace();
    }

    public static boolean getBooleanValue(String qName, Attributes attributes, boolean def) {
        String val = attributes.getValue(qName);
        if (val == null) {
            return def;
        }
        return (val = val.toLowerCase().trim()).equals("false") ? false : (val.equals("true") ? true : def);
    }

    public static int getIntValue(String qName, Attributes attributes, int def) {
        try {
            return Integer.parseInt(SpawnConfigParser.getStringValue(qName, attributes, def + ""));
        }
        catch (Exception e) {
            Log.warn("Could not parse a valid int for attribute " + qName + " with value " + SpawnConfigParser.getStringValue(qName, attributes, null));
            return def;
        }
    }

    public static float getFloatValue(String qName, Attributes attributes, float def) {
        try {
            return Float.parseFloat(SpawnConfigParser.getStringValue(qName, attributes, def + ""));
        }
        catch (Exception e) {
            Log.warn("Could not parse a valid float for attribute " + qName + " with value " + SpawnConfigParser.getStringValue(qName, attributes, null));
            return def;
        }
    }

    public static String getStringValue(String qName, Attributes attributes, String def) {
        String val = attributes.getValue(qName);
        if (val == null) {
            return def;
        }
        if ((val = val.trim()).length() <= 0) {
            return null;
        }
        return val;
    }
}

