/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import zairus.hermitquest.HermitQuest;

public class BlockSlimeHead
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockSlimeHead() {
        super(Material.field_151571_B);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(HermitQuest.hqTab);
        this.func_149672_a(SoundType.field_185859_l);
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        AxisAlignedBB axis = new AxisAlignedBB(pos).func_72314_b(16.0, 16.0, 16.0);
        List players = world.func_72872_a(EntityPlayer.class, axis);
        for (EntityPlayer player : players) {
            player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)Potion.func_188409_a((Potion)MobEffects.field_76430_j)), 500, 2, true, false));
        }
        List slimes = world.func_72872_a(EntitySlime.class, axis);
        for (EntitySlime slime : slimes) {
            slime.func_70624_b(null);
            if (slime.field_70715_bh == null || slime.field_70715_bh.field_75782_a == null || slime.field_70715_bh.field_75782_a.isEmpty()) continue;
            ArrayList<EntityAIBase> aiToRemove = new ArrayList<EntityAIBase>();
            for (EntityAITasks.EntityAITaskEntry entry : slime.field_70715_bh.field_75782_a) {
                if (!(entry.field_75733_a instanceof EntityAIFindEntityNearestPlayer) && !(entry.field_75733_a instanceof EntityAIFindEntityNearest)) continue;
                aiToRemove.add(entry.field_75733_a);
            }
            for (EntityAIBase ai : aiToRemove) {
                slime.field_70715_bh.func_85156_a(ai);
            }
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        world.func_180501_a(pos, state, 3);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }
}

