/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.hermitquest.HermitQuest;
import zairus.hermitquest.client.renderer.ISpecialRendered;
import zairus.hermitquest.client.renderer.tileentity.TileEntityContainerBaseRenderer;
import zairus.hermitquest.tileentity.HQTileEntityBase;
import zairus.hermitquest.tileentity.TileEntityBuildersChest;

public class BlockBuildersChest
extends BlockContainer
implements ISpecialRendered {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB NORTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.875, 0.9375);
    protected static final AxisAlignedBB SOUTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 1.0);
    protected static final AxisAlignedBB WEST_CHEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    protected static final AxisAlignedBB EAST_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 0.875, 0.9375);
    protected static final AxisAlignedBB NOT_CONNECTED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public BlockBuildersChest() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(HermitQuest.hqTab);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Object getTESR() {
        return new TileEntityContainerBaseRenderer();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return NOT_CONNECTED_AABB;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        worldIn.func_180501_a(pos, state, 3);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityBuildersChest) {
            if (stack.func_82837_s()) {
                ((TileEntityBuildersChest)tileentity).setCustomName(stack.func_82833_r());
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("chestContents")) {
                NBTTagCompound tag = stack.func_77978_p().func_74775_l("chestContents");
                ((TileEntityBuildersChest)tileentity).func_145839_a(tag);
                tileentity.func_174878_a(pos);
            }
        }
    }

    public IBlockState correctFacing(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = null;
        for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(enumfacing1));
            if (iblockstate.func_177230_c() == this) {
                return state;
            }
            if (!iblockstate.func_185913_b()) continue;
            if (enumfacing != null) {
                enumfacing = null;
                break;
            }
            enumfacing = enumfacing1;
        }
        if (enumfacing != null) {
            return state.func_177226_a((IProperty)FACING, (Comparable)enumfacing.func_176734_d());
        }
        EnumFacing enumfacing2 = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176746_e();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)enumfacing2);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        Item item = this.func_180660_a(state, world.field_73012_v, 0);
        ItemStack itemStack = new ItemStack(item, 1, this.func_180651_a(state));
        if (te instanceof HQTileEntityBase && !((HQTileEntityBase)te).isEmpty()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag = ((HQTileEntityBase)te).func_189515_b(tag);
            itemStack.func_77982_d(new NBTTagCompound());
            itemStack.func_77978_p().func_74782_a("chestContents", (NBTBase)tag);
        }
        BlockBuildersChest.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof HQTileEntityBase) {
            player.openGui((Object)HermitQuest.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            player.func_71029_a(StatList.field_188063_ac);
        }
        return true;
    }

    @Nullable
    public ILockableContainer getLockableContainer(World world, BlockPos pos) {
        return this.getContainer(world, pos, false);
    }

    @Nullable
    public ILockableContainer getContainer(World world, BlockPos pos, boolean flag) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityBuildersChest)) {
            return null;
        }
        TileEntityBuildersChest ilockablecontainer = (TileEntityBuildersChest)tileentity;
        if (this.isBlocked(world, pos)) {
            return null;
        }
        return ilockablecontainer;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        TileEntityBuildersChest te = new TileEntityBuildersChest();
        te.setCustomName("Builder's Chest");
        return te;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!blockState.func_185897_m()) {
            return 0;
        }
        int i = 0;
        TileEntity tileentity = blockAccess.func_175625_s(pos);
        if (tileentity instanceof TileEntityBuildersChest) {
            i = ((TileEntityBuildersChest)tileentity).playersUsing;
        }
        return MathHelper.func_76125_a((int)i, (int)0, (int)15);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos) || this.isOcelotSittingOnChest(worldIn, pos);
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World worldIn, BlockPos pos) {
        for (Entity entity : worldIn.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot entityocelot = (EntityOcelot)entity;
            if (!entityocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.getLockableContainer(worldIn, pos));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

