/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter.client;

import com.google.common.collect.ImmutableList;
import cubex2.mods.chesttransporter.ItemChestTransporter;
import cubex2.mods.chesttransporter.chests.ChestRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelCH
implements IPerspectiveAwareModel {
    public static final ModelResourceLocation location = new ModelResourceLocation("chesttransporter:smart_wood", "inventory");
    private final Map<String, IBakedModel> chestModels;
    private IBakedModel handle;
    private OverrideList overrides;
    private IBakedModel toUse = null;

    public BakedModelCH(IBakedModel handle, Map<String, IBakedModel> chestModels) {
        this.handle = handle;
        this.chestModels = chestModels;
        this.overrides = new OverrideList(this);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.addAll(this.handle.func_188616_a(state, side, rand));
        if (this.toUse != null) {
            quads.addAll(this.toUse.func_188616_a(state, side, rand));
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.handle.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.handle.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.handle.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.handle.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        byte chestType = ItemChestTransporter.getTagCompound(stack).func_74771_c("ChestType");
        if (chestType == 0) {
            this.toUse = null;
        } else {
            String modelName = ChestRegistry.dvToChest.get(chestType).getModelName(stack);
            this.toUse = this.chestModels.get(modelName);
        }
        return this;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)((IPerspectiveAwareModel)this.handle).handlePerspective(cameraTransformType).getRight());
    }

    private static class OverrideList
    extends ItemOverrideList {
        private final BakedModelCH model;

        public OverrideList(BakedModelCH model) {
            super((List)ImmutableList.of());
            this.model = model;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemChestTransporter)) {
                return super.handleItemState(originalModel, stack, world, entity);
            }
            return this.model.handleItemState(originalModel, stack, world, entity);
        }
    }
}

