/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.gui.GuiProcessingPatternEncoder;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataConsumer;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataProducer;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileProcessingPatternEncoder
extends TileBase {
    private static final String NBT_OREDICT_PATTERN = "OredictPattern";
    public static final TileDataParameter<Boolean> OREDICT_PATTERN = new TileDataParameter<Boolean>(DataSerializers.field_187198_h, false, new ITileDataProducer<Boolean, TileProcessingPatternEncoder>(){

        @Override
        public Boolean getValue(TileProcessingPatternEncoder tile) {
            return tile.oredictPattern;
        }
    }, new ITileDataConsumer<Boolean, TileProcessingPatternEncoder>(){

        @Override
        public void setValue(TileProcessingPatternEncoder tile, Boolean value) {
            tile.oredictPattern = value;
            tile.func_70296_d();
        }
    }, parameter -> {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiProcessingPatternEncoder) {
            ((GuiProcessingPatternEncoder)Minecraft.func_71410_x().field_71462_r).updateOredictPattern((Boolean)parameter.getValue());
        }
    });
    private ItemHandlerBasic patterns = new ItemHandlerBasic(2, this, new ItemValidatorBasic(RSItems.PATTERN));
    private ItemHandlerBasic configuration = new ItemHandlerBasic(18, this, new IItemValidator[0]);
    private boolean oredictPattern;

    public TileProcessingPatternEncoder() {
        this.dataManager.addWatchedParameter(OREDICT_PATTERN);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        RSUtils.writeItems((IItemHandler)this.patterns, 0, tag);
        RSUtils.writeItems((IItemHandler)this.configuration, 1, tag);
        tag.func_74757_a(NBT_OREDICT_PATTERN, this.oredictPattern);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.patterns, 0, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.configuration, 1, tag);
        if (tag.func_74764_b(NBT_OREDICT_PATTERN)) {
            this.oredictPattern = tag.func_74767_n(NBT_OREDICT_PATTERN);
        }
    }

    public void onCreatePattern() {
        if (this.canCreatePattern()) {
            ItemStack pattern = new ItemStack((Item)RSItems.PATTERN);
            ItemPattern.setOredict(pattern, this.oredictPattern);
            for (int i = 0; i < 18; ++i) {
                if (this.configuration.getStackInSlot(i) == null) continue;
                if (i >= 9) {
                    ItemPattern.addOutput(pattern, this.configuration.getStackInSlot(i));
                    continue;
                }
                ItemPattern.setSlot(pattern, i, this.configuration.getStackInSlot(i));
            }
            this.patterns.extractItem(0, 1, false);
            this.patterns.setStackInSlot(1, pattern);
        }
    }

    public boolean canCreatePattern() {
        int i;
        int inputsFilled = 0;
        int outputsFilled = 0;
        for (i = 0; i < 9; ++i) {
            if (this.configuration.getStackInSlot(i) == null) continue;
            ++inputsFilled;
        }
        for (i = 9; i < 18; ++i) {
            if (this.configuration.getStackInSlot(i) == null) continue;
            ++outputsFilled;
        }
        return inputsFilled > 0 && outputsFilled > 0 && this.patterns.getStackInSlot(0) != null && this.patterns.getStackInSlot(1) == null;
    }

    public ItemHandlerBasic getPatterns() {
        return this.patterns;
    }

    public ItemHandlerBasic getConfiguration() {
        return this.configuration;
    }

    @Override
    public IItemHandler getDrops() {
        return this.patterns;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.patterns);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

