/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.autopackager;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.mcupdater.autopackager.BlockPackager;
import org.mcupdater.autopackager.ClearRecipeCacheCommand;
import org.mcupdater.autopackager.ItemBlockPackager;
import org.mcupdater.autopackager.TilePackager;
import org.mcupdater.autopackager.proxy.CommonProxy;

@Mod(useMetadata=true, modid="autopackager", acceptedMinecraftVersions="[1.9.4]")
public class AutoPackager {
    @SidedProxy(clientSide="org.mcupdater.autopackager.proxy.ClientProxy", serverSide="org.mcupdater.autopackager.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration config;
    public static Block packagerBlock;
    public static int energyPerCycle;
    public static int delayCycleNormal;
    public static int delayCycleIdle;
    public static Map<ItemStack, ItemStack> large;
    public static Map<ItemStack, ItemStack> small;
    public static Map<ItemStack, ItemStack> hollow;
    public static Map<ItemStack, ItemStack> single;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        energyPerCycle = config.get("General", "RF_per_cycle", 1000).getInt(1000);
        delayCycleNormal = config.get("General", "cycle_delay_ticks", 10).getInt(10);
        delayCycleIdle = config.get("General", "idle_delay_ticks", 200).getInt(200);
        if (config.hasChanged()) {
            config.save();
        }
        packagerBlock = new BlockPackager();
        GameRegistry.registerBlock((Block)packagerBlock, ItemBlockPackager.class, (String)packagerBlock.func_149739_a().replace("tile.", ""));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        GameRegistry.registerTileEntity(TilePackager.class, (String)"AutoPackager");
        if (Loader.isModLoaded((String)"Waila")) {
            FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"org.mcupdater.autopackager.compat.WailaRegistry.initWaila");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.loadRecipes();
        if (proxy.isClient()) {
            proxy.doClientRegistrations();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new ClearRecipeCacheCommand());
    }

    private void loadRecipes() {
        ItemStack keyItem = new ItemStack(GameRegistry.findItem((String)"ThermalExpansion", (String)"powerCoilGold"), 1);
        if (keyItem.func_77973_b() == null) {
            keyItem = new ItemStack(Items.field_151137_ax);
        }
        System.out.println("Key item: " + keyItem.func_82833_r());
        ShapedOreRecipe recipePackager = new ShapedOreRecipe(new ItemStack(packagerBlock, 1), new Object[]{"ipi", "ptp", "ici", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('p'), Blocks.field_150331_J, Character.valueOf('t'), Blocks.field_150462_ai, Character.valueOf('c'), keyItem});
        GameRegistry.addRecipe((IRecipe)recipePackager);
    }

    static {
        large = new HashMap<ItemStack, ItemStack>();
        small = new HashMap<ItemStack, ItemStack>();
        hollow = new HashMap<ItemStack, ItemStack>();
        single = new HashMap<ItemStack, ItemStack>();
    }
}

