/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.elements;

import io.github.drmanganese.topaddons.addons.AddonForge;
import io.github.drmanganese.topaddons.elements.ElementRenderHelper;
import io.github.drmanganese.topaddons.styles.ProgressStyleTank;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import mcjty.theoneprobe.network.NetworkTools;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.client.Minecraft;

public class ElementTankGauge
implements IElement {
    private final String tankName;
    private final String fluidName;
    private final String suffix;
    private final int amount;
    private final int capacity;
    private final int color1;
    private final int color2;
    private final boolean sneaking;

    public ElementTankGauge(String tankName, String fluidName, int amount, int capacity, String suffix, int color1, boolean sneaking) {
        this.tankName = tankName;
        this.fluidName = fluidName;
        this.amount = amount;
        this.capacity = capacity;
        this.suffix = suffix;
        this.color1 = color1;
        this.color2 = new Color(this.color1).darker().hashCode();
        this.sneaking = sneaking;
    }

    public ElementTankGauge(ByteBuf buf) {
        this.tankName = NetworkTools.readString((ByteBuf)buf);
        this.fluidName = NetworkTools.readString((ByteBuf)buf);
        this.amount = buf.readInt();
        this.capacity = buf.readInt();
        this.suffix = NetworkTools.readString((ByteBuf)buf);
        this.color1 = buf.readInt();
        this.color2 = new Color(this.color1).darker().hashCode();
        this.sneaking = buf.readBoolean();
    }

    public void render(int x, int y) {
        if (this.capacity > 0) {
            ElementProgressRender.render((IProgressStyle)new ProgressStyleTank().filledColor(this.color1).alternateFilledColor(this.color2), (long)this.amount, (long)this.capacity, (int)x, (int)y, (int)100, (int)(this.sneaking ? 12 : 8));
        } else {
            ElementProgressRender.render((IProgressStyle)new ProgressStyleTank(), (long)this.amount, (long)this.capacity, (int)x, (int)y, (int)100, (int)(this.sneaking ? 12 : 8));
        }
        if (this.sneaking) {
            for (int i = 1; i < 10; ++i) {
                RenderHelper.drawVerticalLine((int)(x + i * 10), (int)(y + 1), (int)(y + (i == 5 ? 11 : 6)), (int)-9013642);
            }
            ElementTextRender.render((String)(this.capacity > 0 ? this.amount + "/" + this.capacity + " " + this.suffix : "Empty"), (int)(x + 3), (int)(y + 2));
            ElementRenderHelper.drawSmallText(x + 99 - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.fluidName) / 2, y + 13, this.fluidName, this.color1);
        }
        ElementRenderHelper.drawSmallText(this.sneaking ? x + 1 : x + 2, this.sneaking ? y + 13 : y + 2, this.tankName, -1);
        RenderHelper.drawVerticalLine((int)(x + 99), (int)y, (int)(y + (this.sneaking ? 12 : 8)), (int)-6908266);
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return this.sneaking ? 18 : 8;
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)this.tankName);
        NetworkTools.writeString((ByteBuf)buf, (String)this.fluidName);
        buf.writeInt(this.amount);
        buf.writeInt(this.capacity);
        NetworkTools.writeString((ByteBuf)buf, (String)this.suffix);
        buf.writeInt(this.color1);
        buf.writeBoolean(this.sneaking);
    }

    public int getID() {
        return AddonForge.ELEMENT_TANK;
    }
}

