/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import ic2.core.block.TileEntityHeatSourceInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.block.machine.tileentity.TileEntityCanner;
import ic2.core.block.machine.tileentity.TileEntityFermenter;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import ic2.core.block.machine.tileentity.TileEntityTeleporter;
import ic2.core.block.machine.tileentity.TileEntityTerra;
import ic2.core.block.wiring.TileEntityElectricBlock;
import ic2.core.item.armor.ItemArmorHazmat;
import ic2.core.item.armor.ItemArmorNanoSuit;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.item.armor.ItemArmorSolarHelmet;
import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.config.capabilities.IClientOptsCapability;
import io.github.drmanganese.topaddons.reference.EnumChip;
import io.github.drmanganese.topaddons.reference.Names;
import io.github.drmanganese.topaddons.styles.ProgressStyleTOPAddonGrey;
import java.util.HashMap;
import java.util.Map;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

@TOPAddon(dependency="IC2", order=0)
public class AddonIndustrialCraft2
extends AddonBlank {
    @Override
    public void addTankNames() {
        Names.tankNamesMap.put(TileEntityGeoGenerator.class, new String[]{"Buffer"});
        Names.tankNamesMap.put(TileEntityCanner.class, new String[]{"Input", "Output"});
    }

    @Override
    public boolean hasSpecialHelmets() {
        return true;
    }

    @Override
    public Map<Class<? extends ItemArmor>, EnumChip> getSpecialHelmets() {
        HashMap<Class<? extends ItemArmor>, EnumChip> map = new HashMap<Class<? extends ItemArmor>, EnumChip>();
        map.put(ItemArmorNanoSuit.class, EnumChip.IC2);
        map.put(ItemArmorQuantumSuit.class, EnumChip.IC2);
        map.put(ItemArmorHazmat.class, EnumChip.IC2);
        map.put(ItemArmorSolarHelmet.class, EnumChip.IC2);
        map.put(ItemArmorHazmat.class, EnumChip.IC2);
        return map;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile != null) {
            if (tile instanceof TileEntityStandardMachine) {
                TileEntityStandardMachine machine = (TileEntityStandardMachine)tile;
                double energyStorage = machine.defaultEnergyStorage * 2 + machine.upgradeSlot.extraEnergyStorage;
                this.euBar(probeInfo, (int)machine.getEnergy(), (int)(machine.getEnergy() > energyStorage ? machine.getEnergy() : energyStorage));
                if (mode == ProbeMode.EXTENDED) {
                    this.textPrefixed(probeInfo, "Consumption", machine.energyConsume + " EU/t");
                }
                if (((IClientOptsCapability)player.getCapability(TOPAddons.OPTS_CAP, null)).getBoolean("ic2Progress") && machine.getProgress() > 0.0f || mode == ProbeMode.EXTENDED) {
                    probeInfo.progress((long)(machine.getProgress() * 100.0f), 100L, (IProgressStyle)new ProgressStyleTOPAddonGrey().prefix("Progress: ").suffix("%").filledColor(-5592406).alternateFilledColor(-7829368));
                }
            }
            if (tile instanceof TileEntitySolarGenerator && ((TileEntitySolarGenerator)tile).skyLight == 0.0f) {
                probeInfo.text(TextFormatting.RED + "Sky Obstructed/Too Dark");
            }
            if (tile instanceof TileEntityElectricBlock) {
                Energy energy = ((TileEntityElectricBlock)tile).energy;
                this.euBar(probeInfo, (int)energy.getEnergy(), (int)energy.getCapacity());
            }
            if (tile instanceof TileEntityTeleporter) {
                BlockPos pos = ((TileEntityTeleporter)tile).getTarget();
                this.textPrefixed(probeInfo, "Destination", ((TileEntityTeleporter)tile).hasTarget() ? String.format("%d %d %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) : "none");
            }
            if (tile instanceof TileEntityTerra) {
                if (!((TileEntityTerra)tile).tfbpSlot.isEmpty()) {
                    this.textPrefixed(probeInfo, "Blueprint", ((TileEntityTerra)tile).tfbpSlot.get().func_82833_r().substring(7), TextFormatting.AQUA);
                } else {
                    this.textPrefixed(probeInfo, "Blueprint", "None", TextFormatting.AQUA);
                }
            }
            if (tile instanceof TileEntityHeatSourceInventory) {
                this.textPrefixed(probeInfo, "Transmitting", ((TileEntityHeatSourceInventory)tile).gettransmitHeat() + " hU");
                this.textPrefixed(probeInfo, "Buffer", ((TileEntityHeatSourceInventory)tile).getHeatBuffer() + " hU");
                this.textPrefixed(probeInfo, "Max transfer", ((TileEntityHeatSourceInventory)tile).getMaxHeatEmittedPerTick() + " hU");
            }
            if (tile instanceof TileEntityFermenter) {
                TileEntityFermenter fermenter = (TileEntityFermenter)tile;
                probeInfo.progress(Math.round(100.0 * fermenter.getGuiValue("heat")), 100L, (IProgressStyle)new ProgressStyleTOPAddonGrey().prefix("Conversion: ").suffix("%").alternateFilledColor(-2023135).filledColor(-7924716));
                probeInfo.progress(Math.round(100.0 * fermenter.getGuiValue("progress")), 100L, (IProgressStyle)new ProgressStyleTOPAddonGrey().prefix("Waste: ").suffix("%").alternateFilledColor(-15829490).filledColor(-16234744));
            }
            if (tile instanceof TileEntityPump) {
                this.euBar(probeInfo, (int)((TileEntityPump)tile).getEnergy(), 40);
            }
        }
    }

    private void euBar(IProbeInfo probeInfo, int energy, int capacity) {
        probeInfo.progress(energy, capacity, probeInfo.defaultProgressStyle().suffix(" EU").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(NumberFormat.COMPACT));
    }
}

