/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedOreRecipe
implements agd {
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;
    protected adz output = null;
    protected Object[] input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;

    public ShapedOreRecipe(akf result, Object ... recipe) {
        this(new adz(result), recipe);
    }

    public ShapedOreRecipe(adx result, Object ... recipe) {
        this(new adz(result), recipe);
    }

    public ShapedOreRecipe(adz result, Object ... recipe) {
        this.output = result.k();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof adz) {
                itemMap.put(chr, ((adz)in).k());
            } else if (in instanceof adx) {
                itemMap.put(chr, new adz((adx)in));
            } else if (in instanceof akf) {
                itemMap.put(chr, new adz((akf)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)in));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    ShapedOreRecipe(agg recipe, Map<adz, String> replacements) {
        this.output = recipe.b();
        this.width = recipe.a;
        this.height = recipe.b;
        this.input = new Object[recipe.c.length];
        block0: for (int i = 0; i < this.input.length; ++i) {
            adz ingredient = recipe.c[i];
            if (ingredient == null) continue;
            this.input[i] = recipe.c[i];
            for (Map.Entry<adz, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches(replace.getKey(), ingredient, true)) continue;
                this.input[i] = OreDictionary.getOres(replace.getValue());
                continue block0;
            }
        }
    }

    public adz a(abl var1) {
        return this.output.k();
    }

    public int a() {
        return this.input.length;
    }

    public adz b() {
        return this.output;
    }

    public boolean a(abl inv, aid world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(abl inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                adz slot = inv.c(x, y);
                if (target instanceof adz) {
                    if (OreDictionary.itemMatches((adz)target, slot, false)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((adz)itr.next(), slot, false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    public adz[] b(abl inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems(inv);
    }
}

