/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.terraingen.DeferredBiomeDecorator;
import net.minecraftforge.fml.common.FMLLog;

public class BiomeDictionary {
    private static HashMap<kn, BiomeInfo> biomeInfoMap = new HashMap();
    private static ArrayList<aiq>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerBiomeType(aiq biome, Type ... types) {
        types = BiomeDictionary.listSubTags(types);
        if (aiq.q.b((Object)biome) != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    BiomeDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(biome);
            }
            if (!BiomeDictionary.isBiomeRegistered(biome)) {
                kn location = (kn)aiq.q.b((Object)biome);
                biomeInfoMap.put(location, new BiomeInfo(types));
            } else {
                for (Type type : types) {
                    BiomeDictionary.getBiomeInfo((aiq)biome).typeList.add(type);
                }
            }
            return true;
        }
        return false;
    }

    public static aiq[] getBiomesForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new aiq[0]);
        }
        return new aiq[0];
    }

    public static Type[] getTypesForBiome(aiq biome) {
        BiomeDictionary.checkRegistration(biome);
        return BiomeDictionary.getBiomeInfo((aiq)biome).typeList.toArray(new Type[0]);
    }

    public static boolean areBiomesEquivalent(aiq biomeA, aiq biomeB) {
        BiomeDictionary.checkRegistration(biomeA);
        BiomeDictionary.checkRegistration(biomeB);
        for (Type type : BiomeDictionary.getTypesForBiome(biomeA)) {
            if (!BiomeDictionary.containsType(BiomeDictionary.getBiomeInfo(biomeB), type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBiomeOfType(aiq biome, Type type) {
        BiomeDictionary.checkRegistration(biome);
        return BiomeDictionary.containsType(BiomeDictionary.getBiomeInfo(biome), type);
    }

    public static boolean isBiomeRegistered(aiq biome) {
        return biomeInfoMap.containsKey(aiq.q.b((Object)biome));
    }

    public static void registerAllBiomes() {
        FMLLog.warning("Redundant call to BiomeDictionary.registerAllBiomes ignored", new Object[0]);
    }

    public static void registerAllBiomesAndGenerateEvents() {
        for (kn biomeResource : aiq.q.c()) {
            aiq biome = (aiq)aiq.q.c((Object)biomeResource);
            if (biome.t instanceof DeferredBiomeDecorator) {
                DeferredBiomeDecorator decorator = (DeferredBiomeDecorator)biome.t;
                decorator.fireCreateEventAndReplace(biome);
            }
            BiomeDictionary.checkRegistration(biome);
        }
    }

    public static void makeBestGuess(aiq biome) {
        if (biome.t.z >= 3) {
            if (biome.e() && biome.n() >= 0.9f) {
                BiomeDictionary.registerBiomeType(biome, Type.JUNGLE);
            } else if (!biome.e()) {
                BiomeDictionary.registerBiomeType(biome, Type.FOREST);
                if (biome.n() <= 0.2f) {
                    BiomeDictionary.registerBiomeType(biome, Type.CONIFEROUS);
                }
            }
        } else if (biome.m() <= 0.3f && biome.m() >= 0.0f && (!biome.e() || biome.j() >= 0.0f)) {
            BiomeDictionary.registerBiomeType(biome, Type.PLAINS);
        }
        if (biome.k() > 0.85f) {
            BiomeDictionary.registerBiomeType(biome, Type.WET);
        }
        if (biome.k() < 0.15f) {
            BiomeDictionary.registerBiomeType(biome, Type.DRY);
        }
        if (biome.n() > 0.85f) {
            BiomeDictionary.registerBiomeType(biome, Type.HOT);
        }
        if (biome.n() < 0.15f) {
            BiomeDictionary.registerBiomeType(biome, Type.COLD);
        }
        if (biome.t.z > 0 && biome.t.z < 3) {
            BiomeDictionary.registerBiomeType(biome, Type.SPARSE);
        } else if (biome.t.z >= 10) {
            BiomeDictionary.registerBiomeType(biome, Type.DENSE);
        }
        if (biome.e() && biome.j() < 0.0f && biome.m() <= 0.3f && biome.m() >= 0.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.SWAMP);
        }
        if (biome.j() <= -0.5f) {
            if (biome.m() == 0.0f) {
                BiomeDictionary.registerBiomeType(biome, Type.RIVER);
            } else {
                BiomeDictionary.registerBiomeType(biome, Type.OCEAN);
            }
        }
        if (biome.m() >= 0.4f && biome.m() < 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.HILLS);
        }
        if (biome.m() >= 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.MOUNTAIN);
        }
        if (biome.c()) {
            BiomeDictionary.registerBiomeType(biome, Type.SNOWY);
        }
        if (biome.r != akg.m && biome.n() >= 1.0f && biome.k() < 0.2f) {
            BiomeDictionary.registerBiomeType(biome, Type.SAVANNA);
        }
        if (biome.r == akg.m) {
            BiomeDictionary.registerBiomeType(biome, Type.SANDY);
        } else if (biome.r == akg.bw) {
            BiomeDictionary.registerBiomeType(biome, Type.MUSHROOM);
        }
        if (biome.s == akg.cz) {
            BiomeDictionary.registerBiomeType(biome, Type.MESA);
        }
    }

    private static BiomeInfo getBiomeInfo(aiq biome) {
        return biomeInfoMap.get(aiq.q.b((Object)biome));
    }

    private static void checkRegistration(aiq biome) {
        if (!BiomeDictionary.isBiomeRegistered(biome)) {
            BiomeDictionary.makeBestGuess(biome);
        }
    }

    private static boolean containsType(BiomeInfo info, Type type) {
        if (type.hasSubTags()) {
            for (Type remappedType : BiomeDictionary.listSubTags(type)) {
                if (!info.typeList.contains((Object)remappedType)) continue;
                return true;
            }
            return false;
        }
        return info.typeList.contains((Object)type);
    }

    private static Type[] listSubTags(Type ... types) {
        ArrayList<Type> subTags = new ArrayList<Type>();
        for (Type type : types) {
            if (type.hasSubTags()) {
                subTags.addAll(type.subTags);
                continue;
            }
            subTags.add(type);
        }
        return subTags.toArray(new Type[subTags.size()]);
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.registerBiomeType(aiv.a, Type.OCEAN);
        BiomeDictionary.registerBiomeType(aiv.c, Type.PLAINS);
        BiomeDictionary.registerBiomeType(aiv.d, Type.HOT, Type.DRY, Type.SANDY);
        BiomeDictionary.registerBiomeType(aiv.e, Type.MOUNTAIN, Type.HILLS);
        BiomeDictionary.registerBiomeType(aiv.f, Type.FOREST);
        BiomeDictionary.registerBiomeType(aiv.g, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.registerBiomeType(aiv.u, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(aiv.h, Type.WET, Type.SWAMP);
        BiomeDictionary.registerBiomeType(aiv.i, Type.RIVER);
        BiomeDictionary.registerBiomeType(aiv.l, Type.COLD, Type.OCEAN, Type.SNOWY);
        BiomeDictionary.registerBiomeType(aiv.m, Type.COLD, Type.RIVER, Type.SNOWY);
        BiomeDictionary.registerBiomeType(aiv.n, Type.COLD, Type.SNOWY, Type.WASTELAND);
        BiomeDictionary.registerBiomeType(aiv.o, Type.COLD, Type.SNOWY, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(aiv.r, Type.BEACH);
        BiomeDictionary.registerBiomeType(aiv.s, Type.HOT, Type.DRY, Type.SANDY, Type.HILLS);
        BiomeDictionary.registerBiomeType(aiv.w, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(aiv.x, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.HILLS);
        BiomeDictionary.registerBiomeType(aiv.t, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(aiv.k, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.registerBiomeType(aiv.j, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.registerBiomeType(aiv.p, Type.MUSHROOM);
        BiomeDictionary.registerBiomeType(aiv.v, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(aiv.q, Type.MUSHROOM, Type.BEACH);
        BiomeDictionary.registerBiomeType(aiv.y, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST);
        BiomeDictionary.registerBiomeType(aiv.z, Type.OCEAN);
        BiomeDictionary.registerBiomeType(aiv.A, Type.BEACH);
        BiomeDictionary.registerBiomeType(aiv.B, Type.COLD, Type.BEACH, Type.SNOWY);
        BiomeDictionary.registerBiomeType(aiv.C, Type.FOREST);
        BiomeDictionary.registerBiomeType(aiv.D, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(aiv.E, Type.SPOOKY, Type.DENSE, Type.FOREST);
        BiomeDictionary.registerBiomeType(aiv.F, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY);
        BiomeDictionary.registerBiomeType(aiv.G, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.HILLS);
        BiomeDictionary.registerBiomeType(aiv.H, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.registerBiomeType(aiv.I, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.registerBiomeType(aiv.J, Type.MOUNTAIN, Type.FOREST, Type.SPARSE);
        BiomeDictionary.registerBiomeType(aiv.K, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.registerBiomeType(aiv.L, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.registerBiomeType(aiv.M, Type.MESA, Type.SANDY);
        BiomeDictionary.registerBiomeType(aiv.N, Type.MESA, Type.SPARSE, Type.SANDY);
        BiomeDictionary.registerBiomeType(aiv.O, Type.MESA, Type.SANDY);
    }

    static /* synthetic */ ArrayList[] access$002(ArrayList[] x0) {
        typeInfoList = x0;
        return x0;
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public BiomeInfo(Type[] types) {
            for (Type t : types) {
                this.typeList.add(t);
            }
        }
    }

    public static enum Type {
        HOT(new Type[0]),
        COLD(new Type[0]),
        SPARSE(new Type[0]),
        DENSE(new Type[0]),
        WET(new Type[0]),
        DRY(new Type[0]),
        SAVANNA(new Type[0]),
        CONIFEROUS(new Type[0]),
        JUNGLE(new Type[0]),
        SPOOKY(new Type[0]),
        DEAD(new Type[0]),
        LUSH(new Type[0]),
        NETHER(new Type[0]),
        END(new Type[0]),
        MUSHROOM(new Type[0]),
        MAGICAL(new Type[0]),
        OCEAN(new Type[0]),
        RIVER(new Type[0]),
        WATER(OCEAN, RIVER),
        MESA(new Type[0]),
        FOREST(new Type[0]),
        PLAINS(new Type[0]),
        MOUNTAIN(new Type[0]),
        HILLS(new Type[0]),
        SWAMP(new Type[0]),
        SANDY(new Type[0]),
        SNOWY(new Type[0]),
        WASTELAND(new Type[0]),
        BEACH(new Type[0]);

        private List<Type> subTags;

        private Type(Type ... subTags) {
            this.subTags = Arrays.asList(subTags);
        }

        private boolean hasSubTags() {
            return this.subTags != null && !this.subTags.isEmpty();
        }

        public static Type getType(String name, Type ... subTypes) {
            name = name.toUpperCase();
            for (Type t : Type.values()) {
                if (!t.name().equals(name)) continue;
                return t;
            }
            Type ret = EnumHelper.addEnum(Type.class, name, new Class[]{Type[].class}, new Object[]{subTypes});
            if (ret.ordinal() >= typeInfoList.length) {
                BiomeDictionary.access$002(Arrays.copyOf(typeInfoList, ret.ordinal() + 1));
            }
            for (BiomeInfo bInfo : biomeInfoMap.values()) {
                if (bInfo == null) continue;
                EnumSet<Type> oldSet = bInfo.typeList;
                bInfo.typeList = EnumSet.noneOf(Type.class);
                bInfo.typeList.addAll(oldSet);
            }
            return ret;
        }
    }
}

