/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.model;

import com.mrdimka.hammercore.client.model.SimpleModel;
import com.mrdimka.hammercore.client.model.file.ModelCube;
import com.mrdimka.hammercore.client.model.file.ModelFile;
import com.mrdimka.hammercore.client.model.file.ModelPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SimpleModelLoader {
    public static ModelBase convert(String raw, boolean ignoreIssues) throws ModelLoadingException {
        if (!raw.contains("\n")) {
            raw = raw.replaceAll(";", "\n");
        }
        String[] lines = raw.split("\n");
        SimpleModel model = new SimpleModel();
        ArrayList<ModelRenderer> ended = new ArrayList<ModelRenderer>();
        HashMap<String, ModelRenderer> renderers = new HashMap<String, ModelRenderer>();
        int ln = 0;
        for (String line : lines) {
            String msg;
            ++ln;
            try {
                float[] xyz;
                ModelRenderer renderer;
                String[] args;
                String name;
                String l;
                if (line.isEmpty() || line.startsWith("//")) continue;
                if (line.startsWith("textureWidth ")) {
                    model.field_78090_t = Integer.parseInt(line.substring("textureWidth ".length()));
                }
                if (line.startsWith("textureHeight ")) {
                    model.field_78089_u = Integer.parseInt(line.substring("textureHeight ".length()));
                }
                if (line.toLowerCase().startsWith("start ")) {
                    l = line.substring("start ".length());
                    name = l.substring(0, l.indexOf("("));
                    args = l.substring(l.indexOf("(") + 1, l.lastIndexOf(")")).replaceAll(" ", "").split(",");
                    int[] data = SimpleModelLoader.parseInts(2, args);
                    ModelRenderer r = new ModelRenderer((ModelBase)model, name);
                    r.func_78787_b(data[0], data[1]);
                    renderers.put(name, r);
                }
                if (line.toLowerCase().startsWith("addBox ")) {
                    l = line.substring("addBox ".length());
                    name = l.substring(0, l.indexOf("("));
                    args = l.substring(l.indexOf("(") + 1, l.lastIndexOf(")")).replaceAll(" ", "").split(",");
                    renderer = (ModelRenderer)renderers.get(name);
                    if (renderer == null) {
                        throw new ModelLoadingExceptionMessage("There is no such model renderer named \"" + name + "\"!");
                    }
                    xyz = SimpleModelLoader.parseFloats(3, args);
                    int[] size = SimpleModelLoader.parseInts(4, Arrays.copyOfRange(args, 3, args.length));
                    renderer.func_78789_a(xyz[0], xyz[1], xyz[2], size[0], size[1], size[2]);
                }
                if (line.toLowerCase().startsWith("rotationPoint ")) {
                    l = line.substring("rotationPoint ".length());
                    name = l.substring(0, l.indexOf("("));
                    args = l.substring(l.indexOf("(") + 1, l.lastIndexOf(")")).replaceAll(" ", "").split(",");
                    renderer = (ModelRenderer)renderers.get(name);
                    if (renderer == null) {
                        throw new ModelLoadingExceptionMessage("There is no such model renderer named \"" + name + "\"!");
                    }
                    xyz = SimpleModelLoader.parseFloats(3, args);
                    renderer.func_78793_a(xyz[0], xyz[1], xyz[2]);
                }
                if (line.toLowerCase().startsWith("textureSize ")) {
                    l = line.substring("textureSize ".length());
                    name = l.substring(0, l.indexOf("("));
                    args = l.substring(l.indexOf("(") + 1, l.lastIndexOf(")")).replaceAll(" ", "").split(",");
                    renderer = (ModelRenderer)renderers.get(name);
                    if (renderer == null) {
                        throw new ModelLoadingExceptionMessage("There is no such model renderer named \"" + name + "\"!");
                    }
                    float[] xy = SimpleModelLoader.parseFloats(2, args);
                    renderer.field_78801_a = xy[0];
                    renderer.field_78799_b = xy[1];
                }
                if (line.toLowerCase().startsWith("mirror ")) {
                    l = line.substring("mirror ".length());
                    name = l.substring(0, l.indexOf("("));
                    args = l.substring(l.indexOf("(") + 1, l.lastIndexOf(")")).replaceAll(" ", "").split(",");
                    renderer = (ModelRenderer)renderers.get(name);
                    if (renderer == null) {
                        throw new ModelLoadingExceptionMessage("There is no such model renderer named \"" + name + "\"!");
                    }
                    boolean[] mirror = SimpleModelLoader.parseBooleans(1, args);
                    renderer.field_78809_i = mirror[0];
                }
                if (!line.toLowerCase().startsWith("end ")) continue;
                String shape = line.substring("end ".length());
                ModelRenderer renderer2 = (ModelRenderer)renderers.remove(shape);
                if (renderer2 == null) {
                    throw new ModelLoadingExceptionMessage("There is no such model renderer named \"" + shape + "\"!");
                }
                ended.add(renderer2);
            }
            catch (ModelLoadingExceptionMessage err) {
                msg = "Can't parse model line #" + ln + ": " + err.getMessage();
                if (ignoreIssues) {
                    System.err.println(msg);
                    continue;
                }
                throw new ModelLoadingException(msg);
            }
            catch (Throwable err) {
                msg = "Can't parse model line #" + ln + ": " + err.getClass().getName() + " > " + err.getMessage();
                if (ignoreIssues) {
                    System.err.println(msg);
                    continue;
                }
                throw new ModelLoadingException(msg);
            }
        }
        for (int i = 0; i < ended.size(); ++i) {
            ModelRenderer e = (ModelRenderer)ended.get(i);
            if (e.field_78801_a == 0.0f || e.field_78799_b == 0.0f) {
                e.field_78801_a = model.field_78090_t;
                e.field_78799_b = model.field_78089_u;
            }
            model.field_78092_r.add(e);
        }
        return model;
    }

    public static SimpleModel convert(ModelFile file) {
        SimpleModel model = new SimpleModel();
        model.field_78090_t = file.textureWidth;
        model.field_78089_u = file.textureHeight;
        for (ModelPart part : file.parts) {
            model.field_78092_r.add(SimpleModelLoader.toRenderer(model, part));
        }
        return model;
    }

    private static ModelRenderer toRenderer(ModelBase parent, ModelPart part) {
        ModelRenderer r = new ModelRenderer(parent, part.name).func_78784_a(part.textureOffsetX, part.textureOffsetY);
        r.field_82906_o = part.offsetX;
        r.field_82908_p = part.offsetY;
        r.field_82907_q = part.offsetZ;
        r.field_78795_f = part.rotateAngleX;
        r.field_78796_g = part.rotateAngleY;
        r.field_78808_h = part.rotateAngleZ;
        r.field_78809_i = part.mirror;
        for (ModelCube cube : part.boxes) {
            r.func_78786_a(cube.boxName, cube.posX1, cube.posY1, cube.posZ1, (int)(cube.posX2 - cube.posX1), (int)(cube.posY2 - cube.posY1), (int)(cube.posZ2 - cube.posZ1));
        }
        for (ModelPart child : part.childs) {
            r.field_78805_m.add(SimpleModelLoader.toRenderer(parent, child));
        }
        return r;
    }

    private static ModelPart toPart(ModelRenderer part) {
        ModelPart r = new ModelPart();
        r.boxes = new HashSet<ModelCube>();
        r.childs = new HashSet<ModelPart>();
        r.name = part.field_78802_n;
        r.offsetX = part.field_82906_o;
        r.offsetY = part.field_82908_p;
        r.offsetZ = part.field_82907_q;
        r.rotateAngleX = part.field_78795_f;
        r.rotateAngleY = part.field_78796_g;
        r.rotateAngleZ = part.field_78808_h;
        r.mirror = part.field_78809_i;
        for (ModelBox box : part.field_78804_l) {
            ModelCube cube = new ModelCube();
            cube.boxName = box.field_78247_g;
            cube.posX1 = box.field_78252_a;
            cube.posY1 = box.field_78250_b;
            cube.posZ1 = box.field_78251_c;
            cube.posX2 = box.field_78248_d;
            cube.posY2 = box.field_78249_e;
            cube.posZ2 = box.field_78246_f;
            r.boxes.add(cube);
        }
        for (ModelRenderer child : part.field_78805_m) {
            r.childs.add(SimpleModelLoader.toPart(child));
        }
        return r;
    }

    private static boolean[] parseBooleans(int needed, String ... strings) {
        boolean[] booleans = new boolean[needed];
        for (int i = 0; i < Math.min(needed, strings.length); ++i) {
            try {
                booleans[i] = Boolean.parseBoolean(strings[i]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return booleans;
    }

    private static float[] parseFloats(int needed, String ... strings) {
        float[] floats = new float[needed];
        for (int i = 0; i < Math.min(needed, strings.length); ++i) {
            try {
                floats[i] = Float.parseFloat(strings[i]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return floats;
    }

    private static int[] parseInts(int needed, String ... strings) {
        int[] ints = new int[needed];
        for (int i = 0; i < Math.min(needed, strings.length); ++i) {
            try {
                ints[i] = Integer.parseInt(strings[i]);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ints;
    }

    public static String convert(ModelBase model) {
        StringBuilder sb = new StringBuilder();
        sb.append("textureWidth " + model.field_78090_t + ";");
        sb.append('\n');
        sb.append("textureHeight " + model.field_78089_u + ";");
        sb.append('\n');
        sb.append('\n');
        for (int i = 0; i < model.field_78092_r.size(); ++i) {
            ModelRenderer r = (ModelRenderer)model.field_78092_r.get(i);
            sb.append("//Model part \"" + r.field_78802_n + "\"");
            sb.append("start " + r.field_78802_n + "(" + (int)r.field_78801_a + ", " + (int)r.field_78799_b + ");");
            sb.append('\n');
            for (int bi = 0; bi < r.field_78804_l.size(); ++bi) {
                ModelBox box = (ModelBox)r.field_78804_l.get(bi);
                sb.append("addBox " + r.field_78802_n + "(" + box.field_78252_a + ", " + box.field_78250_b + ", " + box.field_78251_c + ", " + (int)(box.field_78248_d - box.field_78252_a) + ", " + (int)(box.field_78249_e - box.field_78250_b) + ", " + (int)(box.field_78246_f - box.field_78251_c) + ");");
                sb.append('\n');
            }
            sb.append("rotationPoint " + r.field_78802_n + "(" + r.field_78800_c + ", " + r.field_78797_d + ", " + r.field_78798_e + ");");
            sb.append('\n');
            sb.append("textureSize " + r.field_78802_n + "(" + r.field_78801_a + ", " + r.field_78799_b + ");");
            sb.append('\n');
            sb.append("mirror " + r.field_78802_n + "(" + r.field_78809_i + ");");
            sb.append('\n');
            sb.append("end " + r.field_78802_n + ";");
            if (i >= model.field_78092_r.size() - 1) continue;
            sb.append('\n');
            sb.append('\n');
        }
        return sb.toString();
    }

    public static ModelFile convertToFile(ModelBase model) {
        ModelFile file = new ModelFile();
        file.parts = new HashSet<ModelPart>();
        file.textureWidth = model.field_78090_t;
        file.textureHeight = model.field_78089_u;
        for (int i = 0; i < model.field_78092_r.size(); ++i) {
            file.parts.add(SimpleModelLoader.toPart((ModelRenderer)model.field_78092_r.get(i)));
        }
        return file;
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public static class ModelLoadingExceptionMessage
    extends Exception {
        public ModelLoadingExceptionMessage(String reason) {
            super(reason);
        }
    }

    public static class ModelLoadingException
    extends Exception {
        public ModelLoadingException(String reason) {
            super(reason);
        }
    }
}

