/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheMiscBlocks;
import de.ellpeck.actuallyadditions.mod.tile.ICustomEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityLavaFactoryController
extends TileEntityBase
implements ICustomEnergyReceiver,
IEnergyDisplay {
    public static final int NOT_MULTI = 0;
    public static final int HAS_LAVA = 1;
    public static final int HAS_AIR = 2;
    public static final int ENERGY_USE = 150000;
    public final EnergyStorage storage = new EnergyStorage(3000000);
    private int currentWorkTime;
    private int oldEnergy;

    public TileEntityLavaFactoryController() {
        super("lavaFactory");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("WorkTime", this.currentWorkTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentWorkTime = compound.func_74762_e("WorkTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.storage.getEnergyStored() >= 150000 && this.isMultiblock() == 2) {
                ++this.currentWorkTime;
                if (this.currentWorkTime >= 200) {
                    this.currentWorkTime = 0;
                    this.field_145850_b.func_180501_a(this.field_174879_c.func_177984_a(), Blocks.field_150353_l.func_176223_P(), 2);
                    this.storage.extractEnergy(150000, false);
                }
            } else {
                this.currentWorkTime = 0;
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    public int isMultiblock() {
        BlockPos thisPos = this.field_174879_c;
        BlockPos[] positions = new BlockPos[]{thisPos.func_177982_a(1, 1, 0), thisPos.func_177982_a(-1, 1, 0), thisPos.func_177982_a(0, 1, 1), thisPos.func_177982_a(0, 1, -1)};
        if (WorldUtil.hasBlocksInPlacesGiven(positions, InitBlocks.blockMisc, TheMiscBlocks.LAVA_FACTORY_CASE.ordinal(), this.field_145850_b)) {
            BlockPos pos = thisPos.func_177984_a();
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                return 1;
            }
            if (block == null || this.field_145850_b.func_175623_d(pos)) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return from != EnumFacing.UP ? this.storage.receiveEnergy(maxExtract, simulate) : 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return from != EnumFacing.UP ? this.storage.getEnergyStored() : 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return from != EnumFacing.UP ? this.storage.getMaxEnergyStored() : 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from != EnumFacing.UP;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }
}

