/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.tile.ICustomEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLaserRelayEnergy
extends TileEntityLaserRelay
implements ICustomEnergyReceiver {
    public static final int CAP = 1000;
    public final ConcurrentHashMap<EnumFacing, TileEntity> receiversAround = new ConcurrentHashMap();
    private Mode mode = Mode.BOTH;

    public TileEntityLaserRelayEnergy(String name) {
        super(name, LaserType.ENERGY);
    }

    public TileEntityLaserRelayEnergy() {
        this("laserRelay");
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.transmitEnergy(from, maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.getEnergyCap();
    }

    private int transmitEnergy(EnumFacing from, int maxTransmit, boolean simulate) {
        Network network;
        int transmitted = 0;
        if (maxTransmit > 0 && this.mode != Mode.OUTPUT_ONLY && (network = this.getNetwork()) != null) {
            transmitted = this.transferEnergyToReceiverInNeed(from, network, maxTransmit, simulate);
        }
        return transmitted;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<EnumFacing, TileEntity> old = new HashMap<EnumFacing, TileEntity>(this.receiversAround);
        boolean change = false;
        this.receiversAround.clear();
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity tile;
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            if (!this.field_145850_b.func_175667_e(pos) || (tile = this.field_145850_b.func_175625_s(pos)) == null || tile instanceof TileEntityLaserRelay || !(tile instanceof IEnergyReceiver) && (!ActuallyAdditions.teslaLoaded || !tile.hasCapability(TeslaUtil.teslaConsumer, side.func_176734_d()))) continue;
            this.receiversAround.put(side, tile);
            TileEntity oldTile = (TileEntity)old.get(side);
            if (oldTile != null && tile.equals(oldTile)) continue;
            change = true;
        }
        if ((change || old.size() != this.receiversAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    private int transferEnergyToReceiverInNeed(EnumFacing from, Network network, int maxTransfer, boolean simulate) {
        int transmitted = 0;
        ArrayList<BlockPos> alreadyChecked = new ArrayList<BlockPos>();
        ArrayList<TileEntityLaserRelayEnergy> relaysThatWork = new ArrayList<TileEntityLaserRelayEnergy>();
        int totalReceiverAmount = 0;
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.field_145850_b.func_175667_e(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                TileEntity relayTile = this.field_145850_b.func_175625_s(relay);
                if (!(relayTile instanceof TileEntityLaserRelayEnergy)) continue;
                TileEntityLaserRelayEnergy theRelay = (TileEntityLaserRelayEnergy)relayTile;
                if (theRelay.mode == Mode.INPUT_ONLY) continue;
                boolean workedOnce = false;
                for (EnumFacing facing : theRelay.receiversAround.keySet()) {
                    ITeslaConsumer cap;
                    if (theRelay == this && facing == from) continue;
                    TileEntity tile = theRelay.receiversAround.get(facing);
                    EnumFacing opp = facing.func_176734_d();
                    if (tile instanceof IEnergyReceiver) {
                        IEnergyReceiver iReceiver = (IEnergyReceiver)tile;
                        if (!iReceiver.canConnectEnergy(opp) || iReceiver.receiveEnergy(opp, Integer.MAX_VALUE, true) <= 0) continue;
                        ++totalReceiverAmount;
                        workedOnce = true;
                        continue;
                    }
                    if (!ActuallyAdditions.teslaLoaded || !tile.hasCapability(TeslaUtil.teslaConsumer, opp) || (cap = (ITeslaConsumer)tile.getCapability(TeslaUtil.teslaConsumer, opp)) == null || cap.givePower((long)maxTransfer, true) <= 0L) continue;
                    ++totalReceiverAmount;
                    workedOnce = true;
                }
                if (!workedOnce) continue;
                relaysThatWork.add(theRelay);
            }
        }
        if (totalReceiverAmount > 0 && !relaysThatWork.isEmpty()) {
            int amountPer = maxTransfer / totalReceiverAmount;
            if (amountPer <= 0) {
                amountPer = maxTransfer;
            }
            for (TileEntityLaserRelayEnergy theRelay : relaysThatWork) {
                double highestLoss = Math.max(theRelay.getLossPercentage(), this.getLossPercentage());
                int lowestCap = Math.min(theRelay.getEnergyCap(), this.getEnergyCap());
                for (Map.Entry<EnumFacing, TileEntity> receiver : theRelay.receiversAround.entrySet()) {
                    ITeslaConsumer cap;
                    int deduct;
                    int theoreticalReceived;
                    if (receiver == null) continue;
                    EnumFacing side = receiver.getKey();
                    EnumFacing opp = side.func_176734_d();
                    TileEntity tile = receiver.getValue();
                    if (alreadyChecked.contains(tile.func_174877_v())) continue;
                    alreadyChecked.add(tile.func_174877_v());
                    if (theRelay == this && side == from) continue;
                    if (tile instanceof IEnergyReceiver) {
                        IEnergyReceiver iReceiver = (IEnergyReceiver)tile;
                        if (iReceiver.canConnectEnergy(opp) && (theoreticalReceived = iReceiver.receiveEnergy(opp, Math.min(amountPer, lowestCap), true)) > 0) {
                            deduct = this.calcDeduction(theoreticalReceived, highestLoss);
                            if (deduct >= theoreticalReceived) {
                                deduct = 0;
                            }
                            transmitted += iReceiver.receiveEnergy(opp, theoreticalReceived - deduct, simulate);
                            transmitted += deduct;
                        }
                    } else if (ActuallyAdditions.teslaLoaded && tile.hasCapability(TeslaUtil.teslaConsumer, opp) && (cap = (ITeslaConsumer)tile.getCapability(TeslaUtil.teslaConsumer, opp)) != null && (theoreticalReceived = (int)cap.givePower((long)Math.min(amountPer, lowestCap), true)) > 0) {
                        deduct = this.calcDeduction(theoreticalReceived, highestLoss);
                        if (deduct >= theoreticalReceived) {
                            deduct = 0;
                        }
                        transmitted = (int)((long)transmitted + cap.givePower((long)(theoreticalReceived - deduct), simulate));
                        transmitted += deduct;
                    }
                    if (transmitted < maxTransfer) continue;
                    return transmitted;
                }
            }
        }
        return transmitted;
    }

    private int calcDeduction(int theoreticalReceived, double highestLoss) {
        return ConfigBoolValues.LASER_RELAY_LOSS.isEnabled() ? MathHelper.func_76143_f((double)((double)theoreticalReceived * (highestLoss / 100.0))) : 0;
    }

    public int getEnergyCap() {
        return 1000;
    }

    public double getLossPercentage() {
        return 5.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getExtraDisplayString() {
        return "Energy Flow: " + TextFormatting.DARK_RED + this.mode.name + TextFormatting.RESET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCompassDisplayString() {
        return TextFormatting.GREEN + "Right-Click to change!";
    }

    @Override
    public void onCompassAction(EntityPlayer player) {
        this.mode = this.mode.getNext();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74778_a("Mode", this.mode.toString());
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        String modeStrg;
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK && (modeStrg = compound.func_74779_i("Mode")) != null && !modeStrg.isEmpty()) {
            this.mode = Mode.valueOf(modeStrg);
        }
    }

    public static enum Mode {
        BOTH("Both Directions"),
        OUTPUT_ONLY("Only into adjacent Blocks"),
        INPUT_ONLY("Only out of adjacent Blocks");

        public final String name;

        private Mode(String name) {
            this.name = name;
        }

        public Mode getNext() {
            int ordinal = this.ordinal() + 1;
            if (ordinal >= Mode.values().length) {
                ordinal = 0;
            }
            return Mode.values()[ordinal];
        }
    }
}

