/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.ILensItem;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.mod.misc.SoundHandler;
import de.ellpeck.actuallyadditions.mod.tile.ICustomEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityAtomicReconstructor
extends TileEntityInventoryBase
implements ICustomEnergyReceiver,
IEnergyDisplay,
IAtomicReconstructor {
    public static final int ENERGY_USE = 1000;
    public final EnergyStorage storage = new EnergyStorage(300000);
    public int counter;
    private int currentTime;
    private int oldEnergy;

    public TileEntityAtomicReconstructor() {
        super(1, "reconstructor");
    }

    public static void shootLaser(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, Lens currentLens) {
        world.func_184148_a(null, startX, startY, startZ, SoundHandler.reconstructor, SoundCategory.BLOCKS, 0.35f, 1.0f);
        AssetUtil.spawnLaserWithTimeServer(world, startX, startY, startZ, endX, endY, endZ, currentLens.getColor(), 25, 0.0, 0.2f, 0.8f);
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CurrentTime", this.currentTime);
            compound.func_74768_a("Counter", this.counter);
        }
        this.storage.writeToNBT(compound);
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    @Override
    public EnumFacing getOrientation() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return WorldUtil.getDirectionByPistonRotation(state.func_177230_c().func_176201_c(state));
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.func_74762_e("CurrentTime");
            this.counter = compound.func_74762_e("Counter");
        }
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.isPulseMode) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                    if (this.currentTime <= 0) {
                        this.doWork();
                    }
                } else {
                    this.currentTime = 100;
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 1000) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            EnumFacing sideToManipulate = WorldUtil.getDirectionByPistonRotation(state.func_177230_c().func_176201_c(state));
            Lens currentLens = this.getLens();
            if (currentLens.canInvoke(this, sideToManipulate, 1000)) {
                this.storage.extractEnergy(1000, false);
                int distance = currentLens.getDistance();
                for (int i = 0; i < distance; ++i) {
                    BlockPos hitBlock = this.field_174879_c.func_177967_a(sideToManipulate, i + 1);
                    if (!currentLens.invoke(this.field_145850_b.func_180495_p(hitBlock), hitBlock, this) && i < distance - 1) continue;
                    TileEntityAtomicReconstructor.shootLaser(this.field_145850_b, this.getX(), this.getY(), this.getZ(), hitBlock.func_177958_n(), hitBlock.func_177956_o(), hitBlock.func_177952_p(), currentLens);
                    break;
                }
            }
        }
    }

    @Override
    public Lens getLens() {
        if (StackUtil.isValid(this.slots[0]) && this.slots[0].func_77973_b() instanceof ILensItem) {
            return ((ILensItem)this.slots[0].func_77973_b()).getLens();
        }
        return this.counter >= 500 ? ActuallyAdditionsAPI.lensDisruption : ActuallyAdditionsAPI.lensDefaultConversion;
    }

    @Override
    public int getX() {
        return this.func_174877_v().func_177958_n();
    }

    @Override
    public int getY() {
        return this.func_174877_v().func_177956_o();
    }

    @Override
    public int getZ() {
        return this.func_174877_v().func_177952_p();
    }

    @Override
    public World getWorldObject() {
        return this.func_145831_w();
    }

    @Override
    public void extractEnergy(int amount) {
        this.storage.extractEnergy(amount, false);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return StackUtil.isValid(stack) && stack.func_77973_b() instanceof ILensItem;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sendUpdate();
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }
}

