/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.base;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class BlockPlant
extends BlockCrops
implements ItemBlockBase.ICustomRarity {
    private final String name;
    private final int minDropAmount;
    private final int addDropAmount;
    public Item seedItem;
    private Item returnItem;
    private int returnMeta;

    public BlockPlant(String name, int minDropAmount, int addDropAmount) {
        this.name = name;
        this.minDropAmount = minDropAmount;
        this.addDropAmount = addDropAmount;
        this.register();
    }

    public void doStuff(Item seedItem, Item returnItem, int returnMeta) {
        this.seedItem = seedItem;
        this.returnItem = returnItem;
        this.returnMeta = returnMeta;
    }

    private void register() {
        ItemUtil.registerBlock((Block)this, this.getItemBlock(), this.getBaseName(), this.shouldAddCreative());
        this.registerRendering();
    }

    protected String getBaseName() {
        return this.name;
    }

    protected ItemBlockBase getItemBlock() {
        return new ItemBlockBase((Block)this);
    }

    public boolean shouldAddCreative() {
        return false;
    }

    protected void registerRendering() {
        ActuallyAdditions.proxy.addRenderRegister(new ItemStack((Block)this), this.getRegistryName(), "inventory");
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) >= 7 ? this.returnMeta : 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.func_176201_c(state) >= 7) {
            if (!world.field_72995_K) {
                List drops = this.getDrops((IBlockAccess)world, pos, state, 0);
                boolean deductedSeedSize = false;
                for (ItemStack drop : drops) {
                    if (!StackUtil.isValid(drop)) continue;
                    if (drop.func_77973_b() == this.seedItem && !deductedSeedSize) {
                        StackUtil.addStackSize(drop, -1);
                        deductedSeedSize = true;
                    }
                    if (!StackUtil.isValid(drop)) continue;
                    EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
                    world.func_72838_d((Entity)entity);
                }
                world.func_175656_a(pos, this.func_176203_a(0));
            }
            return true;
        }
        return false;
    }

    public Item func_149866_i() {
        return this.seedItem;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.func_176201_c(state) >= 7 ? random.nextInt(this.addDropAmount) + this.minDropAmount : super.quantityDropped(state, fortune, random);
    }

    public Item func_149865_P() {
        return this.returnItem;
    }

    public Item func_180660_a(IBlockState state, Random rand, int par3) {
        return this.func_176201_c(state) >= 7 ? this.func_149865_P() : this.func_149866_i();
    }
}

