/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.BlockSlabs;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDisplayStand
extends BlockContainerBase {
    public BlockDisplayStand(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDisplayStand();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BlockSlabs.AABB_BOTTOM_HALF;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            TileEntityDisplayStand stand = (TileEntityDisplayStand)world.func_175625_s(pos);
            if (stand != null) {
                ItemStack display = stand.func_70301_a(0);
                if (StackUtil.isValid(heldItem)) {
                    int maxTransfer;
                    if (!StackUtil.isValid(display)) {
                        ItemStack toPut = heldItem.func_77946_l();
                        toPut = StackUtil.setStackSize(toPut, 1);
                        stand.func_70299_a(0, toPut);
                        player.func_184611_a(hand, StackUtil.addStackSize(heldItem, -1));
                        return true;
                    }
                    if (ItemUtil.canBeStacked(heldItem, display) && (maxTransfer = Math.min(StackUtil.getStackSize(display), heldItem.func_77976_d() - StackUtil.getStackSize(heldItem))) > 0) {
                        player.func_184611_a(hand, StackUtil.addStackSize(heldItem, maxTransfer));
                        ItemStack newDisplay = display.func_77946_l();
                        newDisplay = StackUtil.addStackSize(newDisplay, -maxTransfer);
                        stand.func_70299_a(0, StackUtil.validateCheck(newDisplay));
                        return true;
                    }
                } else if (StackUtil.isValid(display)) {
                    player.func_184611_a(hand, display.func_77946_l());
                    stand.func_70299_a(0, StackUtil.getNull());
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.dropInventory(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

