/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.gui.ButtonLM;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLM;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.PanelLM;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiConfigs;
import com.feed_the_beast.ftbl.lib.gui.misc.ThreadReloadChunkSelector;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import com.feed_the_beast.ftbu.FTBUCommon;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.api.chunks.IChunkUpgrade;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrade;
import com.feed_the_beast.ftbu.client.FTBUClient;
import com.feed_the_beast.ftbu.gui.ClaimedChunks;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksModify;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GuiClaimedChunks
extends GuiLM {
    public static GuiClaimedChunks instance;
    private static final Map<UUID, ClaimedChunks.Team> TEAMS;
    private static final ClaimedChunks.Data[] chunkData;
    private static int claimedChunks;
    private static int loadedChunks;
    private static int maxClaimedChunks;
    private static int maxLoadedChunks;
    public final int startX;
    public final int startZ;
    private final ButtonLM buttonRefresh;
    private final ButtonLM buttonClose;
    private final ButtonLM buttonUnclaimAll;
    private final MapButton[] mapButtons;
    private final PanelLM panelButtons;
    private String currentDimName;
    private byte currentSelectionMode = (byte)-1;

    public static void setData(int startX, int startZ, int cc, int lc, int mcc, int mlc, ClaimedChunks.Data[] data, Map<UUID, ClaimedChunks.Team> tms) {
        claimedChunks = cc;
        loadedChunks = lc;
        maxClaimedChunks = mcc;
        maxLoadedChunks = mlc;
        System.arraycopy(data, 0, chunkData, 0, chunkData.length);
        TEAMS.putAll(tms);
        if (FTBUClient.JM_INTEGRATION != null) {
            for (int z = 0; z < 15; ++z) {
                for (int x = 0; x < 15; ++x) {
                    FTBUClient.JM_INTEGRATION.chunkChanged(new ChunkPos(startX + x, startZ + z), data[x + z * 15]);
                }
            }
        }
    }

    public GuiClaimedChunks() {
        super(240, 240);
        this.startX = MathHelperLM.chunk((double)this.mc.field_71439_g.field_70165_t) - 7;
        this.startZ = MathHelperLM.chunk((double)this.mc.field_71439_g.field_70161_v) - 7;
        this.currentDimName = this.mc.field_71441_e.field_73011_w.func_186058_p().func_186065_b();
        this.buttonClose = new ButtonLM(0, 0, 16, 16, GuiLang.BUTTON_CLOSE.translate(new Object[0])){

            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                gui.closeGui();
            }
        };
        this.buttonClose.setIcon((IDrawableObject)GuiIcons.ACCEPT);
        this.buttonRefresh = new ButtonLM(0, 16, 16, 16, GuiLang.BUTTON_REFRESH.translate(new Object[0])){

            public void onClicked(IGui gui, IMouseButton button) {
                new MessageClaimedChunksRequest(GuiClaimedChunks.this.startX, GuiClaimedChunks.this.startZ).sendToServer();
                ThreadReloadChunkSelector.reloadArea((World)GuiClaimedChunks.this.mc.field_71441_e, (int)GuiClaimedChunks.this.startX, (int)GuiClaimedChunks.this.startZ);
            }
        };
        this.buttonRefresh.setIcon((IDrawableObject)GuiIcons.REFRESH);
        this.buttonUnclaimAll = new ButtonLM(0, 32, 16, 16){

            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                String s = GuiScreen.func_146272_n() ? FTBULang.BUTTON_CLAIMS_UNCLAIM_ALL_Q.translate(new Object[0]) : FTBULang.BUTTON_CLAIMS_UNCLAIM_ALL_DIM_Q.translate(new Object[]{GuiClaimedChunks.this.currentDimName});
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo((set, id) -> {
                    if (set) {
                        FTBLibClient.execClientCommand((String)("/ftb chunks unclaim_all " + (id == 1)));
                    }
                    gui.openGui();
                    gui.refreshWidgets();
                }, s, "", GuiScreen.func_146272_n() ? 1 : 0));
            }

            public void addMouseOverText(IGui gui, List<String> list) {
                list.add(GuiScreen.func_146272_n() ? FTBULang.BUTTON_CLAIMS_UNCLAIM_ALL.translate(new Object[0]) : FTBULang.BUTTON_CLAIMS_UNCLAIM_ALL_DIM.translate(new Object[]{GuiClaimedChunks.this.currentDimName}));
            }
        };
        this.buttonUnclaimAll.setIcon((IDrawableObject)GuiIcons.REMOVE);
        this.panelButtons = new PanelLM(0, 0, 16, 0){

            public void addWidgets() {
                this.add((IWidget)GuiClaimedChunks.this.buttonClose);
                this.add((IWidget)GuiClaimedChunks.this.buttonRefresh);
                this.add((IWidget)GuiClaimedChunks.this.buttonUnclaimAll);
                this.setHeight(this.getWidgets().size() * 16);
            }

            public int getAX() {
                return GuiClaimedChunks.this.getScreen().func_78326_a() - 16;
            }

            public int getAY() {
                return 0;
            }
        };
        this.mapButtons = new MapButton[225];
        for (int i = 0; i < this.mapButtons.length; ++i) {
            this.mapButtons[i] = new MapButton(0, 0, i);
        }
    }

    public void onInit() {
        this.buttonRefresh.onClicked((IGui)this, (IMouseButton)MouseButton.LEFT);
    }

    public void addWidgets() {
        for (MapButton b : this.mapButtons) {
            this.add((IWidget)b);
        }
        this.add((IWidget)this.panelButtons);
    }

    public void drawBackground() {
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GuiHelper.drawBlankRect((int)(this.posX - 2), (int)(this.posY - 2), (int)(this.getWidth() + 4), (int)(this.getHeight() + 4));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ThreadReloadChunkSelector.updateTexture();
        GlStateManager.func_179144_i((int)ThreadReloadChunkSelector.getTextureID());
        GuiHelper.drawTexturedRect((int)this.posX, (int)this.posY, (int)240, (int)240, (double)0.0, (double)0.0, (double)0.9375, (double)0.9375);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        this.mc.func_110434_K().func_110577_a(GuiConfigs.TEX_CHUNK_CLAIMING);
        for (MapButton mapButton : this.mapButtons) {
            mapButton.renderWidget((IGui)this);
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int gridR = 128;
        int gridG = 128;
        int gridB = 128;
        int gridA = 50;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int gridX = this.mapButtons[0].getAX();
        int gridY = this.mapButtons[0].getAY();
        for (int x = 0; x <= 15; ++x) {
            buffer.func_181662_b((double)(gridX + x * 16), (double)gridY, 0.0).func_181669_b(gridR, gridG, gridB, gridA).func_181675_d();
            buffer.func_181662_b((double)(gridX + x * 16), (double)(gridY + 240), 0.0).func_181669_b(gridR, gridG, gridB, gridA).func_181675_d();
        }
        for (int y = 0; y <= 15; ++y) {
            buffer.func_181662_b((double)gridX, (double)(gridY + y * 16), 0.0).func_181669_b(gridR, gridG, gridB, gridA).func_181675_d();
            buffer.func_181662_b((double)(gridX + 240), (double)(gridY + y * 16), 0.0).func_181669_b(gridR, gridG, gridB, gridA).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        int cx = MathHelperLM.chunk((double)this.mc.field_71439_g.field_70165_t);
        int cy = MathHelperLM.chunk((double)this.mc.field_71439_g.field_70161_v);
        if (cx >= this.startX && cy >= this.startZ && cx < this.startX + 15 && cy < this.startZ + 15) {
            double x = (double)(cx - this.startX) * 16.0 + MathHelperLM.wrap((double)this.mc.field_71439_g.field_70165_t, (double)16.0);
            double y = (double)(cy - this.startZ) * 16.0 + MathHelperLM.wrap((double)this.mc.field_71439_g.field_70161_v, (double)16.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)this.posX + x), (double)((double)this.posY + y), (double)0.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(this.mc.field_71439_g.field_70177_z + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(GuiConfigs.TEX_ENTITY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.mc.field_71439_g.func_70093_af() ? 0.4f : 0.7f));
            GuiHelper.drawTexturedRect((int)-8, (int)-8, (int)16, (int)16, (double)0.0, (double)0.0, (double)1.0, (double)1.0);
            GlStateManager.func_179121_F();
            FTBLibClient.localPlayerHead.draw(-2, -2, 4, 4);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void mouseReleased(IGui gui) {
        super.mouseReleased(gui);
        if (this.currentSelectionMode != -1) {
            ArrayList<ChunkPos> c = new ArrayList<ChunkPos>();
            for (MapButton b : this.mapButtons) {
                if (!b.isSelected) continue;
                c.add(b.chunkPos);
                b.isSelected = false;
            }
            new MessageClaimedChunksModify(this.startX, this.startZ, this.currentSelectionMode, c).sendToServer();
            this.currentSelectionMode = (byte)-1;
        }
    }

    public void drawForeground() {
        String s = FTBULang.LABEL_CCHUNKS_COUNT.translate(new Object[]{claimedChunks, maxClaimedChunks});
        this.getFont().func_175063_a(s, (float)(this.getScreen().func_78326_a() - this.getFont().func_78256_a(s) - 4), (float)(this.getScreen().func_78328_b() - 24), -1);
        s = FTBULang.LABEL_LCHUNKS_COUNT.translate(new Object[]{loadedChunks, maxLoadedChunks});
        this.getFont().func_175063_a(s, (float)(this.getScreen().func_78326_a() - this.getFont().func_78256_a(s) - 4), (float)(this.getScreen().func_78328_b() - 12), -1);
        super.drawForeground();
    }

    static {
        TEAMS = new HashMap<UUID, ClaimedChunks.Team>();
        chunkData = new ClaimedChunks.Data[225];
        for (int i = 0; i < chunkData.length; ++i) {
            GuiClaimedChunks.chunkData[i] = new ClaimedChunks.Data();
        }
    }

    private class MapButton
    extends ButtonLM {
        private final ChunkPos chunkPos;
        private final int index;
        private boolean isSelected;

        private MapButton(int x, int y, int i) {
            super(x, y, 16, 16);
            this.isSelected = false;
            this.posX += i % 15 * this.getWidth();
            this.posY += i / 15 * this.getHeight();
            this.chunkPos = new ChunkPos(GuiClaimedChunks.this.startX + i % 15, GuiClaimedChunks.this.startZ + i / 15);
            this.index = i;
        }

        public void onClicked(IGui gui, IMouseButton button) {
            GuiHelper.playClickSound();
            boolean claim = !GuiScreen.func_146272_n();
            boolean flag = button.isLeft();
            if (flag) {
                GuiClaimedChunks.this.currentSelectionMode = claim ? (byte)0 : 2;
            } else {
                GuiClaimedChunks.this.currentSelectionMode = claim ? (byte)1 : 3;
            }
        }

        public void addMouseOverText(IGui gui, List<String> list) {
            if (chunkData[this.index].hasUpgrade(ChunkUpgrade.CLAIMED)) {
                list.add(chunkData[this.index].team.formattedName);
                list.add(TextFormatting.GREEN + ChunkUpgrade.CLAIMED.getLangKey().translate(new Object[0]));
                if (chunkData[this.index].team.isAlly) {
                    list.add(chunkData[this.index].owner);
                    for (IChunkUpgrade upgrade : FTBUCommon.CHUNK_UPGRADES) {
                        if (upgrade == null || !chunkData[this.index].hasUpgrade(upgrade)) continue;
                        list.add(TextFormatting.RED + upgrade.getLangKey().translate(new Object[0]));
                    }
                }
            } else {
                list.add(TextFormatting.DARK_GREEN + ChunkUpgrade.WILDERNESS.getLangKey().translate(new Object[0]));
            }
            if (GuiScreen.func_146271_m()) {
                list.add(this.chunkPos.toString());
            }
        }

        public void renderWidget(IGui gui) {
            int ax = this.getAX();
            int ay = this.getAY();
            if (chunkData[this.index].hasUpgrade(ChunkUpgrade.CLAIMED)) {
                GuiClaimedChunks.this.mc.func_110434_K().func_110577_a(GuiConfigs.TEX_CHUNK_CLAIMING);
                LMColorUtils.GL_COLOR.set(chunkData[this.index].team.color.getColor(), GuiScreen.func_146271_m() ? 50 : 180);
                GuiHelper.drawTexturedRect((int)ax, (int)ay, (int)16, (int)16, (double)GuiConfigs.TEX_FILLED.getMinU(), (double)GuiConfigs.TEX_FILLED.getMinV(), (double)GuiConfigs.TEX_FILLED.getMaxU(), (double)GuiConfigs.TEX_FILLED.getMaxV());
                GlStateManager.func_179131_c((float)(chunkData[this.index].hasUpgrade(ChunkUpgrade.LOADED) && chunkData[this.index].team.isAlly ? 1.0f : 0.0f), (float)(chunkData[this.index].hasUpgrade(ChunkUpgrade.IS_OWNER) ? 0.27f : 0.0f), (float)0.0f, (float)(GuiScreen.func_146271_m() ? 0.2f : 0.78f));
                GuiHelper.drawTexturedRect((int)ax, (int)ay, (int)16, (int)16, (double)GuiConfigs.TEX_BORDER.getMinU(), (double)GuiConfigs.TEX_BORDER.getMinV(), (double)GuiConfigs.TEX_BORDER.getMaxU(), (double)GuiConfigs.TEX_BORDER.getMaxV());
            }
            if (this.isSelected || gui.isMouseOver((IWidget)this)) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.27f);
                GuiHelper.drawBlankRect((int)ax, (int)ay, (int)16, (int)16);
            }
            if (!this.isSelected && GuiClaimedChunks.this.currentSelectionMode != -1 && GuiClaimedChunks.this.isMouseOver((IWidget)this)) {
                this.isSelected = true;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

