/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import appeng.util.item.MeaningfulItemIterator;
import appeng.util.item.OreReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public final class ItemList
implements IItemList<IAEItemStack> {
    private final NavigableMap<IAEItemStack, IAEItemStack> records = new ConcurrentSkipListMap<IAEItemStack, IAEItemStack>();

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = (IAEItemStack)this.records.get(option);
        if (st != null) {
            st.add(option);
            return;
        }
        IAEItemStack opt = option.copy();
        this.putItemRecord(opt);
    }

    @Override
    public IAEItemStack findPrecise(IAEItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return (IAEItemStack)this.records.get(itemStack);
    }

    @Override
    public Collection<IAEItemStack> findFuzzy(IAEItemStack filter, FuzzyMode fuzzy) {
        if (filter == null) {
            return Collections.emptyList();
        }
        AEItemStack ais = (AEItemStack)filter;
        if (ais.isOre()) {
            OreReference or = ais.getDefinition().getIsOre();
            if (or.getAEEquivalents().size() == 1) {
                IAEItemStack is = or.getAEEquivalents().get(0);
                return this.findFuzzyDamage((AEItemStack)is, fuzzy, is.getItemDamage() == Short.MAX_VALUE);
            }
            LinkedList<IAEItemStack> output = new LinkedList<IAEItemStack>();
            for (IAEItemStack is : or.getAEEquivalents()) {
                output.addAll(this.findFuzzyDamage((AEItemStack)is, fuzzy, is.getItemDamage() == Short.MAX_VALUE));
            }
            return output;
        }
        return this.findFuzzyDamage(ais, fuzzy, false);
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public void addStorage(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = (IAEItemStack)this.records.get(option);
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        IAEItemStack opt = option.copy();
        this.putItemRecord(opt);
    }

    @Override
    public void addCrafting(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = (IAEItemStack)this.records.get(option);
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        IAEItemStack opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(true);
        this.putItemRecord(opt);
    }

    @Override
    public void addRequestable(IAEItemStack option) {
        if (option == null) {
            return;
        }
        IAEItemStack st = (IAEItemStack)this.records.get(option);
        if (st != null) {
            st.setCountRequestable(st.getCountRequestable() + option.getCountRequestable());
            return;
        }
        IAEItemStack opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(false);
        opt.setCountRequestable(option.getCountRequestable());
        this.putItemRecord(opt);
    }

    @Override
    public IAEItemStack getFirstItem() {
        Iterator<IAEItemStack> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEItemStack stackType = iterator.next();
            return stackType;
        }
        return null;
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public Iterator<IAEItemStack> iterator() {
        return new MeaningfulItemIterator<IAEItemStack>(this.records.values().iterator());
    }

    @Override
    public void resetStatus() {
        for (IAEItemStack i : this) {
            i.reset();
        }
    }

    private IAEItemStack putItemRecord(IAEItemStack itemStack) {
        return this.records.put(itemStack, itemStack);
    }

    private Collection<IAEItemStack> findFuzzyDamage(AEItemStack filter, FuzzyMode fuzzy, boolean ignoreMeta) {
        IAEItemStack low = filter.getLow(fuzzy, ignoreMeta);
        IAEItemStack high = filter.getHigh(fuzzy, ignoreMeta);
        return this.records.subMap(low, true, high, true).descendingMap().values();
    }
}

