/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.me.storage.ITickingMonitor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

class ItemHandlerAdapter
implements IMEInventory<IAEItemStack>,
IBaseMonitor<IAEItemStack>,
ITickingMonitor {
    private final Map<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();
    private BaseActionSource mySource;
    private final IItemHandler itemHandler;
    private ItemStack[] cachedStacks = new ItemStack[0];
    private IAEItemStack[] cachedAeStacks = new IAEItemStack[0];

    ItemHandlerAdapter(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack iox, Actionable type, BaseActionSource src) {
        ItemStack orgInput;
        ItemStack remaining = orgInput = iox.getItemStack();
        int slotCount = this.itemHandler.getSlots();
        boolean simulate = type == Actionable.SIMULATE;
        for (int i = 0; i < slotCount && remaining != null; ++i) {
            remaining = this.itemHandler.insertItem(i, remaining, simulate);
        }
        if (remaining == orgInput) {
            return iox;
        }
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        return AEItemStack.create(remaining);
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        ItemStack requestedItemStack = request.getItemStack();
        int remainingSize = requestedItemStack.field_77994_a;
        ItemStack gathered = null;
        boolean simulate = mode == Actionable.SIMULATE;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack extracted;
            ItemStack stackInInventorySlot = this.itemHandler.getStackInSlot(i);
            if (!Platform.itemComparisons().isSameItem(stackInInventorySlot, requestedItemStack)) continue;
            int stackSizeCurrentSlot = stackInInventorySlot.field_77994_a;
            int remainingCurrentSlot = Math.min(remainingSize, stackSizeCurrentSlot);
            do {
                if ((extracted = this.itemHandler.extractItem(i, remainingCurrentSlot, simulate)) == null) continue;
                if (extracted.field_77994_a > remainingCurrentSlot) {
                    AELog.warn("Mod that provided item handler %1 is broken. Returned %2 items, even though we requested %3.", this.itemHandler.getClass().getSimpleName(), extracted.field_77994_a, remainingCurrentSlot);
                    extracted.field_77994_a = remainingCurrentSlot;
                }
                if (gathered == null) {
                    gathered = extracted;
                } else {
                    gathered.field_77994_a += extracted.field_77994_a;
                }
                remainingCurrentSlot -= extracted.field_77994_a;
            } while (extracted != null && remainingCurrentSlot > 0);
            if ((remainingSize -= stackSizeCurrentSlot - remainingCurrentSlot) <= 0) break;
        }
        if (gathered != null) {
            if (mode == Actionable.MODULATE) {
                this.onTick();
            }
            return AEItemStack.create(gathered);
        }
        return null;
    }

    @Override
    public TickRateModulation onTick() {
        int slot;
        LinkedList<IAEItemStack> changes = new LinkedList<IAEItemStack>();
        int slots = this.itemHandler.getSlots();
        if (slots > this.cachedStacks.length) {
            this.cachedStacks = Arrays.copyOf(this.cachedStacks, slots);
            this.cachedAeStacks = Arrays.copyOf(this.cachedAeStacks, slots);
        }
        for (slot = 0; slot < slots; ++slot) {
            ItemStack oldIS = this.cachedStacks[slot];
            IAEItemStack oldAeIS = this.cachedAeStacks[slot];
            ItemStack newIS = this.itemHandler.getStackInSlot(slot);
            if (this.isDifferent(newIS, oldIS)) {
                this.addItemChange(slot, oldAeIS, newIS, changes);
                continue;
            }
            if (newIS == null || oldIS == null) continue;
            this.addPossibleStackSizeChange(slot, oldAeIS, newIS, changes);
        }
        if (slots < this.cachedStacks.length) {
            for (slot = slots; slot < this.cachedStacks.length; ++slot) {
                IAEItemStack aeStack = this.cachedAeStacks[slot];
                if (aeStack == null) continue;
                IAEItemStack a = aeStack.copy();
                a.setStackSize(-a.getStackSize());
                changes.add(a);
            }
            this.cachedStacks = Arrays.copyOf(this.cachedStacks, slots);
            this.cachedAeStacks = Arrays.copyOf(this.cachedAeStacks, slots);
        }
        if (!changes.isEmpty()) {
            this.postDifference(changes);
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    private void addItemChange(int slot, IAEItemStack oldAeIS, ItemStack newIS, List<IAEItemStack> changes) {
        this.cachedStacks[slot] = newIS;
        this.cachedAeStacks[slot] = AEItemStack.create(newIS);
        if (oldAeIS != null) {
            oldAeIS.setStackSize(-oldAeIS.getStackSize());
            changes.add(oldAeIS);
        }
        if (this.cachedAeStacks[slot] != null) {
            changes.add(this.cachedAeStacks[slot]);
        }
    }

    private void addPossibleStackSizeChange(int slot, IAEItemStack oldAeIS, ItemStack newIS, List<IAEItemStack> changes) {
        long diff = (long)newIS.field_77994_a - oldAeIS.getStackSize();
        if (diff != 0L) {
            IAEItemStack stack = oldAeIS.copy();
            stack.setStackSize(newIS.field_77994_a);
            this.cachedStacks[slot] = newIS;
            this.cachedAeStacks[slot] = stack;
            IAEItemStack a = stack.copy();
            a.setStackSize(diff);
            changes.add(a);
        }
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a == b && b == null) {
            return false;
        }
        return a == null || b == null || !Platform.itemComparisons().isSameItem(a, b);
    }

    private void postDifference(Iterable<IAEItemStack> a) {
        Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.listeners.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> l = i.next();
            IMEMonitorHandlerReceiver<IAEItemStack> key = l.getKey();
            if (key.isValid(l.getValue())) {
                key.postChange(this, a, this.mySource);
                continue;
            }
            i.remove();
        }
    }

    @Override
    public void setActionSource(BaseActionSource mySource) {
        this.mySource = mySource;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            out.addStorage(AEItemStack.create(this.itemHandler.getStackInSlot(i)));
        }
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    @Override
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
        this.listeners.remove(l);
    }
}

