/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.Logging;
import mcjty.rftools.GeneralConfiguration;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.ModBlocks;
import mcjty.rftools.blocks.builder.BuilderBlock;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.SpaceChamberBlock;
import mcjty.rftools.blocks.builder.SpaceChamberControllerBlock;
import mcjty.rftools.blocks.builder.SupportBlock;
import mcjty.rftools.crafting.PreservingShapedRecipe;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.builder.SpaceChamberCardItem;
import mcjty.rftools.proxy.CommonProxy;
import mcjty.rftools.varia.RFToolsTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BuilderSetup {
    public static SpaceChamberBlock spaceChamberBlock;
    public static SpaceChamberControllerBlock spaceChamberControllerBlock;
    public static BuilderBlock builderBlock;
    public static SupportBlock supportBlock;
    public static SpaceChamberCardItem spaceChamberCardItem;
    public static ShapeCardItem shapeCardItem;
    private static Map<String, BlockInformation> blockInformationMap;

    public static void init() {
        spaceChamberBlock = new SpaceChamberBlock();
        spaceChamberControllerBlock = new SpaceChamberControllerBlock();
        builderBlock = new BuilderBlock();
        supportBlock = new SupportBlock();
        BuilderSetup.initItems();
        BuilderSetup.readBuilderBlocksInternal();
        BuilderSetup.readBuilderBlocksConfig();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        spaceChamberBlock.initModel();
        spaceChamberControllerBlock.initModel();
        builderBlock.initModel();
        supportBlock.initModel();
        spaceChamberCardItem.initModel();
        shapeCardItem.initModel();
    }

    private static void initItems() {
        spaceChamberCardItem = new SpaceChamberCardItem();
        shapeCardItem = new ShapeCardItem();
    }

    public static void initCrafting() {
        Block redstoneTorch = Blocks.field_150429_aA;
        ItemStack lapisStack = new ItemStack(Items.field_151100_aR, 1, 4);
        ItemStack inkSac = new ItemStack(Items.field_151100_aR, 1, 0);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)spaceChamberBlock), (Object[])new Object[]{"lgl", "gMg", "lgl", Character.valueOf('M'), ModBlocks.machineFrame, Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('l'), lapisStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)spaceChamberControllerBlock), (Object[])new Object[]{" e ", "tMt", " e ", Character.valueOf('M'), spaceChamberBlock, Character.valueOf('t'), redstoneTorch, Character.valueOf('e'), Items.field_151079_bi});
        if (GeneralConfiguration.enableBuilderRecipe) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)builderBlock), (Object[])new Object[]{"beb", "rMr", "brb", Character.valueOf('M'), ModBlocks.machineFrame, Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), Blocks.field_150336_V});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)spaceChamberCardItem), (Object[])new Object[]{" b ", "rir", " b ", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), Items.field_151118_aC});
        if (BuilderConfiguration.shapeCardAllowed) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)shapeCardItem, 1, 0), (Object[])new Object[]{"pbp", "rir", "pbp", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), Items.field_151118_aC, Character.valueOf('p'), Items.field_151121_aF});
            if (BuilderConfiguration.quarryAllowed) {
                GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{inkSac, new ItemStack(Blocks.field_150343_Z), inkSac, new ItemStack(Blocks.field_150343_Z), new ItemStack((Item)shapeCardItem, 1, 0), new ItemStack(Blocks.field_150343_Z), inkSac, new ItemStack(Blocks.field_150343_Z), inkSac}, new ItemStack((Item)shapeCardItem, 1, 1), 4));
                GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151133_ar), new ItemStack((Item)shapeCardItem, 1, 0), new ItemStack(Items.field_151133_ar), new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151129_at), new ItemStack(Items.field_151137_ax)}, new ItemStack((Item)shapeCardItem, 1, 8), 4));
                GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151046_w), new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151042_j), new ItemStack((Item)shapeCardItem, 1, 0), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151047_v), new ItemStack(Items.field_151137_ax)}, new ItemStack((Item)shapeCardItem, 1, 2), 4));
                GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack((Item)ModItems.dimensionalShardItem), new ItemStack(Items.field_151156_bN), new ItemStack((Item)ModItems.dimensionalShardItem), new ItemStack(Items.field_151045_i), new ItemStack((Item)shapeCardItem, 1, 2), new ItemStack(Items.field_151045_i), new ItemStack((Item)ModItems.dimensionalShardItem), new ItemStack(Items.field_151045_i), new ItemStack((Item)ModItems.dimensionalShardItem)}, new ItemStack((Item)shapeCardItem, 1, 3), 4));
                GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack((Item)ModItems.dimensionalShardItem), new ItemStack(Items.field_151073_bk), new ItemStack((Item)ModItems.dimensionalShardItem), new ItemStack(Items.field_151166_bC), new ItemStack((Item)shapeCardItem, 1, 2), new ItemStack(Items.field_151045_i), new ItemStack((Item)ModItems.dimensionalShardItem), new ItemStack(Items.field_151137_ax), new ItemStack((Item)ModItems.dimensionalShardItem)}, new ItemStack((Item)shapeCardItem, 1, 4), 4));
                if (BuilderConfiguration.clearingQuarryAllowed) {
                    GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack((Item)shapeCardItem, 1, 2), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w)}, new ItemStack((Item)shapeCardItem, 1, 5), 4));
                    GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack((Item)shapeCardItem, 1, 3), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w)}, new ItemStack((Item)shapeCardItem, 1, 6), 4));
                    GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack((Item)shapeCardItem, 1, 4), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w)}, new ItemStack((Item)shapeCardItem, 1, 7), 4));
                    GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack((Item)shapeCardItem, 1, 8), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w)}, new ItemStack((Item)shapeCardItem, 1, 9), 4));
                    GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack((Item)shapeCardItem, 1, 5), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d)}, new ItemStack((Item)shapeCardItem, 1, 2), 4));
                    GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack((Item)shapeCardItem, 1, 6), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d)}, new ItemStack((Item)shapeCardItem, 1, 3), 4));
                    GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack((Item)shapeCardItem, 1, 7), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d)}, new ItemStack((Item)shapeCardItem, 1, 4), 4));
                    GameRegistry.addRecipe((IRecipe)new PreservingShapedRecipe(3, 3, new ItemStack[]{new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack((Item)shapeCardItem, 1, 9), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150346_d)}, new ItemStack((Item)shapeCardItem, 1, 8), 4));
                }
            }
        }
    }

    private static void readBuilderBlocksInternal() {
        try {
            InputStream inputstream = RFTools.class.getResourceAsStream("/assets/rftools/text/builder.json");
            BuilderSetup.parseBuilderJson(inputstream);
        }
        catch (IOException e) {
            Logging.logError((String)"Error reading builder.json", (Throwable)e);
        }
    }

    private static void readBuilderBlocksConfig() {
        File modConfigDir = CommonProxy.modConfigDir;
        try {
            File file = new File(modConfigDir.getPath() + File.separator + "rftools", "userbuilder.json");
            FileInputStream inputstream = new FileInputStream(file);
            BuilderSetup.parseBuilderJson(inputstream);
        }
        catch (IOException e) {
            Logging.log((String)"Could not read 'userbuilder.json', this is not an error!");
        }
    }

    private static void parseBuilderJson(InputStream inputstream) throws UnsupportedEncodingException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
            if ("movables".equals(entry.getKey())) {
                BuilderSetup.readMovablesFromJson((JsonElement)entry.getValue());
                continue;
            }
            if (!"rotatables".equals(entry.getKey())) continue;
            BuilderSetup.readRotatablesFromJson((JsonElement)entry.getValue());
        }
    }

    private static void readMovablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String warningType = entry.getAsJsonArray().get(1).getAsString();
            double costFactor = entry.getAsJsonArray().get(2).getAsDouble();
            int status = "-".equals(warningType) ? 2 : ("+".equals(warningType) ? 0 : 1);
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = BlockInformation.OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, blockName, status, costFactor));
        }
    }

    private static void readRotatablesFromJson(JsonElement element) {
        for (JsonElement entry : element.getAsJsonArray()) {
            String blockName = entry.getAsJsonArray().get(0).getAsString();
            String rotatable = entry.getAsJsonArray().get(1).getAsString();
            BlockInformation old = blockInformationMap.get(blockName);
            if (old == null) {
                old = BlockInformation.OK;
            }
            blockInformationMap.put(blockName, new BlockInformation(old, rotatable));
        }
    }

    public static BlockInformation getBlockInformation(Block block) {
        BlockInformation information = blockInformationMap.get(block.getRegistryName().toString());
        if (information == null) {
            String modid = RFToolsTools.getModidForBlock(block);
            information = blockInformationMap.get("modid:" + modid);
        }
        return information;
    }

    static {
        blockInformationMap = new HashMap<String, BlockInformation>();
    }

    public static class BlockInformation {
        private final String blockName;
        private final int blockLevel;
        private final double costFactor;
        private final int rotateInfo;
        public static final int ROTATE_invalid = -1;
        public static final int ROTATE_mmmm = 0;
        public static final int ROTATE_mfff = 1;
        public static final BlockInformation INVALID = new BlockInformation("", 2, 1.0);
        public static final BlockInformation OK = new BlockInformation("", 0, 1.0, 0);
        public static final BlockInformation FREE = new BlockInformation("", 0, 0.0, 0);

        private static int rotateStringToId(String rotateString) {
            if ("mmmm".equals(rotateString)) {
                return 0;
            }
            if ("mfff".equals(rotateString)) {
                return 1;
            }
            return -1;
        }

        public BlockInformation(String blockName, int blockLevel, double costFactor) {
            this.blockName = blockName;
            this.blockLevel = blockLevel;
            this.costFactor = costFactor;
            this.rotateInfo = 0;
        }

        public BlockInformation(String blockName, int blockLevel, double costFactor, int rotateInfo) {
            this.blockName = blockName;
            this.blockLevel = blockLevel;
            this.costFactor = costFactor;
            this.rotateInfo = rotateInfo;
        }

        public BlockInformation(BlockInformation other, String rotateInfo) {
            this(other.blockName, other.blockLevel, other.costFactor, BlockInformation.rotateStringToId(rotateInfo));
        }

        public BlockInformation(BlockInformation other, String blockName, int blockLevel, double costFactor) {
            this(blockName, blockLevel, costFactor, other.rotateInfo);
        }

        public int getBlockLevel() {
            return this.blockLevel;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getRotateInfo() {
            return this.rotateInfo;
        }
    }
}

