/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import lumien.randomthings.CommonProxy;
import lumien.randomthings.asm.MCPNames;
import lumien.randomthings.client.models.ItemModels;
import lumien.randomthings.client.models.blocks.BlockModels;
import lumien.randomthings.client.render.RenderArtificialEndPortal;
import lumien.randomthings.client.render.RenderBiomeRadar;
import lumien.randomthings.client.render.RenderProjectedItem;
import lumien.randomthings.client.render.RenderReviveCircle;
import lumien.randomthings.client.render.RenderSoul;
import lumien.randomthings.client.render.RenderSpecialChest;
import lumien.randomthings.client.render.RenderSpirit;
import lumien.randomthings.client.render.RenderVoxelProjector;
import lumien.randomthings.entitys.EntityArtificialEndPortal;
import lumien.randomthings.entitys.EntityProjectedItem;
import lumien.randomthings.entitys.EntityReviveCircle;
import lumien.randomthings.entitys.EntitySoul;
import lumien.randomthings.entitys.EntitySpirit;
import lumien.randomthings.item.ItemRezStone;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.lib.IRTBlockColor;
import lumien.randomthings.lib.IRTItemColor;
import lumien.randomthings.tileentity.TileEntityBiomeRadar;
import lumien.randomthings.tileentity.TileEntityRedstoneObserver;
import lumien.randomthings.tileentity.TileEntitySpecialChest;
import lumien.randomthings.tileentity.TileEntityVoxelProjector;
import lumien.randomthings.tileentity.redstoneinterface.TileEntityAdvancedRedstoneInterface;
import lumien.randomthings.tileentity.redstoneinterface.TileEntityBasicRedstoneInterface;
import lumien.randomthings.tileentity.redstoneinterface.TileEntityRedstoneInterface;
import lumien.randomthings.util.client.RenderUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import org.lwjgl.opengl.GL11;

public class ClientProxy
extends CommonProxy {
    static Field itemColorsField;
    HashMap<Object, Object> scheduledColorRegister = new HashMap();

    @Override
    public boolean canBeCollidedWith(EntitySoul soul) {
        ItemStack equipped = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        return equipped != null && equipped.func_77973_b() instanceof ItemRezStone;
    }

    @Override
    public void scheduleColor(Object o) {
        if (o instanceof IRTBlockColor || o instanceof IRTItemColor) {
            this.scheduledColorRegister.put(o, o);
        }
    }

    private void registerColors() {
        for (Map.Entry<Object, Object> entry : this.scheduledColorRegister.entrySet()) {
            if (entry.getKey() instanceof IRTBlockColor) {
                final IRTBlockColor blockColor = (IRTBlockColor)entry.getKey();
                Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

                    public int func_186720_a(IBlockState state, IBlockAccess p_186720_2_, BlockPos pos, int tintIndex) {
                        return blockColor.colorMultiplier(state, p_186720_2_, pos, tintIndex);
                    }
                }, new Block[]{(Block)entry.getValue()});
                continue;
            }
            if (!(entry.getKey() instanceof IRTItemColor)) continue;
            final IRTItemColor itemColor = (IRTItemColor)entry.getKey();
            try {
                ItemColors itemColors = (ItemColors)itemColorsField.get(Minecraft.func_71410_x());
                itemColors.func_186730_a(new IItemColor(){

                    public int func_186726_a(ItemStack stack, int tintIndex) {
                        return itemColor.getColorFromItemstack(stack, tintIndex);
                    }
                }, new Item[]{(Item)entry.getValue()});
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void registerModels() {
        ItemModels.register();
        BlockModels.register();
    }

    @Override
    public boolean isPlayerOnline(String username) {
        NetHandlerPlayClient netclienthandler = Minecraft.func_71410_x().field_71439_g.field_71174_a;
        Collection collection = netclienthandler.func_175106_d();
        for (NetworkPlayerInfo info : collection) {
            if (!info.func_178845_a().getName().toLowerCase().equals(username.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntitySoul.class, (Render)new RenderSoul(Minecraft.func_71410_x().func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(EntityReviveCircle.class, (Render)new RenderReviveCircle(Minecraft.func_71410_x().func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(EntitySpirit.class, (Render)new RenderSpirit(Minecraft.func_71410_x().func_175598_ae(), (ModelBase)new ModelSlime(16), 0.25f));
        RenderingRegistry.registerEntityRenderingHandler(EntityArtificialEndPortal.class, (Render)new RenderArtificialEndPortal(Minecraft.func_71410_x().func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectedItem.class, (Render)new RenderProjectedItem(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySpecialChest.class, (TileEntitySpecialRenderer)new RenderSpecialChest());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVoxelProjector.class, (TileEntitySpecialRenderer)new RenderVoxelProjector());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBiomeRadar.class, (TileEntitySpecialRenderer)new RenderBiomeRadar());
        this.registerColors();
    }

    @Override
    public void renderRedstoneInterfaceStuff(float partialTicks) {
        Item item;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack itemStack = player.func_184614_ca();
        if (itemStack != null && (item = itemStack.func_77973_b()) == ModItems.redstoneTool) {
            this.drawInterfaceLines(player, partialTicks);
            this.drawLinkingCube(itemStack, player, partialTicks);
        }
    }

    private void drawLinkingCube(ItemStack itemStack, EntityPlayerSP player, float partialTicks) {
        NBTTagCompound compound;
        if (itemStack.func_77978_p() != null && (compound = itemStack.func_77978_p()).func_74767_n("linking")) {
            int oX = compound.func_74762_e("oX");
            int oY = compound.func_74762_e("oY");
            int oZ = compound.func_74762_e("oZ");
            double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
            RenderUtils.drawCube((float)oX - 0.01f, (float)oY - 0.01f, (float)oZ - 0.01f, 1.02f, 122, 0, 0, 46);
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawInterfaceLines(EntityPlayerSP player, float partialTicks) {
        BlockPos position;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GlStateManager.func_179123_a();
        GL11.glEnable((int)2848);
        GL11.glLineWidth((float)10.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179094_E();
        worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        ArrayList<TileEntityRedstoneInterface> interfaces = new ArrayList<TileEntityRedstoneInterface>();
        Iterator iterator = TileEntityRedstoneInterface.lock;
        synchronized (iterator) {
            interfaces.addAll(TileEntityRedstoneInterface.interfaces);
        }
        for (TileEntityRedstoneInterface redstoneInterface : interfaces) {
            if (redstoneInterface.func_145837_r() || !redstoneInterface.func_145831_w().field_72995_K) continue;
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            if (redstoneInterface instanceof TileEntityBasicRedstoneInterface) {
                TileEntityBasicRedstoneInterface simpleRedstoneInterface = (TileEntityBasicRedstoneInterface)redstoneInterface;
                position = simpleRedstoneInterface.func_174877_v();
                BlockPos target = simpleRedstoneInterface.getTarget();
                if (target != null) {
                    positions.add(target);
                    positions.add(position);
                }
            } else if (redstoneInterface instanceof TileEntityAdvancedRedstoneInterface) {
                TileEntityAdvancedRedstoneInterface advancedRedstoneInterface = (TileEntityAdvancedRedstoneInterface)redstoneInterface;
                position = advancedRedstoneInterface.func_174877_v();
                Set<BlockPos> targets = advancedRedstoneInterface.getTargets();
                for (BlockPos target : targets) {
                    positions.add(target);
                    positions.add(position);
                }
            }
            for (int i = 0; i < positions.size(); i += 2) {
                BlockPos target = (BlockPos)positions.get(i);
                BlockPos position2 = (BlockPos)positions.get(i + 1);
                if (!(position2.func_177951_i((Vec3i)player.func_180425_c()) < 225.0)) continue;
                worldRenderer.func_181662_b((double)target.func_177958_n() + 0.5 - playerX, (double)target.func_177956_o() + 0.5 - playerY, (double)target.func_177952_p() + 0.5 - playerZ).func_181669_b(255, 0, 0, 255).func_181675_d();
                worldRenderer.func_181662_b((double)position2.func_177958_n() + 0.5 - playerX, (double)position2.func_177956_o() + 0.5 - playerY, (double)position2.func_177952_p() + 0.5 - playerZ).func_181669_b(255, 0, 0, 255).func_181675_d();
            }
        }
        ArrayList<TileEntityRedstoneObserver> observers = new ArrayList<TileEntityRedstoneObserver>();
        Set<TileEntityRedstoneObserver> set = TileEntityRedstoneObserver.loadedObservers;
        synchronized (set) {
            observers.addAll(TileEntityRedstoneObserver.loadedObservers);
        }
        for (TileEntityRedstoneObserver redstoneObserver : observers) {
            if (redstoneObserver.func_145837_r()) continue;
            BlockPos target = redstoneObserver.getTarget();
            position = redstoneObserver.func_174877_v();
            if (target == null || !(target.func_177951_i((Vec3i)player.func_180425_c()) < 225.0)) continue;
            worldRenderer.func_181662_b((double)target.func_177958_n() + 0.5 - playerX, (double)target.func_177956_o() + 0.5 - playerY, (double)target.func_177952_p() + 0.5 - playerZ).func_181669_b(255, 0, 0, 255).func_181675_d();
            worldRenderer.func_181662_b((double)position.func_177958_n() + 0.5 - playerX, (double)position.func_177956_o() + 0.5 - playerY, (double)position.func_177952_p() + 0.5 - playerZ).func_181669_b(255, 0, 0, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GL11.glDisable((int)2848);
        GlStateManager.func_179098_w();
        GlStateManager.func_179099_b();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    static {
        try {
            itemColorsField = Minecraft.class.getDeclaredField(MCPNames.field("field_184128_aI"));
            itemColorsField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

