/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.tool;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.BaseTool;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemToolWarp
extends BaseTool
implements IHasRecipe {
    private static final int cooldown = 600;
    private static final int durability = 16;
    private WarpType warpType;

    public ItemToolWarp(WarpType type) {
        super(16);
        this.warpType = type;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World world, EntityPlayer player, EnumHand hand) {
        if (player.field_71093_bK != 0) {
            UtilChat.addChatMessage(player, "command.worldhome.dim");
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        boolean success = false;
        switch (this.warpType) {
            case BED: {
                success = UtilWorld.tryTpPlayerToBed(world, player);
                break;
            }
            case SPAWN: {
                UtilEntity.teleportWallSafe((EntityLivingBase)player, world, world.func_175694_M());
                success = true;
                break;
            }
        }
        if (success) {
            super.onUse(itemStackIn, player, world, hand);
            player.func_184811_cZ().func_185145_a((Item)this, 600);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        switch (this.warpType) {
            case BED: {
                tooltip.add(UtilChat.lang("item.tool_warp_home.tooltip"));
                break;
            }
            case SPAWN: {
                tooltip.add(UtilChat.lang("item.tool_warp_spawn.tooltip"));
                break;
            }
        }
    }

    @Override
    public void addRecipe() {
        switch (this.warpType) {
            case BED: {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{" ft", "ggf", "dg ", Character.valueOf('t'), new ItemStack(Items.field_151073_bk), Character.valueOf('f'), new ItemStack(Items.field_151008_G), Character.valueOf('g'), new ItemStack(Items.field_151043_k), Character.valueOf('d'), new ItemStack(Items.field_151061_bv)});
                break;
            }
            case SPAWN: {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{" ff", "ggf", "dg ", Character.valueOf('f'), new ItemStack(Items.field_151008_G), Character.valueOf('g'), new ItemStack(Items.field_151074_bl), Character.valueOf('d'), new ItemStack(Items.field_151045_i)});
                break;
            }
        }
    }

    public static enum WarpType {
        BED,
        SPAWN;

    }
}

