/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.enchantment;

import com.lothrazar.cyclicmagic.enchantment.EnchantBase;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnchantLaunch
extends EnchantBase {
    private static final float power = 1.05f;
    private static final int rotationPitch = 75;
    private static final int cooldown = 40;
    private static final String NBT_USES = "launchuses";

    public EnchantLaunch() {
        super(Enchantment.Rarity.COMMON, EnumEnchantmentType.ARMOR_FEET, new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET});
        this.func_77322_b("launch");
    }

    public int func_77325_b() {
        return 5;
    }

    public boolean func_92089_a(ItemStack stack) {
        boolean yes = stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).field_77881_a == EntityEquipmentSlot.FEET;
        return yes;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.func_92089_a(stack);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)event.getEntity();
            ItemStack feet = p.func_184582_a(EntityEquipmentSlot.FEET);
            if (feet == null) {
                return;
            }
            if ((!p.field_70160_al || p.field_70122_E) && UtilNBT.getItemStackNBTVal(feet, NBT_USES) > 0) {
                UtilNBT.setItemStackNBTVal(feet, NBT_USES, 0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        ItemStack feet = p.func_184582_a(EntityEquipmentSlot.FEET);
        if (feet == null) {
            return;
        }
        if (FMLClientHandler.instance().getClient().field_71474_y.field_74314_A.func_151468_f() && p.field_70163_u < p.field_70137_T && p.field_70160_al && !p.func_70090_H()) {
            if (!EnchantmentHelper.func_82781_a((ItemStack)feet).containsKey((Object)this)) {
                return;
            }
            int level = (Integer)EnchantmentHelper.func_82781_a((ItemStack)feet).get((Object)this);
            if (p.func_184811_cZ().func_185141_a(feet.func_77973_b())) {
                return;
            }
            int uses = UtilNBT.getItemStackNBTVal(feet, NBT_USES);
            p.field_70143_R = 0.0f;
            UtilEntity.launch((Entity)p, 75.0f, 1.05f);
            UtilParticle.spawnParticle(p.func_130014_f_(), EnumParticleTypes.CRIT_MAGIC, p.func_180425_c());
            UtilSound.playSound((EntityPlayer)p, p.func_180425_c(), SoundRegistry.bwoaaap, SoundCategory.PLAYERS, 0.125f);
            UtilItemStack.damageItem((EntityPlayer)p, feet);
            if (++uses >= level) {
                if (feet != null) {
                    p.func_184811_cZ().func_185145_a(feet.func_77973_b(), 40);
                }
                uses = 0;
            }
            UtilNBT.setItemStackNBTVal(feet, NBT_USES, uses);
        }
    }
}

