/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.tileentity.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilUncraft;
import java.util.ArrayList;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class TileMachineUncrafter
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    public static int TIMER_FULL;
    private ItemStack[] inv;
    private int timer;
    private int needsRedstone = 1;
    private int[] hopperInput = new int[]{0};
    private int[] hopperOutput;
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_REDST = "redstone";
    public static final int SLOT_UNCRAFTME = 0;
    public static final int SLOT_ROWS = 3;
    public static final int SLOT_COLS = 7;

    public TileMachineUncrafter() {
        this.inv = new ItemStack[22];
        this.timer = TIMER_FULL;
        this.hopperOutput = new int[21];
        for (int i = 1; i <= 21; ++i) {
            this.hopperOutput[i - 1] = i;
        }
    }

    @Override
    public int func_70302_i_() {
        return this.inv.length;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        this.timer = tagCompound.func_74762_e(NBT_TIMER);
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_TIMER, this.timer);
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(NBT_SLOT, (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a(NBT_INV, (NBTBase)itemList);
        return super.func_189515_b(tagCompound);
    }

    public int getTimer() {
        return this.timer;
    }

    public boolean isBurning() {
        return this.timer > 0 && this.timer < TIMER_FULL;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return;
        }
        this.spawnParticlesAbove();
        --this.timer;
        if (this.timer <= 0) {
            this.timer = TIMER_FULL;
            UtilUncraft.Uncrafter uncrafter = new UtilUncraft.Uncrafter();
            boolean success = false;
            try {
                boolean bl = success = uncrafter.process(stack) == UtilUncraft.UncraftResultType.SUCCESS;
                if (success) {
                    if (!this.func_145831_w().field_72995_K) {
                        ArrayList<ItemStack> uncrafterOutput = uncrafter.getDrops();
                        this.setOutputItems(uncrafterOutput);
                        this.func_70298_a(0, uncrafter.getOutsize());
                    }
                    UtilSound.playSound(this.func_145831_w(), this.func_174877_v(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS);
                } else {
                    ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
                    toDrop.add(stack);
                    this.setOutputItems(toDrop);
                    if (!this.func_145831_w().field_72995_K) {
                        this.func_70298_a(0, stack.field_77994_a);
                    }
                    UtilSound.playSound(this.func_145831_w(), this.func_174877_v(), SoundEvents.field_187737_v, SoundCategory.BLOCKS);
                }
                this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v().func_177984_a());
                this.func_70296_d();
            }
            catch (Exception e) {
                ModCyclic.logger.error("Unhandled exception in uncrafting ");
                ModCyclic.logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void setOutputItems(ArrayList<ItemStack> output) {
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory(output, this, 1);
        if (toDrop != null) {
            for (ItemStack s : toDrop) {
                UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.func_174877_v().func_177984_a(), s);
            }
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return this.hopperInput;
        }
        return this.hopperOutput;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case REDSTONE: {
                    if (this.needsRedstone != 1 && this.needsRedstone != 0) {
                        this.needsRedstone = 0;
                    }
                    return this.needsRedstone;
                }
            }
        }
        return -7;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case REDSTONE: {
                    if (value != 1 && value != 0) {
                        value = 0;
                    }
                    this.needsRedstone = value;
                    break;
                }
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE;

    }
}

