/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.google.common.base.Function;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BaseMachineTesr<T extends TileEntityBaseMachineInvo>
extends TileEntitySpecialRenderer<T> {
    private IModel model;
    private IBakedModel bakedModel;
    private String resource = null;
    protected int itemSlotAbove = -1;

    public BaseMachineTesr(String res, int slot) {
        this.resource = res;
        this.itemSlotAbove = slot;
    }

    public BaseMachineTesr(int slot) {
        this(null, slot);
    }

    public abstract void render(TileEntityBaseMachineInvo var1);

    protected IBakedModel getBakedModel() {
        if (this.bakedModel == null && this.resource != null) {
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("cyclicmagic", this.resource));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.bakedModel = this.model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                public TextureAtlasSprite apply(ResourceLocation location) {
                    return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                }
            });
        }
        return this.bakedModel;
    }

    public void renderTileEntityAt(TileEntityBaseMachineInvo te, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179101_C();
        if (te.isRunning()) {
            this.render(te);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    protected void renderAnimation(TileEntityBaseMachineInvo te) {
        GlStateManager.func_179094_E();
        EnumFacing facing = te.getCurrentFacing();
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
        }
        double currTenthOfSec = System.currentTimeMillis() / 100L;
        double ratio = currTenthOfSec % 8.0 / 10.0;
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-1.0 * ratio));
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        World world = te.func_145831_w();
        GlStateManager.func_179109_b((float)(-te.func_174877_v().func_177958_n()), (float)(-te.func_174877_v().func_177956_o()), (float)(-te.func_174877_v().func_177952_p()));
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, this.getBakedModel(), world.func_180495_p(te.func_174877_v()), te.func_174877_v(), Tessellator.func_178181_a().func_178180_c(), false);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    protected void renderItem(TileEntityBaseMachineInvo te, ItemStack stack, float itemHeight) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        long angle = System.currentTimeMillis() / 10L % 360L;
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        GlStateManager.func_179137_b((double)0.5, (double)itemHeight, (double)0.5);
        float scaleFactor = 0.4f;
        GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
        int ambLight = this.func_178459_a().func_175626_b(te.func_174877_v().func_177972_a(EnumFacing.UP), 0);
        int lu = ambLight % 65536;
        int lv = ambLight / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lu / 1.0f), (float)((float)lv / 1.0f));
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }
}

