/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.inventory;

import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ItemInventory
implements IInventory {
    protected int[] syncedSlots = new int[0];
    private ItemStack[] inventory;
    private int size;
    private String name;
    protected ItemStack masterStack;

    public ItemInventory(ItemStack masterStack, int size, String name) {
        this.inventory = new ItemStack[size];
        this.size = size;
        this.name = name;
        this.masterStack = masterStack;
        if (masterStack != null) {
            this.readFromStack(masterStack);
        }
    }

    public void initializeInventory(ItemStack masterStack) {
        this.masterStack = masterStack;
        this.func_174888_l();
        this.readFromStack(masterStack);
    }

    private boolean isSyncedSlot(int slot) {
        for (int s : this.syncedSlots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        NBTTagList tags = tagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound data;
            byte j;
            if (this.isSyncedSlot(i) || (j = (data = tags.func_150305_b(i)).func_74771_c("Slot")) < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null || this.isSyncedSlot(i)) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(data);
            tags.func_74742_a((NBTBase)data);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tags);
    }

    public void readFromStack(ItemStack masterStack) {
        if (masterStack != null) {
            NBTHelper.checkNBT(masterStack);
            NBTTagCompound tag = masterStack.func_77978_p();
            this.readFromNBT(tag.func_74775_l("itemInventory"));
        }
    }

    public void writeToStack(ItemStack masterStack) {
        if (masterStack != null) {
            NBTHelper.checkNBT(masterStack);
            NBTTagCompound tag = masterStack.func_77978_p();
            NBTTagCompound invTag = new NBTTagCompound();
            this.writeToNBT(invTag);
            tag.func_74782_a("itemInventory", (NBTBase)invTag);
        }
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory[index] != null) {
            if (this.inventory[index].field_77994_a <= count) {
                ItemStack itemStack = this.inventory[index];
                this.inventory[index] = null;
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = this.inventory[index].func_77979_a(count);
            if (this.inventory[index].field_77994_a == 0) {
                this.inventory[index] = null;
            }
            this.func_70296_d();
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemStack = this.inventory[slot];
            this.func_70299_a(slot, null);
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory = new ItemStack[this.size];
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public void func_70296_d() {
        if (this.masterStack != null) {
            this.writeToStack(this.masterStack);
        }
    }

    public boolean canInventoryBeManipulated() {
        return this.masterStack != null;
    }
}

