/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.spawn;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.ICapacitorKey;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.obelisk.AbstractRangedTileEntity;
import crazypants.util.CapturedMob;
import info.loenwind.autosave.annotations.Storable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

@Storable
public abstract class AbstractMobObelisk
extends AbstractRangedTileEntity {
    public AbstractMobObelisk(SlotDefinition slotDefinition, ICapacitorKey maxEnergyRecieved, ICapacitorKey maxEnergyStored, ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(i)) {
            return false;
        }
        return CapturedMob.containsSoul(itemstack);
    }

    @Override
    public boolean isActive() {
        return this.redstoneCheckPassed && this.hasPower();
    }

    protected double usePower() {
        return this.usePower(this.getPowerUsePerTick());
    }

    protected int usePower(int wantToUse) {
        int used = Math.min(this.getEnergyStored(null), wantToUse);
        this.setEnergyStored(Math.max(0, this.getEnergyStored(null) - used));
        return used;
    }

    protected boolean isMobInRange(EntityLivingBase mob) {
        if (mob == null || this.getBounds() == null) {
            return false;
        }
        return this.getBounds().func_72318_a(new Vec3d(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v));
    }

    protected boolean isMobInFilter(EntityLivingBase entity) {
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            CapturedMob mob = CapturedMob.create(this.inventory[i]);
            if (mob == null || !mob.isSameType((Entity)entity)) continue;
            return true;
        }
        return false;
    }

    public List<CapturedMob> getMobsInFilter() {
        ArrayList<CapturedMob> result = new ArrayList<CapturedMob>();
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot; ++i) {
            CapturedMob mob = CapturedMob.create(this.inventory[i]);
            if (mob == null) continue;
            result.add(mob);
        }
        return result;
    }

    public AbstractMobObelisk(SlotDefinition slotDefinition, ModObject modObject) {
        super(slotDefinition, modObject);
    }

    public abstract SpawnObeliskAction getSpawnObeliskAction();

    public static enum SpawnObeliskAction {
        ATTRACT("blockAttractor.action"),
        AVERT("blockSpawnGuard.action"),
        RELOCATE("blockSpawnRelocator.action"),
        SPAWN("blockPoweredSpawner.action");

        private final String langKey;

        private SpawnObeliskAction(String langKey) {
            this.langKey = langKey;
        }

        public String getActionString() {
            return EnderIO.lang.localize(this.langKey);
        }
    }
}

