/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.sensor;

import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.ItemConduitNetwork;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.invpanel.sensor.PacketActive;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileInventoryPanelSensor
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    private int slowstart = 10;
    @Store
    private int startCount = 32;
    @Store
    private int stopCount = 64;
    private int currentSignal = 0;
    @Store
    private ItemStack itemToCheck = null;
    private boolean active = false;

    public TileInventoryPanelSensor() {
        super(new SlotDefinition(0, 0, 0), CapacitorKey.INV_PANEL_SENSOR_POWER_INTAKE, CapacitorKey.INV_PANEL_SENSOR_POWER_BUFFER, CapacitorKey.INV_PANEL_SENSOR_POWER_USE);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockInventoryPanelSensor.getUnlocalisedName();
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nullable ItemStack item) {
        return false;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode == IoMode.NONE || mode == IoMode.DISABLED;
    }

    @Override
    protected boolean checkProgress(boolean redstoneChecksPassed) {
        this.usePower();
        if (this.slowstart > 0) {
            --this.slowstart;
            return false;
        }
        if (this.shouldDoWorkThisTick(10)) {
            if (this.itemToCheck != null) {
                InventoryDatabaseServer db = this.getInventoryDB();
                if (db != null) {
                    int invHasCount = 0;
                    ItemEntry entry = db.lookupItem(this.itemToCheck, null, false);
                    if (entry != null) {
                        invHasCount = entry.countItems();
                    }
                    this.updateRedstone(invHasCount);
                } else {
                    this.setCurrentSignal(0);
                }
            } else if (this.isEmitting()) {
                this.setCurrentSignal(0);
            }
        }
        return false;
    }

    private void updateRedstone(int invHasCount) {
        if (this.itemToCheck == null) {
            this.setCurrentSignal(0);
            return;
        }
        if (this.isEmitting()) {
            if (invHasCount >= this.stopCount) {
                this.setCurrentSignal(0);
            }
        } else if (invHasCount <= this.startCount) {
            this.setCurrentSignal(15);
        }
    }

    private void setCurrentSignal(int newVal) {
        if (this.currentSignal == newVal) {
            return;
        }
        this.currentSignal = newVal;
        this.setActive(this.isEmitting());
        PacketHandler.sendToAllAround((IMessage)new PacketActive(this), (TileEntity)this);
        this.broadcastSignal();
        this.func_70296_d();
    }

    private void broadcastSignal() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    public InventoryDatabaseServer getInventoryDB() {
        for (EnumFacing dir : EnumFacing.values()) {
            InventoryDatabaseServer db;
            AbstractConduitNetwork<?, ?> n;
            IItemConduit con = ConduitUtil.getConduit(this.field_145850_b, (TileEntity)this, dir, IItemConduit.class);
            if (con == null || !((n = con.getNetwork()) instanceof ItemConduitNetwork) || (db = ((ItemConduitNetwork)n).getDatabase()) == null) continue;
            return db;
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public ItemStack getItemToCheck() {
        return this.itemToCheck;
    }

    public void setItemToCheck(ItemStack itemToCheck) {
        this.itemToCheck = itemToCheck;
        this.func_70296_d();
    }

    public int getStartCount() {
        return this.startCount;
    }

    public void setStartCount(int startCount) {
        this.startCount = startCount;
        this.func_70296_d();
    }

    public int getStopCount() {
        return this.stopCount;
    }

    public void setStopCount(int stopCount) {
        this.stopCount = stopCount;
        this.func_70296_d();
    }

    public boolean isEmitting() {
        return this.getRedstoneLevel() > 0;
    }

    public int getRedstoneLevel() {
        return this.currentSignal;
    }
}

