/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractItemConduit;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.liquid.AdvancedLiquidConduit;
import crazypants.enderio.conduit.liquid.AdvancedLiquidConduitRenderer;
import crazypants.enderio.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduit.liquid.EnderLiquidConduitRenderer;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduitRenderer;
import crazypants.enderio.conduit.registry.ConduitRegistry;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IconEIO;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLiquidConduit
extends AbstractItemConduit
implements IAdvancedTooltipProvider {
    private final ConduitRegistry.ConduitInfo conduitInfo = new ConduitRegistry.ConduitInfo(this.getBaseConduitType(), Offset.WEST, Offset.NORTH, Offset.WEST, Offset.WEST);
    private static ItemConduitSubtype[] subtypes = new ItemConduitSubtype[]{new ItemConduitSubtype(ModObject.itemLiquidConduit.name(), "enderio:itemLiquidConduit"), new ItemConduitSubtype(ModObject.itemLiquidConduit.name() + "Advanced", "enderio:itemLiquidConduitAdvanced"), new ItemConduitSubtype(ModObject.itemLiquidConduit.name() + "Ender", "enderio:itemLiquidConduitEnder")};

    public static ItemLiquidConduit create() {
        ItemLiquidConduit result = new ItemLiquidConduit();
        result.init();
        return result;
    }

    protected ItemLiquidConduit() {
        super(ModObject.itemLiquidConduit, subtypes);
        this.conduitInfo.addMember(LiquidConduit.class);
        this.conduitInfo.addMember(AdvancedLiquidConduit.class);
        this.conduitInfo.addMember(EnderLiquidConduit.class);
        ConduitRegistry.register(this.conduitInfo);
        ConduitDisplayMode.registerDisplayMode(new ConduitDisplayMode(this.getBaseConduitType(), (IWidgetIcon)IconEIO.WRENCH_OVERLAY_FLUID, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_FLUID_OFF));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        super.registerRenderers();
        this.conduitInfo.addRenderer(LiquidConduitRenderer.create());
        this.conduitInfo.addRenderer(new AdvancedLiquidConduitRenderer());
        this.conduitInfo.addRenderer(new EnderLiquidConduitRenderer());
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return ILiquidConduit.class;
    }

    @Override
    public IConduit createConduit(ItemStack stack, EntityPlayer player) {
        if (stack.func_77952_i() == 1) {
            return new AdvancedLiquidConduit();
        }
        if (stack.func_77952_i() == 2) {
            return new EnderLiquidConduit();
        }
        return new LiquidConduit();
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        int maxIo;
        int extractRate;
        if (itemstack.func_77952_i() == 0) {
            extractRate = Config.fluidConduitExtractRate;
            maxIo = Config.fluidConduitMaxIoRate;
        } else if (itemstack.func_77952_i() == 1) {
            extractRate = Config.advancedFluidConduitExtractRate;
            maxIo = Config.advancedFluidConduitMaxIoRate;
        } else {
            extractRate = Config.enderFluidConduitExtractRate;
            maxIo = Config.enderFluidConduitMaxIoRate;
        }
        String mbt = " " + EnderIO.lang.localize("fluid.millibucketsTick");
        list.add(EnderIO.lang.localize("itemLiquidConduit.tooltip.maxExtract") + " " + extractRate + mbt);
        list.add(EnderIO.lang.localize("itemLiquidConduit.tooltip.maxIo") + " " + maxIo + mbt);
        if (itemstack.func_77952_i() == 0) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"enderio.itemLiquidConduit");
        } else if (itemstack.func_77952_i() == 2) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"enderio.itemLiquidConduitEnder");
        }
    }

    @Override
    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        return true;
    }
}

