/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mixin.transformer.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import reborncore.mixin.transformer.util.ClassInfoAccessor;
import reborncore.mixin.transformer.util.ConstInfoAccessor;
import reborncore.mixin.transformer.util.MemberRefInfoAccessor;

public class ConstPoolEditor {
    private static Method getItem;
    private static Method addItem;
    private static Method addItem0;
    private static Field items;
    private static Field cache;
    private static Field numItems;
    private static Field objects;
    private static Field elements;
    private static Method methodWritePool;
    private static Constructor<ConstPool> constructorPool;
    private ConstPool pool;

    public ConstPoolEditor(ConstPool pool) {
        this.pool = pool;
    }

    public void writePool(DataOutputStream out) {
        try {
            methodWritePool.invoke((Object)this.pool, out);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public static ConstPool readPool(DataInputStream in) {
        try {
            return constructorPool.newInstance(in);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public String getMemberrefClassname(int memberrefIndex) {
        return Descriptor.toJvmName(this.pool.getClassInfo(this.pool.getMemberClass(memberrefIndex)));
    }

    public String getMemberrefName(int memberrefIndex) {
        return this.pool.getUtf8Info(this.pool.getNameAndTypeName(this.pool.getMemberNameAndType(memberrefIndex)));
    }

    public String getMemberrefType(int memberrefIndex) {
        return this.pool.getUtf8Info(this.pool.getNameAndTypeDescriptor(this.pool.getMemberNameAndType(memberrefIndex)));
    }

    public ConstInfoAccessor getItem(int index) {
        try {
            Object entry = getItem.invoke((Object)this.pool, index);
            if (entry == null) {
                return null;
            }
            return new ConstInfoAccessor(entry);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public int addItem(Object item) {
        try {
            return (Integer)addItem.invoke((Object)this.pool, item);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public int addItemForceNew(Object item) {
        try {
            return (Integer)addItem0.invoke((Object)this.pool, item);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public void removeLastItem() {
        try {
            Object item;
            HashMap cache = this.getCache();
            if (cache != null) {
                item = this.getItem(this.pool.getSize() - 1);
                cache.remove(item);
            }
            item = items.get(this.pool);
            Object[][] object = (Object[][])objects.get(items);
            int numElements = (Integer)elements.get(items) - 1;
            int nth = numElements >> 7;
            int offset = numElements & 0x7F;
            object[nth][offset] = null;
            elements.set(item, numElements);
            numItems.set(this.pool, (Integer)numItems.get(this.pool) - 1);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public HashMap getCache() {
        try {
            return (HashMap)cache.get(this.pool);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public void changeMemberrefNameAndType(int memberrefIndex, String newName, String newType) {
        try {
            Object item = this.getItem(memberrefIndex).getItem();
            HashMap cache = this.getCache();
            if (cache != null) {
                cache.remove(item);
            }
            new MemberRefInfoAccessor(item).setNameAndTypeIndex(this.pool.addNameAndTypeInfo(newName, newType));
            if (cache != null) {
                cache.put(item, item);
            }
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
        assert (newName.equals(this.getMemberrefName(memberrefIndex)));
        assert (newType.equals(this.getMemberrefType(memberrefIndex)));
    }

    public void changeClassName(int classNameIndex, String newName) {
        try {
            Object item = this.getItem(classNameIndex).getItem();
            HashMap cache = this.getCache();
            if (cache != null) {
                cache.remove(item);
            }
            new ClassInfoAccessor(item).setNameIndex(this.pool.addUtf8Info(newName));
            if (cache != null) {
                cache.put(item, item);
            }
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public static ConstPool newConstPool() {
        ConstPool pool = new ConstPool("a");
        ConstPoolEditor editor = new ConstPoolEditor(pool);
        int size = pool.getSize();
        for (int i = 0; i < size - 1; ++i) {
            editor.removeLastItem();
        }
        assert (pool.getSize() == 1);
        assert (editor.getItem(0) == null);
        assert (editor.getItem(1) == null);
        assert (editor.getItem(2) == null);
        assert (editor.getItem(3) == null);
        editor.getCache().clear();
        return pool;
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < this.pool.getSize(); ++i) {
            buf.append(String.format("%4d", i));
            buf.append("   ");
            buf.append(this.getItem(i).toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    static {
        try {
            getItem = ConstPool.class.getDeclaredMethod("getItem", Integer.TYPE);
            getItem.setAccessible(true);
            addItem = ConstPool.class.getDeclaredMethod("addItem", Class.forName("javassist.bytecode.ConstInfo"));
            addItem.setAccessible(true);
            addItem0 = ConstPool.class.getDeclaredMethod("addItem0", Class.forName("javassist.bytecode.ConstInfo"));
            addItem0.setAccessible(true);
            items = ConstPool.class.getDeclaredField("items");
            items.setAccessible(true);
            cache = ConstPool.class.getDeclaredField("itemsCache");
            cache.setAccessible(true);
            numItems = ConstPool.class.getDeclaredField("numOfItems");
            numItems.setAccessible(true);
            objects = Class.forName("javassist.bytecode.LongVector").getDeclaredField("objects");
            objects.setAccessible(true);
            elements = Class.forName("javassist.bytecode.LongVector").getDeclaredField("elements");
            elements.setAccessible(true);
            methodWritePool = ConstPool.class.getDeclaredMethod("write", DataOutputStream.class);
            methodWritePool.setAccessible(true);
            constructorPool = ConstPool.class.getDeclaredConstructor(DataInputStream.class);
            constructorPool.setAccessible(true);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

