/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.microblock;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import reborncore.mcmultipart.microblock.IMicroMaterial;
import reborncore.mcmultipart.microblock.IMicroblock;
import reborncore.mcmultipart.microblock.MicroblockDelegate;

public class BlockMicroMaterial
implements IMicroMaterial {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Function<Map.Entry<IProperty<?>, Comparable<?>>, String> MAP_ENTRY_TO_STRING = new Function<Map.Entry<IProperty<?>, Comparable<?>>, String>(){

        public String apply(Map.Entry<IProperty<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            IProperty<?> iproperty = entry.getKey();
            return iproperty.func_177701_a() + "=" + iproperty.func_177702_a(entry.getValue());
        }
    };
    private final IBlockState blockState;
    private final float hardness;
    private final String name;

    public BlockMicroMaterial(IBlockState blockState) {
        this(blockState, ((Float)ReflectionHelper.getPrivateValue(Block.class, (Object)blockState.func_177230_c(), (String[])new String[]{"blockHardness", "field_149782_v"})).floatValue());
    }

    public BlockMicroMaterial(IBlockState blockState, float hardness) {
        this.blockState = blockState;
        this.hardness = hardness;
        this.name = this.genName();
    }

    private BlockMicroMaterial(BlockMicroMaterial material) {
        this.blockState = material.blockState;
        this.hardness = material.hardness;
        this.name = material.name;
    }

    private final String genName() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(Block.field_149771_c.func_177774_c((Object)this.blockState.func_177230_c()));
        if (!this.blockState.func_177228_b().isEmpty()) {
            stringbuilder.append("[");
            COMMA_JOINER.appendTo(stringbuilder, Iterables.transform((Iterable)this.blockState.func_177228_b().entrySet(), MAP_ENTRY_TO_STRING));
            stringbuilder.append("]");
        }
        return stringbuilder.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocalizedName() {
        return this.getItem().func_82833_r();
    }

    @Override
    public boolean isSolid() {
        return this.blockState.func_185917_h();
    }

    @Override
    public int getLightValue() {
        return this.blockState.func_185906_d();
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    public int getSawStrength() {
        return this.blockState.func_177230_c().getHarvestLevel(this.blockState);
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack(this.blockState.func_177230_c(), 1, this.blockState.func_177230_c().func_176201_c(this.blockState));
    }

    @Override
    public SoundType getSound() {
        return this.blockState.func_177230_c().func_185467_w();
    }

    @Override
    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return this.blockState.func_177230_c().canRenderInLayer(this.getDefaultMaterialState(), layer);
    }

    @Override
    public IBlockState getDefaultMaterialState() {
        return this.blockState;
    }

    @Override
    public IBlockState getMaterialState(IBlockAccess world, BlockPos pos, IMicroblock microblock) {
        return this.blockState;
    }

    public DelegatedBlockMicroMaterial withDelegate(Function<Tuple<IMicroblock, Boolean>, MicroblockDelegate> delegateFactory) {
        return new DelegatedBlockMicroMaterial(this, delegateFactory);
    }

    public static class DelegatedBlockMicroMaterial
    extends BlockMicroMaterial
    implements IMicroMaterial.IDelegatedMicroMaterial {
        private final Function<Tuple<IMicroblock, Boolean>, MicroblockDelegate> delegateFactory;

        private DelegatedBlockMicroMaterial(BlockMicroMaterial material, Function<Tuple<IMicroblock, Boolean>, MicroblockDelegate> delegateFactory) {
            super(material);
            this.delegateFactory = delegateFactory;
        }

        @Override
        public MicroblockDelegate provideDelegate(IMicroblock microblock, boolean isRemote) {
            return (MicroblockDelegate)this.delegateFactory.apply((Object)new Tuple((Object)microblock, (Object)isRemote));
        }
    }
}

