/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.registry;

import com.valkyrieofnight.environmentaltech.api.modifier.IModifierBlock;
import com.valkyrieofnight.environmentaltech.api.registry.IModifierRegistry;
import java.util.ArrayList;
import java.util.List;

public class ModifierRegistry
implements IModifierRegistry {
    private List<IModifierBlock> registry = new ArrayList<IModifierBlock>();
    private static ModifierRegistry instance;

    public static ModifierRegistry getInstance() {
        if (instance == null) {
            instance = new ModifierRegistry();
        }
        return instance;
    }

    private ModifierRegistry() {
    }

    @Override
    public boolean registerModifier(IModifierBlock modifier) {
        if (!this.modifierExists(modifier)) {
            this.registry.add(modifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean modifierExists(IModifierBlock modifier) {
        return this.getModifier(modifier.getModifierName()) != null;
    }

    @Override
    public IModifierBlock getModifier(String modName) {
        for (IModifierBlock iModifierBlock : this.registry) {
            if (!iModifierBlock.getModifierName().equalsIgnoreCase(modName)) continue;
            return iModifierBlock;
        }
        return null;
    }
}

