/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.quartzchests.block.entity;

import dev.latvian.mods.quartzchests.block.entity.ColorType;
import dev.latvian.mods.quartzchests.block.entity.QuartzChestsBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class QuartzChestEntity
extends TileEntity
implements INameable,
ITickableTileEntity {
    private boolean isDirty = false;
    private boolean sendUpdate = false;
    public double lidAngle;
    public double prevLidAngle;
    public String label = "";
    public int[] colors = new int[ColorType.VALUES.length];
    public ItemStack icon;
    public ItemStackHandler inventory;
    private final LazyOptional<IItemHandler> inventoryCap;
    public int openContainers;
    public boolean textGlow;
    public boolean textBold;
    public boolean textItalic;
    public boolean keepInventory;

    public QuartzChestEntity() {
        super((TileEntityType)QuartzChestsBlockEntities.CHEST.get());
        for (ColorType type : ColorType.VALUES) {
            this.colors[type.index] = type.defaultColor;
        }
        this.icon = ItemStack.field_190927_a;
        this.inventory = new ItemStackHandler(54){

            protected void onContentsChanged(int slot) {
                QuartzChestEntity.this.isDirty = true;
            }
        };
        this.inventoryCap = LazyOptional.of(() -> this.inventory);
        this.openContainers = 0;
        this.textGlow = false;
        this.textBold = false;
        this.textItalic = false;
        this.keepInventory = false;
    }

    public void writeVisualData(CompoundNBT nbt) {
        if (!this.label.isEmpty()) {
            nbt.func_74778_a("label", this.label);
        }
        for (ColorType type : ColorType.VALUES) {
            int n = type.index;
            this.colors[n] = this.colors[n] & 0xFFFFFF;
            if (this.colors[type.index] == type.defaultColor) continue;
            nbt.func_74768_a(type.nbt, this.colors[type.index]);
        }
        if (!this.icon.func_190926_b()) {
            nbt.func_218657_a("icon", (INBT)this.icon.func_77955_b(new CompoundNBT()));
        }
        if (this.textGlow) {
            nbt.func_74757_a("text_glow", true);
        }
        if (this.textBold) {
            nbt.func_74757_a("text_bold", true);
        }
        if (this.textItalic) {
            nbt.func_74757_a("text_italic", true);
        }
        if (this.keepInventory) {
            nbt.func_74757_a("keep_inventory", true);
        }
    }

    public void writeData(CompoundNBT nbt) {
        this.writeVisualData(nbt);
        ListNBT items = this.inventory.serializeNBT().func_150295_c("Items", 10);
        if (!items.isEmpty()) {
            nbt.func_218657_a("items", (INBT)items);
        }
    }

    public void readVisualData(CompoundNBT nbt) {
        this.label = nbt.func_74779_i("label");
        for (ColorType type : ColorType.VALUES) {
            this.colors[type.index] = type.defaultColor;
            if (!nbt.func_74764_b(type.nbt)) continue;
            this.colors[type.index] = 0xFFFFFF & nbt.func_74762_e(type.nbt);
        }
        this.icon = nbt.func_74764_b("icon") ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("icon")) : ItemStack.field_190927_a;
        this.textGlow = nbt.func_74767_n("text_glow");
        this.textBold = nbt.func_74767_n("text_bold");
        this.textItalic = nbt.func_74767_n("text_italic");
        this.keepInventory = nbt.func_74767_n("keep_inventory");
    }

    public void readData(CompoundNBT nbt) {
        this.readVisualData(nbt);
        ListNBT items = nbt.func_150295_c("items", 10);
        this.inventory.setSize(54);
        CompoundNBT invNBT = new CompoundNBT();
        invNBT.func_218657_a("Items", (INBT)items);
        this.inventory.deserializeNBT(invNBT);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.writeData(nbt);
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.readData(nbt);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.writeVisualData(nbt);
        if (this.openContainers > 0) {
            nbt.func_74777_a("open_containers", (short)this.openContainers);
        }
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readVisualData(pkt.func_148857_g());
        this.openContainers = pkt.func_148857_g().func_74765_d("open_containers");
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        this.func_230337_a_(state, nbt);
    }

    public ITextComponent func_200200_C_() {
        return this.label.isEmpty() ? new TranslationTextComponent("block.quartzchests.chest.label.unnamed") : new StringTextComponent(this.label);
    }

    public boolean func_145818_k_() {
        return !this.label.isEmpty();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.label.isEmpty() ? null : new StringTextComponent(this.label);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_70296_d() {
        this.sendUpdate = true;
        this.isDirty = true;
    }

    public void containerOpened() {
        ++this.openContainers;
        this.sendUpdate = true;
    }

    public void containerClosed() {
        --this.openContainers;
        if (this.openContainers < 0) {
            this.openContainers = 0;
        }
        this.sendUpdate = true;
    }

    public void func_73660_a() {
        this.prevLidAngle = this.lidAngle;
        if (this.openContainers > 0 && this.lidAngle == 0.0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.openContainers == 0 && this.lidAngle > 0.0 || this.openContainers > 0 && this.lidAngle < 1.0) {
            double a = this.lidAngle;
            this.lidAngle = this.openContainers > 0 ? (this.lidAngle += 0.1) : (this.lidAngle -= 0.1);
            if (this.lidAngle > 1.0) {
                this.lidAngle = 1.0;
            }
            if (this.lidAngle < 0.5 && a >= 0.5) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0) {
                this.lidAngle = 0.0;
            }
        }
        if (this.isDirty && this.field_145850_b != null) {
            this.isDirty = false;
            this.func_145836_u();
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
        if (this.sendUpdate && this.field_145850_b != null) {
            this.sendUpdate = false;
            BlockState state = this.func_195044_w();
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3, 512);
        }
    }
}

