/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.DecimalFormat;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

class CommandTps {
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("########0.000");
    private static final long[] UNLOADED = new long[]{0L};

    CommandTps() {
    }

    static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tps").requires(cs -> cs.func_197034_c(0))).then(Commands.func_197056_a((String)"dim", (ArgumentType)DimensionArgument.func_212595_a()).executes(ctx -> CommandTps.sendTime((CommandSource)ctx.getSource(), DimensionArgument.func_212592_a((CommandContext)ctx, (String)"dim"))))).executes(ctx -> {
            for (ServerWorld dim : ((CommandSource)ctx.getSource()).func_197028_i().func_212370_w()) {
                CommandTps.sendTime((CommandSource)ctx.getSource(), dim);
            }
            double meanTickTime = (double)CommandTps.mean(((CommandSource)ctx.getSource()).func_197028_i().field_71311_j) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.forge.tps.summary.all", new Object[]{TIME_FORMATTER.format(meanTickTime), TIME_FORMATTER.format(meanTPS)}), false);
            return 0;
        });
    }

    private static int sendTime(CommandSource cs, ServerWorld dim) throws CommandSyntaxException {
        long[] times = cs.func_197028_i().getTickTime(dim.func_234923_W_());
        if (times == null) {
            times = UNLOADED;
        }
        MutableRegistry reg = cs.func_241861_q().func_243612_b(Registry.field_239698_ad_);
        double worldTickTime = (double)CommandTps.mean(times) * 1.0E-6;
        double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
        cs.func_197030_a((ITextComponent)new TranslationTextComponent("commands.forge.tps.summary.named", new Object[]{dim.func_234923_W_().func_240901_a_().toString(), reg.func_177774_c((Object)dim.func_230315_m_()), TIME_FORMATTER.format(worldTickTime), TIME_FORMATTER.format(worldTPS)}), false);
        return 1;
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

