/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class TransformationHelper {
    private static final double THRESHOLD = 0.9995;

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public static TransformationMatrix toTransformation(ItemTransformVec3f transform) {
        if (transform.equals((Object)ItemTransformVec3f.field_178366_a)) {
            return TransformationMatrix.func_227983_a_();
        }
        return new TransformationMatrix(transform.field_178365_c, TransformationHelper.quatFromXYZ(transform.field_178364_b, true), transform.field_178363_d, null);
    }

    public static Quaternion quatFromXYZ(Vector3f xyz, boolean degrees) {
        return new Quaternion(xyz.func_195899_a(), xyz.func_195900_b(), xyz.func_195902_c(), degrees);
    }

    public static Quaternion quatFromXYZ(float[] xyz, boolean degrees) {
        return new Quaternion(xyz[0], xyz[1], xyz[2], degrees);
    }

    public static Quaternion makeQuaternion(float[] values) {
        return new Quaternion(values[0], values[1], values[2], values[3]);
    }

    public static Vector3f lerp(Vector3f from, Vector3f to, float progress) {
        Vector3f res = from.func_229195_e_();
        res.func_229190_a_(to, progress);
        return res;
    }

    public static Quaternion slerp(Quaternion v0, Quaternion v1, float t) {
        float dot = v0.func_195889_a() * v1.func_195889_a() + v0.func_195891_b() * v1.func_195891_b() + v0.func_195893_c() * v1.func_195893_c() + v0.func_195894_d() * v1.func_195894_d();
        if (dot < 0.0f) {
            v1 = new Quaternion(-v1.func_195889_a(), -v1.func_195891_b(), -v1.func_195893_c(), -v1.func_195894_d());
            dot = -dot;
        }
        if ((double)dot > 0.9995) {
            float x = MathHelper.func_219799_g((float)t, (float)v0.func_195889_a(), (float)v1.func_195889_a());
            float y = MathHelper.func_219799_g((float)t, (float)v0.func_195891_b(), (float)v1.func_195891_b());
            float z = MathHelper.func_219799_g((float)t, (float)v0.func_195893_c(), (float)v1.func_195893_c());
            float w = MathHelper.func_219799_g((float)t, (float)v0.func_195894_d(), (float)v1.func_195894_d());
            return new Quaternion(x, y, z, w);
        }
        float angle01 = (float)Math.acos(dot);
        float angle0t = angle01 * t;
        float sin0t = MathHelper.func_76126_a((float)angle0t);
        float sin01 = MathHelper.func_76126_a((float)angle01);
        float sin1t = MathHelper.func_76126_a((float)(angle01 - angle0t));
        float s1 = sin0t / sin01;
        float s0 = sin1t / sin01;
        return new Quaternion(s0 * v0.func_195889_a() + s1 * v1.func_195889_a(), s0 * v0.func_195891_b() + s1 * v1.func_195891_b(), s0 * v0.func_195893_c() + s1 * v1.func_195893_c(), s0 * v0.func_195894_d() + s1 * v1.func_195894_d());
    }

    public static TransformationMatrix slerp(TransformationMatrix one, TransformationMatrix that, float progress) {
        return new TransformationMatrix(TransformationHelper.lerp(one.getTranslation(), that.getTranslation(), progress), TransformationHelper.slerp(one.func_227989_d_(), that.func_227989_d_(), progress), TransformationHelper.lerp(one.getScale(), that.getScale(), progress), TransformationHelper.slerp(one.getRightRot(), that.getRightRot(), progress));
    }

    public static boolean epsilonEquals(Vector4f v1, Vector4f v2, float epsilon) {
        return MathHelper.func_76135_e((float)(v1.func_195910_a() - v2.func_195910_a())) < epsilon && MathHelper.func_76135_e((float)(v1.func_195913_b() - v2.func_195913_b())) < epsilon && MathHelper.func_76135_e((float)(v1.func_195914_c() - v2.func_195914_c())) < epsilon && MathHelper.func_76135_e((float)(v1.func_195915_d() - v2.func_195915_d())) < epsilon;
    }

    public static class Deserializer
    implements JsonDeserializer<TransformationMatrix> {
        private static final Vector3f ORIGIN_CORNER = new Vector3f();
        private static final Vector3f ORIGIN_OPPOSING_CORNER = new Vector3f(1.0f, 1.0f, 1.0f);
        private static final Vector3f ORIGIN_CENTER = new Vector3f(0.5f, 0.5f, 0.5f);

        public TransformationMatrix deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                String transform = json.getAsString();
                if (transform.equals("identity")) {
                    return TransformationMatrix.func_227983_a_();
                }
                throw new JsonParseException("TRSR: unknown default string: " + transform);
            }
            if (json.isJsonArray()) {
                return new TransformationMatrix(Deserializer.parseMatrix(json));
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException("TRSR: expected array or object, got: " + json);
            }
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("matrix")) {
                TransformationMatrix ret = new TransformationMatrix(Deserializer.parseMatrix(obj.get("matrix")));
                obj.remove("matrix");
                if (obj.entrySet().size() != 0) {
                    throw new JsonParseException("TRSR: can't combine matrix and other keys");
                }
                return ret;
            }
            Vector3f translation = null;
            Quaternion leftRot = null;
            Vector3f scale = null;
            Quaternion rightRot = null;
            Vector3f origin = ORIGIN_OPPOSING_CORNER;
            if (obj.has("translation")) {
                translation = new Vector3f(Deserializer.parseFloatArray(obj.get("translation"), 3, "Translation"));
                obj.remove("translation");
            }
            if (obj.has("rotation")) {
                leftRot = Deserializer.parseRotation(obj.get("rotation"));
                obj.remove("rotation");
            }
            if (obj.has("scale")) {
                if (!obj.get("scale").isJsonArray()) {
                    try {
                        float s = obj.get("scale").getAsNumber().floatValue();
                        scale = new Vector3f(s, s, s);
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("TRSR scale: expected number or array, got: " + obj.get("scale"));
                    }
                } else {
                    scale = new Vector3f(Deserializer.parseFloatArray(obj.get("scale"), 3, "Scale"));
                }
                obj.remove("scale");
            }
            if (obj.has("post-rotation")) {
                rightRot = Deserializer.parseRotation(obj.get("post-rotation"));
                obj.remove("post-rotation");
            }
            if (obj.has("origin")) {
                origin = Deserializer.parseOrigin(obj);
                obj.remove("origin");
            }
            if (!obj.entrySet().isEmpty()) {
                throw new JsonParseException("TRSR: can either have single 'matrix' key, or a combination of 'translation', 'rotation', 'scale', 'post-rotation', 'origin'");
            }
            TransformationMatrix matrix = new TransformationMatrix(translation, leftRot, scale, rightRot);
            if (!ORIGIN_CENTER.equals((Object)origin)) {
                Vector3f originFromCenter = origin.func_229195_e_();
                originFromCenter.func_195897_a(ORIGIN_CENTER);
                matrix = matrix.applyOrigin(originFromCenter);
            }
            return matrix;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Vector3f parseOrigin(JsonObject obj) {
            Vector3f origin = null;
            JsonElement originElement = obj.get("origin");
            if (originElement.isJsonArray()) {
                return new Vector3f(Deserializer.parseFloatArray(originElement, 3, "Origin"));
            }
            if (!originElement.isJsonPrimitive()) throw new JsonParseException("Origin: expected an array or one of 'center', 'corner', 'opposing-corner'");
            String originString = originElement.getAsString();
            if ("center".equals(originString)) {
                return ORIGIN_CENTER;
            }
            if ("corner".equals(originString)) {
                return ORIGIN_CORNER;
            }
            if (!"opposing-corner".equals(originString)) throw new JsonParseException("Origin: expected one of 'center', 'corner', 'opposing-corner'");
            return ORIGIN_OPPOSING_CORNER;
        }

        public static Matrix4f parseMatrix(JsonElement e) {
            if (!e.isJsonArray()) {
                throw new JsonParseException("Matrix: expected an array, got: " + e);
            }
            JsonArray m = e.getAsJsonArray();
            if (m.size() != 3) {
                throw new JsonParseException("Matrix: expected an array of length 3, got: " + m.size());
            }
            float[] values = new float[16];
            for (int i = 0; i < 3; ++i) {
                if (!m.get(i).isJsonArray()) {
                    throw new JsonParseException("Matrix row: expected an array, got: " + m.get(i));
                }
                JsonArray r = m.get(i).getAsJsonArray();
                if (r.size() != 4) {
                    throw new JsonParseException("Matrix row: expected an array of length 4, got: " + r.size());
                }
                for (int j = 0; j < 4; ++j) {
                    try {
                        values[j * 4 + i] = r.get(j).getAsNumber().floatValue();
                        continue;
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("Matrix element: expected number, got: " + r.get(j));
                    }
                }
            }
            return new Matrix4f(values);
        }

        public static float[] parseFloatArray(JsonElement e, int length, String prefix) {
            if (!e.isJsonArray()) {
                throw new JsonParseException(prefix + ": expected an array, got: " + e);
            }
            JsonArray t = e.getAsJsonArray();
            if (t.size() != length) {
                throw new JsonParseException(prefix + ": expected an array of length " + length + ", got: " + t.size());
            }
            float[] ret = new float[length];
            for (int i = 0; i < length; ++i) {
                try {
                    ret[i] = t.get(i).getAsNumber().floatValue();
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException(prefix + " element: expected number, got: " + t.get(i));
                }
            }
            return ret;
        }

        public static Quaternion parseAxisRotation(JsonElement e) {
            Quaternion ret;
            block7: {
                if (!e.isJsonObject()) {
                    throw new JsonParseException("Axis rotation: object expected, got: " + e);
                }
                JsonObject obj = e.getAsJsonObject();
                if (obj.entrySet().size() != 1) {
                    throw new JsonParseException("Axis rotation: expected single axis object, got: " + e);
                }
                Map.Entry entry = (Map.Entry)obj.entrySet().iterator().next();
                try {
                    if (((String)entry.getKey()).equals("x")) {
                        ret = Vector3f.field_229179_b_.func_229187_a_(((JsonElement)entry.getValue()).getAsNumber().floatValue());
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("y")) {
                        ret = Vector3f.field_229181_d_.func_229187_a_(((JsonElement)entry.getValue()).getAsNumber().floatValue());
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("z")) {
                        ret = Vector3f.field_229183_f_.func_229187_a_(((JsonElement)entry.getValue()).getAsNumber().floatValue());
                        break block7;
                    }
                    throw new JsonParseException("Axis rotation: expected single axis key, got: " + (String)entry.getKey());
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException("Axis rotation value: expected number, got: " + entry.getValue());
                }
            }
            return ret;
        }

        public static Quaternion parseRotation(JsonElement e) {
            if (e.isJsonArray()) {
                if (e.getAsJsonArray().get(0).isJsonObject()) {
                    Quaternion ret = Quaternion.field_227060_a_.func_227068_g_();
                    for (JsonElement a : e.getAsJsonArray()) {
                        ret.func_195890_a(Deserializer.parseAxisRotation(a));
                    }
                    return ret;
                }
                if (e.isJsonArray()) {
                    JsonArray array = e.getAsJsonArray();
                    if (array.size() == 3) {
                        return TransformationHelper.quatFromXYZ(Deserializer.parseFloatArray(e, 3, "Rotation"), true);
                    }
                    return TransformationHelper.makeQuaternion(Deserializer.parseFloatArray(e, 4, "Rotation"));
                }
                throw new JsonParseException("Rotation: expected array or object, got: " + e);
            }
            if (e.isJsonObject()) {
                return Deserializer.parseAxisRotation(e);
            }
            throw new JsonParseException("Rotation: expected array or object, got: " + e);
        }
    }
}

