/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gigaherz.packingtape.ConfigValues;
import gigaherz.packingtape.tape.PackagedBlock;
import gigaherz.packingtape.tape.PackagedBlockEntity;
import gigaherz.packingtape.tape.TapeItem;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="packingtape")
public class PackingTapeMod {
    public static final String MODID = "packingtape";
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"packingtape");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"packingtape");
    private static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"packingtape");
    public static final RegistryObject<PackagedBlock> PACKAGED_BLOCK = BLOCKS.register("packaged_block", () -> new PackagedBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200948_a(0.5f, 0.5f).func_200947_a(SoundType.field_185848_a)));
    public static final RegistryObject<TapeItem> TAPE;
    public static Logger logger;

    public PackingTapeMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        modEventBus.addListener(this::serverConfig);
        modEventBus.addListener(this::gatherData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConfigValues.SERVER_SPEC);
    }

    private void gatherData(GatherDataEvent event) {
        DataGen.gatherData(event);
    }

    public void serverConfig(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == ConfigValues.SERVER_SPEC) {
            ConfigValues.bake();
        }
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        ITEMS.register(PACKAGED_BLOCK.getId().func_110623_a(), () -> new BlockItem((Block)PACKAGED_BLOCK.get(), new Item.Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78026_f)));
        TILE_ENTITIES.register(PACKAGED_BLOCK.getId().func_110623_a(), () -> TileEntityType.Builder.func_223042_a(PackagedBlockEntity::new, (Block[])new Block[]{(Block)PACKAGED_BLOCK.get()}).func_206865_a(null));
        TAPE = ITEMS.register("tape", () -> new TapeItem(new Item.Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78026_f)));
        logger = LogManager.getLogger((String)MODID);
    }

    public static class DataGen {
        public static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            if (event.includeServer()) {
                gen.func_200390_a((IDataProvider)new LootTables(gen));
                gen.func_200390_a((IDataProvider)new Recipes(gen));
            }
        }

        private static class LootTables
        extends LootTableProvider
        implements IDataProvider {
            private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(BlockTables::new, (Object)LootParameterSets.field_216267_h));

            public LootTables(DataGenerator gen) {
                super(gen);
            }

            protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
                return this.tables;
            }

            protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
                map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
            }

            public static class BlockTables
            extends BlockLootTables {
                protected void addTables() {
                    this.func_218522_a((Block)PACKAGED_BLOCK.get(), BlockTables::dropWithPackagedContents);
                }

                protected static LootTable.Builder dropWithPackagedContents(Block p_218544_0_) {
                    return LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockTables.func_218560_a((IItemProvider)p_218544_0_, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)p_218544_0_).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Block", "BlockEntityTag.Block").func_216056_a("BlockEntity", "BlockEntityTag.BlockEntity").func_216056_a("PreferredDirection", "BlockEntityTag.PreferredDirection")))));
                }

                protected Iterable<Block> getKnownBlocks() {
                    return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals(PackingTapeMod.MODID)).collect(Collectors.toList());
                }
            }
        }

        private static class Recipes
        extends RecipeProvider
        implements IDataProvider,
        IConditionBuilder {
            public Recipes(DataGenerator gen) {
                super(gen);
            }

            protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
                ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)TAPE.get())).func_200487_b((IItemProvider)Items.field_151123_aH).func_200487_b((IItemProvider)Items.field_151007_F).func_200487_b((IItemProvider)Items.field_151121_aF).func_200483_a("has_slime_ball", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)Items.field_151123_aH)).func_200482_a(consumer);
            }
        }
    }
}

