/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.item;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ItemStackIngredient
extends Ingredient<ItemStack> {
    private ItemStack stack;
    private int count;
    private boolean matchNBT;

    public ItemStackIngredient(@NotNull ItemStack stack, int count, boolean matchNBT) {
        this.stack = stack;
        this.count = count;
        this.matchNBT = matchNBT;
    }

    public ItemStackIngredient(PacketBuffer packet) {
        super(packet);
    }

    @Override
    public boolean test(@NotNull ConditionContainerProvider provider, ItemStack test) {
        if (test == null) {
            return false;
        }
        if (this.matchNBT) {
            return ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)test) && ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)test) && test.func_190916_E() >= this.requestAmount(provider);
        }
        return ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)test) && test.func_190916_E() >= this.requestAmount(provider);
    }

    @Override
    public List<ItemStack> request(@NotNull ConditionContainerProvider provider) {
        ItemStack copy = this.stack.func_77946_l();
        copy.func_190920_e(this.requestAmount(provider));
        return Collections.singletonList(copy);
    }

    @Override
    public int requestAmount(@NotNull ConditionContainerProvider provider) {
        return this.count;
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(ItemStackIngredient.getFromClass(this.getClass()));
        buffer.func_150788_a(this.stack);
        buffer.writeInt(this.count);
        buffer.writeBoolean(this.matchNBT);
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        this.stack = buffer.func_150791_c();
        this.count = buffer.readInt();
        this.matchNBT = buffer.readBoolean();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "{stack:" + this.stack + ",count:" + this.count + "}";
    }
}

