/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.ingredient.item;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.ingredient.Ingredient;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;

public class ItemIngredient
extends Ingredient<ItemStack> {
    private Item ingredient;
    private int count;

    public ItemIngredient(@NotNull Item ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    public ItemIngredient(PacketBuffer packet) {
        super(packet);
    }

    @Override
    public boolean test(@NotNull ConditionContainerProvider provider, ItemStack test) {
        return test != null ? this.ingredient.equals(test.func_77973_b()) && test.func_190916_E() >= this.count : false;
    }

    @Override
    public List<ItemStack> request(@NotNull ConditionContainerProvider provider) {
        return Collections.singletonList(new ItemStack((IItemProvider)this.ingredient, this.requestAmount(provider)));
    }

    @Override
    public int requestAmount(@NotNull ConditionContainerProvider provider) {
        return this.count;
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        buffer.func_180714_a(ItemIngredient.getFromClass(this.getClass()));
        buffer.func_150788_a(new ItemStack((IItemProvider)this.ingredient, this.count));
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        ItemStack i = buffer.func_150791_c();
        this.ingredient = i.func_77973_b();
        this.count = i.func_190916_E();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "{item:" + this.ingredient + ",count:" + this.count + "}";
    }
}

