/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.conditiondata.json;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.valkyrieofnight.vlib.core.io.datapack.IDataRegistryReloader;
import com.valkyrieofnight.vlib.core.io.datapack.JsonDataLoader;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionData;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainer;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionDataContainerHandler;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionID;
import com.valkyrieofnight.vlib.registry.conditiondata.base.ConditionParameters;
import com.valkyrieofnight.vlib.registry.conditiondata.json.JConditionData;
import java.util.HashMap;
import java.util.Map;

public class JConditionDataLoader
extends JsonDataLoader<JConditionData, Handler> {
    private static JConditionDataLoader INST;
    protected static Gson gson;

    public static JConditionDataLoader getInstance() {
        if (INST == null) {
            INST = new JConditionDataLoader();
        }
        return INST;
    }

    public JConditionDataLoader() {
        super("valkyrielib", "conditions", JConditionData.class, Handler.getInstance(), gson);
    }

    @Override
    protected void handleException(VLID id, Exception e) {
        throw new RuntimeException("Condition with id: " + id.toString() + " is invalid", e);
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public static class Handler
    implements IDataRegistryReloader<JConditionData> {
        private static Handler INST;

        public static Handler getInstance() {
            if (INST == null) {
                INST = new Handler();
            }
            return INST;
        }

        private Handler() {
        }

        @Override
        public void reloadData(Map<VLID, JConditionData> loaded) {
            HashMap newMap = Maps.newHashMap();
            for (VLID jid : loaded.keySet()) {
                JConditionData jcd = loaded.get(jid);
                if (StringUtils.isNullOrEmpty(jcd.id)) {
                    System.err.println("Condition at: " + jid + " does not contain valid \"id\" and will be ignored");
                    continue;
                }
                if (jcd.data_type == null) {
                    System.err.println("Condition at: " + jid + " does not have valid \"data_type\" and will be ignored");
                    continue;
                }
                if (jcd.scope == null || jcd.scope.isEmpty()) {
                    System.err.println("Condition at: " + jid + " does not have a valid \"scope\" and will be ignored");
                    continue;
                }
                ConditionID id2 = ConditionID.fromString(jcd.id);
                if (newMap.containsKey(id2)) {
                    System.err.println("Condition with ID: " + id2 + " has duplicates which may cause unexpected behaviour if not removed");
                    continue;
                }
                newMap.put(id2, jcd);
            }
            ConditionDataContainer.Builder builder = ConditionDataContainer.Builder.create();
            newMap.forEach((id, d) -> {
                switch (d.data_type) {
                    case BOOLEAN: {
                        JsonPrimitive bod = d.parameters.getOrDefault((Object)ConditionParameters.DEFAULT, new JsonPrimitive(Boolean.valueOf(false)));
                        builder.addBoolean(new ConditionData.BooleanCondition((ConditionID)id, d.scope, this.getCustomOrDefault(() -> ((JsonPrimitive)bod).isBoolean(), () -> ((JsonPrimitive)bod).getAsBoolean(), false)));
                        break;
                    }
                    case BYTE: {
                        JsonPrimitive bydf = d.parameters.getOrDefault((Object)ConditionParameters.DEFAULT, new JsonPrimitive((Number)0));
                        JsonPrimitive bymi = d.parameters.getOrDefault((Object)ConditionParameters.MIN, new JsonPrimitive((Number)-128));
                        JsonPrimitive bymx = d.parameters.getOrDefault((Object)ConditionParameters.MAX, new JsonPrimitive((Number)127));
                        builder.addByte(new ConditionData.ByteCondition((ConditionID)id, d.scope, this.getCustomOrDefault(() -> ((JsonPrimitive)bydf).isNumber(), () -> ((JsonPrimitive)bydf).getAsByte(), (byte)0), this.getCustomOrDefault(() -> ((JsonPrimitive)bymi).isNumber(), () -> ((JsonPrimitive)bymi).getAsByte(), (byte)-128), this.getCustomOrDefault(() -> ((JsonPrimitive)bymx).isNumber(), () -> ((JsonPrimitive)bymx).getAsByte(), (byte)127)));
                        break;
                    }
                    case SHORT: {
                        JsonPrimitive shdf = d.parameters.getOrDefault((Object)ConditionParameters.DEFAULT, new JsonPrimitive((Number)0));
                        JsonPrimitive shmi = d.parameters.getOrDefault((Object)ConditionParameters.MIN, new JsonPrimitive((Number)Short.MIN_VALUE));
                        JsonPrimitive shma = d.parameters.getOrDefault((Object)ConditionParameters.MAX, new JsonPrimitive((Number)Short.MAX_VALUE));
                        builder.addShort(new ConditionData.ShortCondition((ConditionID)id, d.scope, this.getCustomOrDefault(() -> ((JsonPrimitive)shdf).isNumber(), () -> ((JsonPrimitive)shdf).getAsShort(), (short)0), this.getCustomOrDefault(() -> ((JsonPrimitive)shmi).isNumber(), () -> ((JsonPrimitive)shmi).getAsShort(), (short)Short.MIN_VALUE), this.getCustomOrDefault(() -> ((JsonPrimitive)shma).isNumber(), () -> ((JsonPrimitive)shma).getAsShort(), (short)Short.MAX_VALUE)));
                        break;
                    }
                    case INT: {
                        JsonPrimitive indf = d.parameters.getOrDefault((Object)ConditionParameters.DEFAULT, new JsonPrimitive((Number)0));
                        JsonPrimitive inmi = d.parameters.getOrDefault((Object)ConditionParameters.MIN, new JsonPrimitive((Number)Integer.MIN_VALUE));
                        JsonPrimitive inma = d.parameters.getOrDefault((Object)ConditionParameters.MAX, new JsonPrimitive((Number)Integer.MAX_VALUE));
                        builder.addInt(new ConditionData.IntCondition((ConditionID)id, d.scope, this.getCustomOrDefault(() -> ((JsonPrimitive)indf).isNumber(), () -> ((JsonPrimitive)indf).getAsInt(), 0), this.getCustomOrDefault(() -> ((JsonPrimitive)inmi).isNumber(), () -> ((JsonPrimitive)inmi).getAsInt(), Integer.MIN_VALUE), this.getCustomOrDefault(() -> ((JsonPrimitive)inma).isNumber(), () -> ((JsonPrimitive)inma).getAsInt(), Integer.MAX_VALUE)));
                        break;
                    }
                    case LONG: {
                        JsonPrimitive lodf = d.parameters.getOrDefault((Object)ConditionParameters.DEFAULT, new JsonPrimitive((Number)0L));
                        JsonPrimitive lomi = d.parameters.getOrDefault((Object)ConditionParameters.MIN, new JsonPrimitive((Number)Long.MIN_VALUE));
                        JsonPrimitive loma = d.parameters.getOrDefault((Object)ConditionParameters.MAX, new JsonPrimitive((Number)Long.MAX_VALUE));
                        builder.addLong(new ConditionData.LongCondition((ConditionID)id, d.scope, this.getCustomOrDefault(() -> ((JsonPrimitive)lodf).isNumber(), () -> ((JsonPrimitive)lodf).getAsLong(), 0L), this.getCustomOrDefault(() -> ((JsonPrimitive)lomi).isNumber(), () -> ((JsonPrimitive)lomi).getAsLong(), Long.MIN_VALUE), this.getCustomOrDefault(() -> ((JsonPrimitive)loma).isNumber(), () -> ((JsonPrimitive)loma).getAsLong(), Long.MAX_VALUE)));
                        break;
                    }
                    case FLOAT: {
                        JsonPrimitive fldf = d.parameters.getOrDefault((Object)ConditionParameters.DEFAULT, new JsonPrimitive((Number)Float.valueOf(0.0f)));
                        JsonPrimitive flmi = d.parameters.getOrDefault((Object)ConditionParameters.MIN, new JsonPrimitive((Number)Float.valueOf(Float.MIN_VALUE)));
                        JsonPrimitive flma = d.parameters.getOrDefault((Object)ConditionParameters.MAX, new JsonPrimitive((Number)Float.valueOf(Float.MAX_VALUE)));
                        builder.addFloat(new ConditionData.FloatCondition((ConditionID)id, d.scope, this.getCustomOrDefault(() -> ((JsonPrimitive)fldf).isNumber(), () -> ((JsonPrimitive)fldf).getAsFloat(), Float.valueOf(0.0f)).floatValue(), this.getCustomOrDefault(() -> ((JsonPrimitive)flmi).isNumber(), () -> ((JsonPrimitive)flmi).getAsFloat(), Float.valueOf(Float.MIN_VALUE)).floatValue(), this.getCustomOrDefault(() -> ((JsonPrimitive)flma).isNumber(), () -> ((JsonPrimitive)flma).getAsFloat(), Float.valueOf(Float.MAX_VALUE)).floatValue()));
                        break;
                    }
                    case DOUBLE: {
                        JsonPrimitive dodf = d.parameters.getOrDefault((Object)ConditionParameters.DEFAULT, new JsonPrimitive((Number)0.0));
                        JsonPrimitive domi = d.parameters.getOrDefault((Object)ConditionParameters.MIN, new JsonPrimitive((Number)Double.MIN_VALUE));
                        JsonPrimitive doma = d.parameters.getOrDefault((Object)ConditionParameters.MAX, new JsonPrimitive((Number)Double.MAX_VALUE));
                        builder.addDouble(new ConditionData.DoubleCondition((ConditionID)id, d.scope, this.getCustomOrDefault(() -> ((JsonPrimitive)dodf).isNumber(), () -> ((JsonPrimitive)dodf).getAsDouble(), 0.0), this.getCustomOrDefault(() -> ((JsonPrimitive)domi).isNumber(), () -> ((JsonPrimitive)domi).getAsDouble(), Double.MIN_VALUE), this.getCustomOrDefault(() -> ((JsonPrimitive)doma).isNumber(), () -> ((JsonPrimitive)doma).getAsDouble(), Double.MAX_VALUE)));
                        break;
                    }
                    case STRING: {
                        JsonPrimitive stdf = d.parameters.getOrDefault((Object)ConditionParameters.DEFAULT, new JsonPrimitive(""));
                        builder.addString(new ConditionData.StringCondition((ConditionID)id, d.scope, this.getCustomOrDefault(() -> ((JsonPrimitive)stdf).isString(), () -> ((JsonPrimitive)stdf).getAsString(), "")));
                    }
                }
            });
            ConditionDataContainerHandler.getInstance().reloadData(builder.build());
        }

        public <T> T getCustomOrDefault(Provider<Boolean> typeCheck, Provider<T> correctProvider, T defaultValue) {
            if (typeCheck.request().booleanValue()) {
                return correctProvider.request();
            }
            System.err.println("Returning Default Value");
            return defaultValue;
        }

        public <T> T castOrError(ConditionID id, Object input, T defaultValue, Class<T> cast, boolean printError) {
            T r = defaultValue;
            String error = "";
            boolean errored = false;
            try {
                r = cast.cast(input);
            }
            catch (ClassCastException e) {
                errored = true;
            }
            catch (NullPointerException e) {
                error = "Condition with ID: " + id + " had an unexpected NullPointerException";
                errored = true;
            }
            if (errored && printError) {
                System.err.println(error);
            }
            return r;
        }

        @Override
        public JConditionData merge(JConditionData left, JConditionData right) {
            return left;
        }
    }
}

